/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.mgt.services;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.DataAccessManager;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.mgt.util.Util;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class BillingDataAccessService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(BillingDataAccessService.class);

    public int addSubscription(Subscription subscription) throws Exception {
        DataAccessManager dataAccessManager = Util.getDataAccessManager();
        return dataAccessManager.addSubscription(subscription);
    }

    public void deleteBillingData(int tenantId) throws Exception {
        DataAccessManager dataAccessManager = Util.getDataAccessManager();
        dataAccessManager.deleteBillingData(tenantId);
    }

    public Customer getCustomerWithName(String customerName) throws Exception {
        UserRegistry userRegistry = (UserRegistry)this.getGovernanceUserRegistry();
        int currentTenantId = userRegistry.getTenantId();
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        String currentTenantDomain = tenantManager.getDomain(currentTenantId);
        if (!customerName.equals(currentTenantDomain)) {
            String msg = "Tenant: " + currentTenantDomain + " is trying to get customer object of tenant: " + customerName + ".";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        DataAccessManager dataAccessManager = Util.getDataAccessManager();
        Customer customer = null;
        List customers = dataAccessManager.getCustomersWithName(customerName);
        if (customers.size() > 0) {
            customer = (Customer)customers.get(0);
        }
        return customer;
    }

    public Subscription getSubscription(int subscriptionId) throws Exception {
        DataAccessManager dataAccessManager = Util.getDataAccessManager();
        return dataAccessManager.getSubscription(subscriptionId);
    }

    public Subscription getActiveSubscriptionOfCustomerBySuperTenant(int tenantId) throws Exception {
        return this.getActiveSubscriptionOfCustomer(tenantId);
    }

    public Subscription getActiveSubscriptionOfCustomerByTenant() throws Exception {
        UserRegistry userRegistry = (UserRegistry)this.getGovernanceUserRegistry();
        int tenantId = userRegistry.getTenantId();
        return this.getActiveSubscriptionOfCustomer(tenantId);
    }

    public int getItemIdWithName(String name, int parentId) throws Exception {
        DataAccessManager dataAccessManager = Util.getDataAccessManager();
        return dataAccessManager.getItemIdWithName(name, parentId);
    }

    public boolean changeSubscriptionByTenant(String subscriptionPlan) throws Exception {
        UserRegistry userRegistry = (UserRegistry)this.getGovernanceUserRegistry();
        int tenantId = userRegistry.getTenantId();
        return this.changeSubscription(tenantId, subscriptionPlan);
    }

    public boolean changeSubscriptionBySuperTenant(int customerId, String subscriptionPlan) throws Exception {
        return this.changeSubscription(customerId, subscriptionPlan);
    }

    public Subscription[] getInactiveSubscriptionsOfCustomer(int customerId) throws Exception {
        DataAccessManager dataAccessManager = Util.getDataAccessManager();
        List subscriptions = dataAccessManager.getInactiveSubscriptionsOfCustomer(customerId);
        Subscription[] subscriptionArray = subscriptions != null && subscriptions.size() > 0 ? subscriptions.toArray(new Subscription[subscriptions.size()]) : new Subscription[]{};
        return subscriptionArray;
    }

    public boolean activateSubscription(int subscriptionId) throws Exception {
        DataAccessManager dataAccessManager = Util.getDataAccessManager();
        return dataAccessManager.activateSubscription(subscriptionId);
    }

    public boolean deactivateActiveSubscriptionByTenant() throws Exception {
        UserRegistry registry = (UserRegistry)this.getGovernanceUserRegistry();
        int currentTenantId = registry.getTenantId();
        return this.deactivateActiveSubscription(currentTenantId);
    }

    public boolean deactivateActiveSubscriptionBySuperTenant(int tenantId) throws Exception {
        return this.deactivateActiveSubscription(tenantId);
    }

    private boolean changeSubscription(int tenantId, String subscriptionPlan) throws Exception {
        DataAccessManager dataAccessManager = Util.getDataAccessManager();
        if (dataAccessManager.changeSubscription(tenantId, subscriptionPlan)) {
            try {
                Util.executeThrottlingRules(tenantId);
            }
            catch (Exception e) {
                log.error((Object)("Error occurred executing throttling rules after updating the subscription to " + subscriptionPlan + ". " + e.toString()));
            }
            return true;
        }
        return false;
    }

    private Subscription getActiveSubscriptionOfCustomer(int tenantId) throws Exception {
        DataAccessManager dataAccessManager = Util.getDataAccessManager();
        return dataAccessManager.getActiveSubscriptionOfCustomer(tenantId);
    }

    private boolean deactivateActiveSubscription(int tenantId) throws Exception {
        DataAccessManager dataAccessManager = Util.getDataAccessManager();
        return dataAccessManager.deactivateActiveSubscription(tenantId);
    }

    public boolean changeSubscriptionForTenant(String subscriptionPlan, String tenantDomain) throws Exception {
        int tenantId = Util.getRealmService().getTenantManager().getTenantId(tenantDomain);
        return this.changeSubscription(tenantId, subscriptionPlan);
    }
}

