/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.billing.core.BillingManager;
import org.wso2.carbon.billing.mgt.util.Util;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.usage.api.TenantUsageRetriever;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class MultitenancyBillingServiceComponent {
    private static Log log = LogFactory.getLog(MultitenancyBillingServiceComponent.class);
    private static ConfigurationContextService contextService;

    protected void activate(ComponentContext context) {
        try {
            Util.registerSubscriptionFeedingHandlers(context.getBundleContext());
            Util.scheduleBilling();
            Util.registerBillingInfo(context.getBundleContext());
            Util.initDataAccessManager();
            Util.initializeThrottling(context.getBundleContext());
            Util.registerTenantBillingService(context.getBundleContext());
            log.debug((Object)"******* Multitenancy Billing bundle is activated ******* ");
        }
        catch (Throwable e) {
            log.error((Object)"******* Multitenancy Billing bundle failed activating ****", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Multitenancy Billing is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        Util.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Util.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        Util.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        Util.setRealmService(null);
    }

    public void setBillingManager(BillingManager billingManager) {
        log.debug((Object)"Receiving billingManager service");
        Util.setBillingManager(billingManager);
    }

    public void unsetBillingManager(BillingManager billingManager) {
        log.debug((Object)"Unsetting billingManager service");
        Util.setBillingManager(null);
    }

    public void setTenantUsageRetriever(TenantUsageRetriever tenantUsageRetriever) {
        log.debug((Object)"Setting Tenant Usage Retriever service");
        Util.setTenantUsageRetriever(tenantUsageRetriever);
    }

    public void unsetTenantUsageRetriever(TenantUsageRetriever tenantUsageRetriever) {
        log.debug((Object)"Unsetting Tenant Usage Retriever service");
        Util.setBillingManager(null);
    }
}

