/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.mgt.handlers;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingEngineContext;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingHandler;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.core.jdbc.DataAccessObject;
import org.wso2.carbon.billing.core.utilities.CustomerUtils;
import org.wso2.carbon.billing.mgt.api.MultitenancyBillingInfo;
import org.wso2.carbon.billing.mgt.dataobjects.MultitenancyCustomer;
import org.wso2.carbon.billing.mgt.dataobjects.MultitenancyPackage;
import org.wso2.carbon.billing.mgt.util.Util;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.usage.beans.TenantUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultitenancySubscriptionFeedingHandler
implements BillingHandler {
    private static final Log log = LogFactory.getLog(MultitenancySubscriptionFeedingHandler.class);
    private Map<Integer, MultitenancyPackage> multitenancyPackagesMap = new HashMap<Integer, MultitenancyPackage>();

    public void init(Map<String, String> handlerConfig) throws BillingException {
        DataAccessObject dataAccessObject = Util.getBillingManager().getDataAccessObject();
        MultitenancyBillingInfo billingInfo = Util.getMultitenancyBillingInfo();
        List<MultitenancyPackage> multitenancyPackages = billingInfo.getMultitenancyPackages();
        try {
            dataAccessObject.beginTransaction();
            for (MultitenancyPackage multitenancyPackage : multitenancyPackages) {
                int itemId = dataAccessObject.getItemIdWithName(multitenancyPackage.getName());
                if (itemId == -1) {
                    itemId = dataAccessObject.addItem((Item)multitenancyPackage);
                }
                multitenancyPackage.setId(itemId);
                this.multitenancyPackagesMap.put(itemId, multitenancyPackage);
                for (Item item : multitenancyPackage.getChildren()) {
                    int subItemId = dataAccessObject.getItemId(item.getName(), itemId);
                    if (subItemId == -1) {
                        subItemId = dataAccessObject.addItem(item);
                    }
                    item.setId(subItemId);
                }
            }
            dataAccessObject.commitTransaction();
        }
        catch (Exception e) {
            dataAccessObject.rollbackTransaction();
            log.error((Object)e.getMessage());
            throw new BillingException(e.getMessage(), e);
        }
    }

    public void execute(BillingEngineContext handlerContext) throws BillingException {
        this.feedSubscriptions(handlerContext);
    }

    private void feedSubscriptions(BillingEngineContext handlerContext) throws BillingException {
        String filter = handlerContext.getTaskConfiguration().getSubscriptionFilter();
        Customer customer = handlerContext.getCustomer();
        List<Subscription> subscriptions = this.getSubscriptions(filter, customer);
        Date endDate = new Date();
        Iterator<Subscription> iterator = subscriptions.iterator();
        while (iterator.hasNext()) {
            Subscription subscription = iterator.next();
            if (subscription.isActive() || !subscription.getActiveUntil().after(endDate)) continue;
            iterator.remove();
        }
        handlerContext.setSubscriptions(subscriptions);
        String infoMsg = "Subscription feeding phase completed. ";
        infoMsg = subscriptions != null ? infoMsg + subscriptions.size() + " subscriptions fed. " : infoMsg + "0 subscriptions fed. ";
        log.info((Object)infoMsg);
        if (customer != null && subscriptions != null && subscriptions.size() > 0) {
            Subscription subscription = subscriptions.get(0);
            handlerContext.setCustomer(subscription.getCustomer());
        }
    }

    private Item getItem(int itemId, boolean isSubscriptionActive) {
        return new MultitenancyPackage(this.multitenancyPackagesMap.get(itemId), isSubscriptionActive);
    }

    private Customer getCustomer(int customerId) throws BillingException {
        MultitenancyCustomer customer = new MultitenancyCustomer();
        CustomerUtils.fillCustomerData((int)customerId, (Customer)customer);
        customer.setTenantId(customerId);
        this.fillTenantUsage(customer);
        return customer;
    }

    private void fillTenantUsage(MultitenancyCustomer customer) throws BillingException {
        Calendar calendar = Calendar.getInstance();
        String monthString = CommonUtil.getMonthString((Calendar)calendar);
        try {
            int tenantId = customer.getTenantId();
            TenantUsage usage = Util.getTenantUsageRetriever().getTenantUsage(tenantId, monthString);
            long currentDataCapacity = usage.getRegistryContentCapacity();
            long historyDataCapacity = usage.getRegistryContentHistoryCapacity();
            customer.setCurrentStorage(currentDataCapacity);
            customer.setHistoryStorage(historyDataCapacity);
            customer.setTotalStorage(currentDataCapacity + historyDataCapacity);
            long incomingBW = usage.getTotalIncomingBandwidth();
            long outgoingBW = usage.getTotalOutgoingBandwidth();
            customer.setIncomingBandwidth(incomingBW);
            customer.setOutgoingBandwidth(outgoingBW);
            customer.setTotalBandwidth(incomingBW + outgoingBW);
            log.debug((Object)("Customer: " + customer.getTenantId() + " - Data Capacity: " + customer.getTotalStorage()));
            customer.setNumberOfUsers(usage.getNumberOfUsers());
        }
        catch (Exception e) {
            String msg = "Error in getting the tenant usage for customer name: " + customer.getName() + ".";
            log.error((Object)msg);
            throw new BillingException(msg, e);
        }
    }

    private List<Subscription> getSubscriptions(String filter, Customer customer) throws BillingException {
        DataAccessObject dataAccessObject = Util.getBillingManager().getDataAccessObject();
        List subscriptions = null;
        HashMap<Integer, Customer> customersCash = new HashMap<Integer, Customer>();
        try {
            dataAccessObject.beginTransaction();
            subscriptions = customer == null ? dataAccessObject.getFilteredActiveSubscriptions(filter) : dataAccessObject.getFilteredActiveSubscriptionsForCustomer(filter, customer);
            if (subscriptions != null && subscriptions.size() > 0) {
                for (Subscription subscription : subscriptions) {
                    Customer dummyCustomer = subscription.getCustomer();
                    int customerId = dummyCustomer.getId();
                    Customer correctCustomer = (Customer)customersCash.get(customerId);
                    if (correctCustomer == null) {
                        correctCustomer = this.getCustomer(customerId);
                        customersCash.put(customerId, correctCustomer);
                    }
                    subscription.setCustomer(correctCustomer);
                    Item dummyItem = subscription.getItem();
                    Item correctItem = this.getItem(dummyItem.getId(), subscription.isActive());
                    subscription.setItem(correctItem);
                }
            }
            dataAccessObject.commitTransaction();
        }
        catch (Exception e) {
            dataAccessObject.rollbackTransaction();
            String msg = "Error occurred while getting subscription: " + filter;
            if (customer != null) {
                msg = msg + " for customer: " + customer.getName();
            }
            log.error((Object)msg);
            throw new BillingException(msg, e);
        }
        return subscriptions;
    }
}

