/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.mgt.dataobjects;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.billing.core.dataobjects.Cash;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.mgt.dataobjects.MultitenancyPackageSubItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultitenancyPackage
extends Item {
    public static final String SUBSCRIPTION_SUB_ITEM_NAME = "subscription";
    public static final String BW_OVERUSE_SUB_ITEM_NAME = "bwOveruse";
    public static final String STORAGE_OVERUSE_SUB_ITEM_NAME = "storageOveruse";
    private int usersLimit;
    private Cash subscriptionCharge;
    private Cash chargePerUser;
    private List<MultitenancyPackageSubItem> subItems;

    public MultitenancyPackage() {
        this.subItems = new ArrayList<MultitenancyPackageSubItem>();
        MultitenancyPackageSubItem subscriptionSubItem = new MultitenancyPackageSubItem();
        subscriptionSubItem.setName(SUBSCRIPTION_SUB_ITEM_NAME);
        subscriptionSubItem.setDescription("Subscription for package");
        subscriptionSubItem.setParent(this);
        this.subItems.add(subscriptionSubItem);
        MultitenancyPackageSubItem bandwdithOverUseSubItem = new MultitenancyPackageSubItem();
        bandwdithOverUseSubItem.setName(BW_OVERUSE_SUB_ITEM_NAME);
        bandwdithOverUseSubItem.setDescription("Bandwidth overuse");
        bandwdithOverUseSubItem.setParent(this);
        this.subItems.add(bandwdithOverUseSubItem);
        MultitenancyPackageSubItem storageOverUseSubItem = new MultitenancyPackageSubItem();
        storageOverUseSubItem.setName(STORAGE_OVERUSE_SUB_ITEM_NAME);
        storageOverUseSubItem.setDescription("Storage overuse");
        storageOverUseSubItem.setParent(this);
        this.subItems.add(storageOverUseSubItem);
    }

    public MultitenancyPackage(MultitenancyPackage staticMtPackage, boolean isSubscriptionActive) {
        this.usersLimit = staticMtPackage.getUsersLimit();
        this.chargePerUser = staticMtPackage.getChargePerUser();
        this.subscriptionCharge = staticMtPackage.getSubscriptionCharge();
        super.setResourceVolumeLimit(staticMtPackage.getResourceVolumeLimit());
        super.setResourceVolumeOveruseCharge(staticMtPackage.getResourceVolumeOveruseCharge());
        super.setBandwidthLimit(staticMtPackage.getBandwidthLimit());
        super.setBandwidthOveruseCharge(staticMtPackage.getBandwidthOveruseCharge());
        this.setId(staticMtPackage.getId());
        this.setName(staticMtPackage.getName());
        this.setCost(staticMtPackage.getCost());
        this.setDescription(staticMtPackage.getDescription());
        this.subItems = new ArrayList<MultitenancyPackageSubItem>();
        for (Item item : staticMtPackage.getChildren()) {
            if (!isSubscriptionActive && (isSubscriptionActive || !SUBSCRIPTION_SUB_ITEM_NAME.equals(item.getName()))) continue;
            MultitenancyPackageSubItem subscriptionSubItem = new MultitenancyPackageSubItem();
            subscriptionSubItem.setId(item.getId());
            subscriptionSubItem.setName(item.getName());
            subscriptionSubItem.setDescription(item.getDescription());
            subscriptionSubItem.setParent(this);
            this.subItems.add(subscriptionSubItem);
        }
    }

    public int getUsersLimit() {
        return this.usersLimit;
    }

    public void setUsersLimit(int usersLimit) {
        this.usersLimit = usersLimit;
    }

    public Cash getChargePerUser() {
        return this.chargePerUser;
    }

    public void setChargePerUser(Cash chargePerUser) {
        this.chargePerUser = chargePerUser;
    }

    public Cash getSubscriptionCharge() {
        return this.subscriptionCharge;
    }

    public void setSubscriptionCharge(Cash subscriptionCharge) {
        this.subscriptionCharge = subscriptionCharge;
    }

    public List<? extends Item> getChildren() {
        return this.subItems;
    }
}

