/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.mgt.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.dataobjects.Cash;
import org.wso2.carbon.billing.mgt.dataobjects.MultitenancyPackage;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.utils.CarbonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultitenancyBillingInfo {
    private static Log log = LogFactory.getLog(MultitenancyBillingInfo.class);
    private static final String PACKAGE_DESCRIPTION_CONFIG_FILENAME = "multitenancy-packages.xml";
    private static final String PACKAGE_DESCRIPTION_CONFIG_NS = "http://wso2.com/carbon/multitenancy/billing/pacakges";
    List<MultitenancyPackage> multitenancyPackages = this.deserializePackageDescriptionConfig();

    public List<MultitenancyPackage> getMultitenancyPackages() {
        return this.multitenancyPackages;
    }

    private List<MultitenancyPackage> deserializePackageDescriptionConfig() throws BillingException {
        OMElement packageConfigs;
        String configFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + PACKAGE_DESCRIPTION_CONFIG_FILENAME;
        try {
            packageConfigs = CommonUtil.buildOMElement((InputStream)new FileInputStream(configFilePath));
        }
        catch (Exception e) {
            String msg = "Error in deserializing the packageConfigs file: " + configFilePath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        Iterator packageConfigsChildsIt = packageConfigs.getChildElements();
        while (packageConfigsChildsIt.hasNext()) {
            OMElement packageConfigEle = (OMElement)packageConfigsChildsIt.next();
            if (!new QName(PACKAGE_DESCRIPTION_CONFIG_NS, "package").equals(packageConfigEle.getQName())) continue;
            MultitenancyPackage multitenancyPackage = new MultitenancyPackage();
            String packageName = packageConfigEle.getAttributeValue(new QName("name"));
            String subscriptionCharge = this.getPackageConfigValue("subscriptionCharge", packageConfigEle);
            String usersLimit = this.getPackageConfigValue("users.limit", packageConfigEle);
            String usersCharge = this.getPackageConfigValue("users.charge", packageConfigEle);
            String resourceVolumeLimit = this.getPackageConfigValue("resourceVolume.limit", packageConfigEle);
            String resourceVolumeOveruseCharge = this.getPackageConfigValue("resourceVolume.overuseCharge", packageConfigEle);
            String bandwidthLimit = this.getPackageConfigValue("bandwidth.limit", packageConfigEle);
            String bandwidthOveruseCharge = this.getPackageConfigValue("bandwidth.overuseCharge", packageConfigEle);
            int usersLimitInt = -1;
            if (!usersLimit.equals("unlimited")) {
                usersLimitInt = Integer.parseInt(usersLimit);
            }
            int resourceVolumeLimitInt = -1;
            if (!resourceVolumeLimit.equals("unlimited")) {
                resourceVolumeLimitInt = Integer.parseInt(resourceVolumeLimit);
            }
            int bandwidthLimitInt = -1;
            if (!bandwidthLimit.equals("unlimited")) {
                bandwidthLimitInt = Integer.parseInt(bandwidthLimit);
            }
            multitenancyPackage.setName(packageName);
            multitenancyPackage.setSubscriptionCharge(new Cash(subscriptionCharge));
            multitenancyPackage.setUsersLimit(usersLimitInt);
            multitenancyPackage.setChargePerUser(new Cash(usersCharge));
            multitenancyPackage.setResourceVolumeLimit(resourceVolumeLimitInt);
            multitenancyPackage.setResourceVolumeOveruseCharge(new Cash(resourceVolumeOveruseCharge));
            multitenancyPackage.setBandwidthLimit(bandwidthLimitInt);
            multitenancyPackage.setBandwidthOveruseCharge(new Cash(bandwidthOveruseCharge));
            this.multitenancyPackages.add(multitenancyPackage);
        }
        return this.multitenancyPackages;
    }

    private String getPackageConfigValue(String key, OMElement packageNode) throws BillingException {
        String qualifiedKey = "ns:" + key.replaceAll("\\.", "/ns:");
        try {
            AXIOMXPath xpathExpression = new AXIOMXPath(qualifiedKey);
            xpathExpression.addNamespace("ns", PACKAGE_DESCRIPTION_CONFIG_NS);
            List valueNodes = xpathExpression.selectNodes((Object)packageNode);
            if (valueNodes.isEmpty()) {
                if (log.isDebugEnabled()) {
                    String msg = "No results found parsing package configuration for key: " + qualifiedKey + ".";
                    log.debug((Object)msg);
                }
                return null;
            }
            OMElement valueNode = (OMElement)valueNodes.get(0);
            return valueNode.getText();
        }
        catch (JaxenException e) {
            String msg = "Error in retrieving the key: " + qualifiedKey + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, (Exception)((Object)e));
        }
    }
}

