/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.mgt.api;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.mgt.services.BillingDataAccessService;
import org.wso2.carbon.stratos.common.TenantBillingService;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.internal.CloudCommonServiceComponent;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class DefaultTenantBilling
implements TenantBillingService {
    private static final Log log = LogFactory.getLog(DefaultTenantBilling.class);

    public void addUsagePlan(Tenant tenant, String usagePlan) throws StratosException {
        Customer customer = new Customer();
        customer.setName(tenant.getDomain());
        customer.setEmail(tenant.getEmail());
        customer.setStartedDate(tenant.getCreatedDate());
        customer.setFullName(tenant.getAdminFirstName() + " " + tenant.getAdminLastName());
        customer.setId(tenant.getId());
        Subscription subscription = new Subscription();
        subscription.setCustomer(customer);
        subscription.setActive(false);
        subscription.setActiveSince(Calendar.getInstance().getTime());
        Item item = new Item();
        subscription.setItem(item);
        subscription.setSubscriptionPlan(usagePlan);
        try {
            BillingDataAccessService dataAccessService = new BillingDataAccessService();
            dataAccessService.addSubscription(subscription);
        }
        catch (Exception e) {
            log.error((Object)("Could not add new subscription for tenant: " + tenant.getDomain() + " " + e.getMessage()), (Throwable)e);
        }
    }

    public String getActiveUsagePlan(String tenantDomain) throws StratosException {
        Subscription subscription;
        try {
            TenantManager tenantMan = CloudCommonServiceComponent.getRealmService().getTenantManager();
            int tenantId = tenantMan.getTenantId(tenantDomain);
            BillingDataAccessService billingDataAccessService = new BillingDataAccessService();
            subscription = billingDataAccessService.getActiveSubscriptionOfCustomerBySuperTenant(tenantId);
        }
        catch (Exception e) {
            String msg = "Error occurred while getting the usage plan for tenant: " + tenantDomain + " " + e.getMessage();
            log.error((Object)msg);
            throw new StratosException(msg, (Throwable)e);
        }
        return subscription.getSubscriptionPlan();
    }

    public void updateUsagePlan(String tenantDomain, String usagePlan) throws StratosException {
        try {
            TenantManager tenantManager = CloudCommonServiceComponent.getRealmService().getTenantManager();
            int tenantId = tenantManager.getTenantId(tenantDomain);
            BillingDataAccessService billingDataAccessService = new BillingDataAccessService();
            Subscription currentSubscription = billingDataAccessService.getActiveSubscriptionOfCustomerBySuperTenant(tenantId);
            if (currentSubscription != null && currentSubscription.getSubscriptionPlan() != null) {
                if (!currentSubscription.getSubscriptionPlan().equals(usagePlan)) {
                    boolean updated = billingDataAccessService.changeSubscriptionBySuperTenant(tenantId, usagePlan);
                    if (updated) {
                        log.debug((Object)("Usage plan was changed successfully from " + currentSubscription.getSubscriptionPlan() + " to " + usagePlan));
                    } else {
                        log.debug((Object)"Usage plan was not changed");
                    }
                }
            } else {
                Tenant tenant = tenantManager.getTenant(tenantId);
                if (tenant.isActive()) {
                    Subscription subscription = new Subscription();
                    subscription.setActive(true);
                    subscription.setSubscriptionPlan(usagePlan);
                    subscription.setActiveSince(null);
                    subscription.setActiveUntil(null);
                    Customer customer = new Customer();
                    customer.setName(tenantDomain);
                    customer.setId(tenantId);
                    subscription.setCustomer(customer);
                    int subsId = billingDataAccessService.addSubscription(subscription);
                    if (subsId > 0) {
                        log.info((Object)("Added a new " + subscription.getSubscriptionPlan() + " plan for the tenant " + tenantDomain));
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while changing the subscription plan for tenant: " + tenantDomain;
            log.error((Object)msg, (Throwable)e);
            throw new StratosException(msg, (Throwable)e);
        }
    }

    public void activateUsagePlan(String tenantDomain) throws StratosException {
        try {
            TenantManager tenantManager = CloudCommonServiceComponent.getRealmService().getTenantManager();
            int tenantId = tenantManager.getTenantId(tenantDomain);
            BillingDataAccessService dataAccessService = new BillingDataAccessService();
            Subscription subscription = dataAccessService.getActiveSubscriptionOfCustomerBySuperTenant(tenantId);
            if (subscription != null) {
                String msg = "Unable to activate the subscription for tenant: " + tenantId + ". An active subscription already exists";
                log.info((Object)msg);
            } else {
                Subscription[] inactiveSubscriptions = dataAccessService.getInactiveSubscriptionsOfCustomer(tenantId);
                if (inactiveSubscriptions.length == 1) {
                    subscription = inactiveSubscriptions[0];
                    boolean activated = dataAccessService.activateSubscription(subscription.getId());
                    if (activated) {
                        log.info((Object)("Subscription was activated for tenant: " + tenantId));
                    }
                } else if (inactiveSubscriptions.length > 1) {
                    Subscription subscriptionToAdd = inactiveSubscriptions[0];
                    subscriptionToAdd.setActive(true);
                    subscriptionToAdd.setActiveSince(null);
                    subscriptionToAdd.setActiveUntil(null);
                    int subsId = dataAccessService.addSubscription(subscriptionToAdd);
                    if (subsId > 0) {
                        log.info((Object)("New subscription: " + subscriptionToAdd.getSubscriptionPlan() + " added and it was activated for tenant: " + tenantId));
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while activating the subscription for tenant: " + tenantDomain;
            log.error((Object)msg, (Throwable)e);
            throw new StratosException(msg, (Throwable)e);
        }
    }

    public void deactivateActiveUsagePlan(String tenantDomain) throws StratosException {
        try {
            TenantManager tenantMan = CloudCommonServiceComponent.getRealmService().getTenantManager();
            int tenantId = tenantMan.getTenantId(tenantDomain);
            BillingDataAccessService dataAccessService = new BillingDataAccessService();
            Subscription subscription = dataAccessService.getActiveSubscriptionOfCustomerBySuperTenant(tenantId);
            if (subscription == null) {
                String msg = "Unable to deactivate the subscription for tenant: " + tenantId + ". An active subscription doesn't exist";
                log.info((Object)msg);
            } else {
                boolean deactivated = dataAccessService.deactivateActiveSubscriptionBySuperTenant(tenantId);
                if (deactivated) {
                    log.info((Object)("Active subscription of tenant " + tenantId + " was deactivated"));
                }
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while deactivating the active subscription of tenant: " + tenantDomain;
            log.error((Object)msg, (Throwable)e);
            throw new StratosException(msg, (Throwable)e);
        }
    }

    public void deleteBillingData(int tenantId) throws StratosException {
        try {
            BillingDataAccessService dataAccessService = new BillingDataAccessService();
            dataAccessService.deleteBillingData(tenantId);
        }
        catch (Exception e) {
            String msg = "Error deleting subscription  for tenant: " + tenantId;
            log.error((Object)msg, (Throwable)e);
            throw new StratosException(msg, (Throwable)e);
        }
    }
}

