/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.utilities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.internal.Util;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerUtils {
    private static Log log = LogFactory.getLog(CustomerUtils.class);

    public static void fillCustomerData(int customerId, Customer customer) throws BillingException {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        try {
            Tenant tenant = tenantManager.getTenant(customerId);
            customer.setId(customerId);
            customer.setName(tenant.getDomain());
            customer.setStartedDate(tenant.getCreatedDate());
            customer.setEmail(tenant.getEmail());
        }
        catch (Exception e) {
            String msg = "Failed to fill the data for customer: " + customer.getId() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
    }

    public static Customer getCustomer(int customerId) throws BillingException {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        Customer customer = null;
        try {
            Tenant tenant = tenantManager.getTenant(customerId);
            if (tenant != null) {
                customer = new Customer();
                customer.setId(customerId);
                customer.setName(tenant.getDomain());
                customer.setStartedDate(tenant.getCreatedDate());
                customer.setEmail(tenant.getEmail());
            }
        }
        catch (Exception e) {
            String msg = "Failed to get customer for customer id: " + customerId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        return customer;
    }

    public static int getCustomerId(String customerName) throws BillingException {
        int tenantId;
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        try {
            tenantId = tenantManager.getTenantId(customerName);
        }
        catch (Exception e) {
            String msg = "Failed to get tenant for domain: " + customerName + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        return tenantId;
    }

    public static List<Customer> getAllCustomers() throws BillingException {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        ArrayList<Customer> customers = new ArrayList<Customer>();
        try {
            Tenant[] tenants = tenantManager.getAllTenants();
            if (tenants != null && tenants.length > 0) {
                for (Tenant tenant : tenants) {
                    Customer customer = new Customer();
                    customer.setId(tenant.getId());
                    customer.setName(tenant.getDomain());
                    customer.setStartedDate(tenant.getCreatedDate());
                    customer.setEmail(tenant.getEmail());
                    customers.add(customer);
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to get all the customers.";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        return customers;
    }
}

