/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.scheduler.scheduleHelpers;

import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.jdbc.DataAccessObject;
import org.wso2.carbon.billing.core.scheduler.ScheduleHelper;
import org.wso2.carbon.billing.core.scheduler.SchedulerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonthlyScheduleHelper
implements ScheduleHelper {
    private static final Log log = LogFactory.getLog(MonthlyScheduleHelper.class);
    private static final String CRON_KEY = "cron";
    private static final String TIME_ZONE_KEY = "timeZone";
    private static final String DEFAULT_TIMEZONE = "GMT-8:00";
    private String cron;
    private TimeZone timeZone;

    @Override
    public void init(Map<String, String> triggerCalculatorConfig) throws BillingException {
        String timeZoneStr = triggerCalculatorConfig.get(TIME_ZONE_KEY);
        if (timeZoneStr == null) {
            timeZoneStr = DEFAULT_TIMEZONE;
        }
        this.timeZone = TimeZone.getTimeZone(timeZoneStr);
        DataAccessObject.TIMEZONE = timeZoneStr;
        this.cron = triggerCalculatorConfig.get(CRON_KEY);
        log.debug((Object)("Cron string: " + this.cron));
    }

    @Override
    public void invoke(SchedulerContext schedulerContext) throws BillingException {
        schedulerContext.setCronString(this.cron);
    }
}

