/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.scheduler;

import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskScheduler;
import org.apache.synapse.task.TaskSchedulerFactory;
import org.wso2.carbon.billing.core.BillingEngine;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.conf.BillingTaskConfiguration;
import org.wso2.carbon.billing.core.scheduler.BillingJob;
import org.wso2.carbon.billing.core.scheduler.ScheduleHelper;
import org.wso2.carbon.billing.core.scheduler.SchedulerContext;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;

public class BillingScheduler {
    private static Log log = LogFactory.getLog(BillingScheduler.class);
    private TaskScheduler taskScheduler;
    private BillingTaskConfiguration billingTaskConfig;
    private BillingEngine billingEngine;

    public BillingScheduler(BillingEngine billingEngine, BillingTaskConfiguration billingTaskConfiguration) {
        this.billingTaskConfig = billingTaskConfiguration;
        this.billingEngine = billingEngine;
        this.taskScheduler = TaskSchedulerFactory.getTaskScheduler((String)"task_scheduler");
        if (!this.taskScheduler.isInitialized()) {
            Properties properties = new Properties();
            this.taskScheduler.init(properties);
        }
    }

    public SchedulerContext createScheduleContext() throws BillingException {
        SchedulerContext schedulerContext = new SchedulerContext();
        ScheduleHelper triggerCalculator = this.billingTaskConfig.getScheduleHelper();
        if (triggerCalculator != null) {
            triggerCalculator.invoke(schedulerContext);
        }
        return schedulerContext;
    }

    public void scheduleNextCycle(SchedulerContext schedulerContext) {
        String taskName = UUIDGenerator.generateUUID();
        TaskDescription taskDescription = new TaskDescription();
        taskDescription.setName(taskName);
        taskDescription.setGroup("BillingTasks");
        taskDescription.setCron(schedulerContext.getCronString());
        HashMap<String, Object> resources = new HashMap<String, Object>();
        resources.put("taskName", taskName);
        resources.put("scheduler", this);
        resources.put("billingEngine", this.billingEngine);
        resources.put("schedulerContext", schedulerContext);
        this.taskScheduler.scheduleTask(taskDescription, resources, BillingJob.class);
    }
}

