/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.scheduler;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.wso2.carbon.billing.core.BillingEngine;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.scheduler.SchedulerContext;

public class BillingJob
implements Job {
    private static final Log log = LogFactory.getLog(BillingJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        BillingEngine billingEngine = (BillingEngine)jobExecutionContext.getMergedJobDataMap().get((Object)"billingEngine");
        SchedulerContext schedulerContext = (SchedulerContext)jobExecutionContext.getMergedJobDataMap().get((Object)"schedulerContext");
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long startTime = System.currentTimeMillis();
            log.info((Object)("Bill generation started at " + dateFormat.format(new Date(System.currentTimeMillis()))));
            billingEngine.generateBill(schedulerContext);
            log.info((Object)("Bill generation completed at " + dateFormat.format(new Date(System.currentTimeMillis()))));
            long timeTaken = System.currentTimeMillis() - startTime;
            log.info((Object)("Time taken for bill generation: " + timeTaken / 1000L + "s"));
        }
        catch (BillingException e) {
            String msg = "Error in generating the bill";
            log.error((Object)msg, (Throwable)e);
            throw new JobExecutionException(msg, (Throwable)e);
        }
    }
}

