/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.jdbc;

import java.sql.Connection;

public class Transaction {
    private static ThreadLocal<Boolean> tStarted = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Connection> tConnection = new ThreadLocal<Connection>(){

        @Override
        protected Connection initialValue() {
            return null;
        }
    };
    private static ThreadLocal<Integer> tNestedDepth = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static ThreadLocal<Boolean> tRollbacked = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static boolean isStarted() {
        if (tStarted.get() == null) {
            return false;
        }
        return tStarted.get();
    }

    public static void setStarted(boolean started) {
        tStarted.set(started);
    }

    public static Connection getConnection() {
        return tConnection.get();
    }

    public static void setConnection(Connection connection) {
        if (connection != null) {
            tStarted.set(true);
        }
        tConnection.set(connection);
    }

    public static void removeConnection() {
        tStarted.remove();
        tConnection.remove();
    }

    public static void incNestedDepth() {
        int transactionDepth = tNestedDepth.get();
        if (transactionDepth == 0) {
            tStarted.set(true);
            tRollbacked.set(false);
        }
        tNestedDepth.set(++transactionDepth);
    }

    public static void decNestedDepth() {
        int transactionDepth = tNestedDepth.get();
        tNestedDepth.set(--transactionDepth);
        if (transactionDepth == 0) {
            tStarted.set(false);
        }
    }

    public static int getNestedDepth() {
        return tNestedDepth.get();
    }

    public static boolean isRollbacked() {
        if (tRollbacked.get() == null) {
            return false;
        }
        return tRollbacked.get();
    }

    public static void setRollbacked(boolean rollbacked) {
        tRollbacked.set(rollbacked);
    }
}

