/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.jdbc;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.dataobjects.Cash;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Discount;
import org.wso2.carbon.billing.core.dataobjects.Invoice;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Payment;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.core.internal.Util;
import org.wso2.carbon.billing.core.jdbc.Transaction;
import org.wso2.carbon.billing.core.utilities.CustomerUtils;
import org.wso2.carbon.billing.core.utilities.DataSourceHolder;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAccessObject {
    public static final Log log = LogFactory.getLog(DataAccessObject.class);
    public static final int INVALID = -1;
    public static String TIMEZONE = "GMT-8:00";
    DataSource dataSource;

    public DataAccessObject(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataAccessObject() {
        this.dataSource = DataSourceHolder.getDataSource();
    }

    public void beginTransaction() throws BillingException {
        Connection conn;
        if (Transaction.getNestedDepth() != 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("The transaction was not started, because it is called within a transaction, nested depth: " + Transaction.getNestedDepth() + "."));
            }
            Transaction.incNestedDepth();
            return;
        }
        try {
            conn = this.dataSource.getConnection();
            if (conn.getTransactionIsolation() != 2) {
                conn.setTransactionIsolation(2);
            }
            conn.setAutoCommit(false);
            Transaction.incNestedDepth();
        }
        catch (SQLException e) {
            String msg = "Failed to start new billing transaction. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        Transaction.setConnection(conn);
    }

    public void rollbackTransaction() throws BillingException {
        Transaction.setRollbacked(true);
        if (Transaction.getNestedDepth() != 1) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("The transaction was not rollbacked, because it is called within a transaction, nested depth: " + Transaction.getNestedDepth() + "."));
            }
            Transaction.decNestedDepth();
            return;
        }
        Connection conn = Transaction.getConnection();
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            String msg = "Failed to rollback transaction. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        finally {
            this.endTransaction();
            Transaction.decNestedDepth();
        }
    }

    public void commitTransaction() throws BillingException {
        if (Transaction.getNestedDepth() != 1) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("The transaction was not commited, because it is called within a transaction, nested depth: " + Transaction.getNestedDepth() + "."));
            }
            Transaction.decNestedDepth();
            return;
        }
        if (Transaction.isRollbacked()) {
            String msg = "The transaction is already rollbacked, you can not commit a transaction already rollbacked, nested depth: " + Transaction.getNestedDepth() + ".";
            log.debug((Object)msg);
            Transaction.decNestedDepth();
            throw new BillingException(msg);
        }
        Connection conn = Transaction.getConnection();
        try {
            conn.commit();
        }
        catch (SQLException e) {
            String msg = "Failed to commit transaction. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        finally {
            this.endTransaction();
            Transaction.decNestedDepth();
        }
    }

    private void endTransaction() throws BillingException {
        if (Transaction.isStarted()) {
            Connection conn = Transaction.getConnection();
            try {
                conn.close();
            }
            catch (SQLException e) {
                String msg = "Failed to close transaction. " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new BillingException(msg, e);
            }
            finally {
                Transaction.setStarted(false);
                Transaction.setConnection(null);
            }
        }
    }

    public int getItemIdWithName(String itemName) throws BillingException {
        Connection conn = Transaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        int id = -1;
        try {
            String sql = "SELECT BC_ID FROM BC_ITEM WHERE BC_NAME=?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, itemName);
            result = ps.executeQuery();
            if (result.next()) {
                id = result.getInt("BC_ID");
            }
        }
        catch (SQLException e) {
            String msg = "Failed to check the existence of the items with name " + itemName + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        finally {
            String msg;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return id;
    }

    public int getItemId(String itemName, int parentId) throws BillingException {
        Connection conn = Transaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        int id = -1;
        try {
            String sql = "SELECT BC_ID FROM BC_ITEM WHERE BC_NAME=? AND BC_PARENT_ITEM_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, itemName);
            ps.setInt(2, parentId);
            result = ps.executeQuery();
            if (result.next()) {
                id = result.getInt("BC_ID");
            }
        }
        catch (SQLException e) {
            String msg = "Failed to check the existence of the items with name " + itemName + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        finally {
            String msg;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return id;
    }

    public List<Item> getItemsWithName(String itemName) throws BillingException {
        Connection conn = Transaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        ArrayList<Item> items = new ArrayList<Item>();
        try {
            String sql = "SELECT BC_ID, BC_COST, BC_DESCRIPTION, BC_PARENT_ITEM_ID  FROM BC_ITEM WHERE BC_NAME=?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, itemName);
            result = ps.executeQuery();
            while (result.next()) {
                Item item = new Item();
                item.setName(itemName);
                int id = result.getInt("BC_ID");
                item.setId(id);
                String costStr = result.getString("BC_COST");
                Cash cost = new Cash(costStr);
                item.setCost(cost);
                item.setDescription(result.getString("BC_DESCRIPTION"));
                int parentId = result.getInt("BC_PARENT_ITEM_ID");
                if (parentId > 0) {
                    Item parentItem = id == parentId ? item : this.getItem(parentId);
                    item.setParent(parentItem);
                }
                items.add(item);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get the items with name " + itemName + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        finally {
            String msg;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return items;
    }

    public int addInvoice(Invoice invoice) throws BillingException {
        Connection conn = Transaction.getConnection();
        Statement ps = null;
        ResultSet result = null;
        int invoiceId = -1;
        try {
            String sql = "INSERT INTO BC_INVOICE (BC_TENANT_ID, BC_DATE, BC_START_DATE, BC_END_DATE, BC_BOUGHT_FORWARD, BC_CARRIED_FORWARD, BC_TOTAL_PAYMENTS, BC_TOTAL_COST) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            ps = conn.prepareStatement(sql, new String[]{"BC_ID"});
            ps.setInt(1, invoice.getCustomer().getId());
            ps.setTimestamp(2, new Timestamp(invoice.getDate().getTime()));
            ps.setTimestamp(3, new Timestamp(invoice.getStartDate().getTime()));
            ps.setTimestamp(4, new Timestamp(invoice.getEndDate().getTime()));
            ps.setString(5, invoice.getBoughtForward().serializeToString());
            ps.setString(6, invoice.getCarriedForward().serializeToString());
            ps.setString(7, invoice.getTotalPayment().serializeToString());
            ps.setString(8, invoice.getTotalCost().serializeToString());
            ps.executeUpdate();
            result = ps.getGeneratedKeys();
            if (result.next()) {
                invoiceId = result.getInt(1);
                invoice.setId(invoiceId);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to insert the invoice for customer, " + invoice.getCustomer().getName() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        finally {
            String msg;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return invoiceId;
    }

    public int addItem(Item item) throws BillingException {
        Connection conn = Transaction.getConnection();
        Statement ps = null;
        ResultSet result = null;
        int itemId = -1;
        try {
            String sql = "INSERT INTO BC_ITEM (BC_NAME, BC_COST, BC_DESCRIPTION, BC_PARENT_ITEM_ID) VALUES (?, ?, ?, ?)";
            ps = conn.prepareStatement(sql, new String[]{"BC_ID"});
            ps.setString(1, item.getName());
            Cash cost = item.getCost();
            if (cost == null) {
                ps.setString(2, null);
            } else {
                ps.setString(2, cost.serializeToString());
            }
            ps.setString(3, item.getDescription());
            if (item.getParent() == null) {
                ps.setNull(4, 4);
            } else {
                ps.setInt(4, item.getParent().getId());
            }
            ps.executeUpdate();
            result = ps.getGeneratedKeys();
            if (result.next()) {
                itemId = result.getInt(1);
                item.setId(itemId);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to insert the item, " + item.getName() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        finally {
            String msg;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return itemId;
    }

    public void fillCustomerData(int customerId, Customer customer) throws BillingException {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        try {
            Tenant tenant = tenantManager.getTenant(customerId);
            customer.setId(customerId);
            customer.setName(tenant.getDomain());
            customer.setStartedDate(tenant.getCreatedDate());
            customer.setEmail(tenant.getEmail());
        }
        catch (Exception e) {
            String msg = "Failed to fill the data for customer: " + customer.getId() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
    }

    public List<Customer> getAllCustomers() throws BillingException {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        ArrayList<Customer> customers = new ArrayList<Customer>();
        try {
            Tenant[] tenants = tenantManager.getAllTenants();
            if (tenants != null && tenants.length > 0) {
                for (Tenant tenant : tenants) {
                    Customer customer = new Customer();
                    customer.setId(tenant.getId());
                    customer.setName(tenant.getDomain());
                    customer.setStartedDate(tenant.getCreatedDate());
                    customer.setEmail(tenant.getEmail());
                    customers.add(customer);
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to get all the customers.";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        return customers;
    }

    public List<Item> getAllItems() throws BillingException {
        HashMap<Integer, Item> items = new HashMap<Integer, Item>();
        HashMap<Item, Integer> itemParents = new HashMap<Item, Integer>();
        Connection conn = Transaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            String sql = "SELECT BC_ID, BC_NAME, BC_COST, BC_DESCRIPTION, BC_PARENT_ITEM_ID  FROM BC_ITEM";
            ps = conn.prepareStatement(sql);
            result = ps.executeQuery();
            while (result.next()) {
                Item item = new Item();
                int id = result.getInt("BC_ID");
                item.setId(id);
                String costStr = result.getString("BC_COST");
                Cash cost = new Cash(costStr);
                item.setCost(cost);
                item.setDescription(result.getString("BC_DESCRIPTION"));
                int parentId = result.getInt("BC_PARENT_ITEM_ID");
                if (parentId > 0) {
                    itemParents.put(item, parentId);
                }
                items.put(id, item);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get all the items.";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        finally {
            String msg;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        for (Map.Entry entry : itemParents.entrySet()) {
            Item item = (Item)entry.getKey();
            int parentId = (Integer)entry.getValue();
            Item parentItem = (Item)items.get(parentId);
            item.setParent(parentItem);
        }
        ArrayList<Item> returnVal = new ArrayList<Item>();
        returnVal.addAll(items.values());
        return returnVal;
    }

    public List<Customer> getCustomersWithName(String customerName) throws BillingException {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        ArrayList<Customer> customers = new ArrayList<Customer>();
        try {
            int tenantId = tenantManager.getTenantId(customerName);
            Tenant tenant = tenantManager.getTenant(tenantId);
            if (tenant != null) {
                Customer customer = new Customer();
                customer.setId(tenant.getId());
                customer.setName(tenant.getDomain());
                customer.setStartedDate(tenant.getCreatedDate());
                customer.setEmail(tenant.getEmail());
                customers.add(customer);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get customers for customers: " + customerName + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        return customers;
    }

    public Customer getCustomer(int customerId) throws BillingException {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        Customer customer = null;
        try {
            Tenant tenant = tenantManager.getTenant(customerId);
            if (tenant != null) {
                customer = new Customer();
                customer.setId(customerId);
                customer.setName(tenant.getDomain());
                customer.setStartedDate(tenant.getCreatedDate());
                customer.setEmail(tenant.getEmail());
            }
        }
        catch (Exception e) {
            String msg = "Failed to get customer for customer id: " + customerId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        return customer;
    }

    public Item getItem(int itemId) throws BillingException {
        Connection conn = Transaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            String sql = "SELECT BC_NAME, BC_COST, BC_DESCRIPTION, BC_PARENT_ITEM_ID  FROM BC_ITEM WHERE BC_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, itemId);
            result = ps.executeQuery();
            if (result.next()) {
                Item item = new Item();
                item.setId(itemId);
                String costStr = result.getString("BC_COST");
                Cash cost = new Cash(costStr);
                item.setCost(cost);
                item.setDescription(result.getString("BC_DESCRIPTION"));
                item.setName(result.getString("BC_NAME"));
                int parentId = result.getInt("BC_PARENT_ITEM_ID");
                if (parentId > 0) {
                    Item parentItem = itemId == parentId ? item : this.getItem(parentId);
                    item.setParent(parentItem);
                }
                Item item2 = item;
                return item2;
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get the item with item id: " + itemId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        finally {
            String msg;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return null;
    }

    public void updateSubscription(Subscription subscription) throws BillingException {
        Connection conn = Transaction.getConnection();
        PreparedStatement ps = null;
        try {
            String sql = "UPDATE BC_SUBSCRIPTION SET BC_IS_ACTIVE=?, BC_ACTIVE_SINCE=? , BC_ACTIVE_UNTIL=?, BC_ITEM_ID=?, BC_TENANT_ID=? WHERE BC_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, subscription.isActive() ? 1 : 0);
            long activeSinceTime = 0L;
            if (subscription.getActiveSince() != null) {
                activeSinceTime = subscription.getActiveSince().getTime();
            }
            ps.setTimestamp(2, new Timestamp(activeSinceTime));
            long activeUntilTime = 0L;
            if (subscription.getActiveUntil() != null) {
                activeUntilTime = subscription.getActiveUntil().getTime();
            }
            ps.setTimestamp(3, new Timestamp(activeUntilTime));
            ps.setInt(4, subscription.getItem().getId());
            ps.setInt(5, subscription.getCustomer().getId());
            ps.setInt(6, subscription.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            String msg = "Error in updating the subscription: " + subscription.getId() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addSubscription(Subscription subscription, String filter) throws BillingException {
        Connection conn = Transaction.getConnection();
        Statement ps = null;
        ResultSet result = null;
        int subscriptionId = -1;
        try {
            String sql = "INSERT INTO BC_SUBSCRIPTION (BC_FILTER, BC_IS_ACTIVE, BC_ACTIVE_SINCE, BC_ACTIVE_UNTIL, BC_ITEM_ID, BC_TENANT_ID) VALUES (?, ?, ?, ?, ?, ?)";
            ps = conn.prepareStatement(sql, new String[]{"BC_ID"});
            ps.setString(1, filter);
            ps.setInt(2, subscription.isActive() ? 1 : 0);
            long activeSinceTime = 0L;
            if (subscription.getActiveSince() != null) {
                activeSinceTime = subscription.getActiveSince().getTime();
            } else {
                activeSinceTime = System.currentTimeMillis();
                subscription.setActiveSince(new Date(activeSinceTime));
            }
            ps.setTimestamp(3, new Timestamp(activeSinceTime));
            long activeUntilTime = 0L;
            if (subscription.getActiveUntil() != null) {
                activeUntilTime = subscription.getActiveUntil().getTime();
            } else {
                Calendar activeUntilDate = Calendar.getInstance();
                activeUntilDate.setTimeInMillis(subscription.getActiveSince().getTime());
                activeUntilDate.add(1, 2);
                activeUntilTime = activeUntilDate.getTimeInMillis();
            }
            ps.setTimestamp(4, new Timestamp(activeUntilTime));
            ps.setInt(5, this.getItemIdWithName(filter));
            if (subscription.getCustomer().getId() == 0) {
                int customerId = CustomerUtils.getCustomerId(subscription.getCustomer().getName());
                if (customerId == 0) {
                    throw new BillingException("No customer found with domain: " + subscription.getCustomer().getName());
                }
                ps.setInt(6, customerId);
            } else {
                ps.setInt(6, subscription.getCustomer().getId());
            }
            ps.executeUpdate();
            result = ps.getGeneratedKeys();
            if (result.next()) {
                subscriptionId = result.getInt(1);
                subscription.setId(subscriptionId);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to insert the subscription.";
                log.error((Object)msg, (Throwable)e);
                throw new BillingException(msg, e);
            }
            catch (Throwable throwable) {
                String msg;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                try {
                    if (result == null) throw throwable;
                    result.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException ex) {
            String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
            log.error((Object)msg, (Throwable)ex);
        }
        try {
            if (result == null) return subscriptionId;
            result.close();
            return subscriptionId;
        }
        catch (SQLException ex) {
            String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
            log.error((Object)msg, (Throwable)ex);
            return subscriptionId;
        }
    }

    /*
     * Loose catch block
     */
    public void deleteBillingData(int tenantId) throws Exception {
        block19: {
            Connection conn = Transaction.getConnection();
            PreparedStatement deleteSubItemPs = null;
            Statement deleteInvoiceSubsPs = null;
            Statement deletePaymentSubsPs = null;
            Statement deletePaymentPs = null;
            Statement deleteInvoicePs = null;
            Statement deleteSubscriptionPs = null;
            conn.setAutoCommit(false);
            String deleteSubItemRecordsSql = "DELETE FROM BC_INVOICE_SUBSCRIPTION_ITEM WHERE BC_INVOICE_SUBSCRIPTION_ID IN (SELECT BC_ID FROM BC_INVOICE_SUBSCRIPTION WHERE BC_INVOICE_ID IN (SELECT BC_ID FROM BC_INVOICE WHERE BC_TENANT_ID = ?));";
            deleteSubItemPs = conn.prepareStatement(deleteSubItemRecordsSql);
            deleteSubItemPs.setInt(1, tenantId);
            deleteSubItemPs.executeUpdate();
            String deleteInvoiceSubsRecordsSql = "DELETE FROM BC_INVOICE_SUBSCRIPTION WHERE BC_INVOICE_ID IN (SELECT BC_ID FROM BC_INVOICE WHERE BC_TENANT_ID = ?) OR BC_SUBSCRIPTION_ID IN (SELECT BC_ID FROM BC_SUBSCRIPTION WHERE BC_TENANT_ID = ?)";
            deleteInvoiceSubsPs = conn.prepareStatement(deleteInvoiceSubsRecordsSql);
            deleteInvoiceSubsPs.setInt(1, tenantId);
            deleteInvoiceSubsPs.setInt(2, tenantId);
            deleteInvoiceSubsPs.executeUpdate();
            String deletePaymentSubsRecordsSql = "DELETE FROM BC_PAYMENT_SUBSCRIPTION WHERE BC_PAYMENT_ID IN (SELECT BC_ID FROM BC_PAYMENT WHERE BC_TENANT_ID = ?) OR BC_SUBSCRIPTION_ID IN (SELECT BC_ID FROM BC_SUBSCRIPTION WHERE BC_TENANT_ID = ?)";
            deletePaymentSubsPs = conn.prepareStatement(deletePaymentSubsRecordsSql);
            deletePaymentSubsPs.setInt(1, tenantId);
            deletePaymentSubsPs.setInt(2, tenantId);
            deletePaymentSubsPs.executeUpdate();
            String deletePaymentRecordsSql = "DELETE FROM BC_PAYMENT WHERE BC_INVOICE_ID IN (SELECT BC_ID FROM BC_INVOICE WHERE BC_TENANT_ID = ?)";
            deletePaymentPs = conn.prepareStatement(deletePaymentRecordsSql);
            deletePaymentPs.setInt(1, tenantId);
            deletePaymentPs.executeUpdate();
            String deleteInvoiceRecordsSql = "DELETE FROM BC_INVOICE WHERE BC_TENANT_ID = ?";
            deleteInvoicePs = conn.prepareStatement(deleteInvoiceRecordsSql);
            deleteInvoicePs.setInt(1, tenantId);
            deleteInvoicePs.executeUpdate();
            String deleteSubscriptionRecordsSql = "DELETE FROM BC_SUBSCRIPTION WHERE BC_TENANT_ID = ?";
            deleteSubscriptionPs = conn.prepareStatement(deleteSubscriptionRecordsSql);
            deleteSubscriptionPs.setInt(1, tenantId);
            deleteSubscriptionPs.executeUpdate();
            Object var16_17 = null;
            try {
                if (deleteSubItemPs != null) {
                    deleteSubItemPs.close();
                }
                if (deleteInvoiceSubsPs != null) {
                    deleteInvoiceSubsPs.close();
                }
                if (deletePaymentSubsPs != null) {
                    deletePaymentSubsPs.close();
                }
                if (deletePaymentPs != null) {
                    deletePaymentPs.close();
                }
                if (deleteInvoicePs != null) {
                    deleteInvoicePs.close();
                }
                if (deleteSubscriptionPs != null) {
                    deleteSubscriptionPs.close();
                }
                break block19;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block19;
            {
                catch (SQLException e) {
                    String msg = "Failed to delete billing information for tenant: " + tenantId;
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                try {
                    if (deleteSubItemPs != null) {
                        deleteSubItemPs.close();
                    }
                    if (deleteInvoiceSubsPs != null) {
                        deleteInvoiceSubsPs.close();
                    }
                    if (deletePaymentSubsPs != null) {
                        deletePaymentSubsPs.close();
                    }
                    if (deletePaymentPs != null) {
                        deletePaymentPs.close();
                    }
                    if (deleteInvoicePs != null) {
                        deleteInvoicePs.close();
                    }
                    if (deleteSubscriptionPs != null) {
                        deleteSubscriptionPs.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<Subscription> getFilteredActiveSubscriptions(String filter) throws BillingException {
        ArrayList<Subscription> subscriptions;
        block18: {
            String msg3;
            Connection conn = Transaction.getConnection();
            Statement ps = null;
            ResultSet result = null;
            subscriptions = new ArrayList<Subscription>();
            Date lastInvoiceDate = this.getLastInvoiceDate();
            String sql = "";
            if (lastInvoiceDate == null) {
                sql = "SELECT BC_ID, BC_IS_ACTIVE, BC_FILTER, BC_ACTIVE_SINCE, BC_ACTIVE_UNTIL, BC_ITEM_ID, BC_TENANT_ID FROM BC_SUBSCRIPTION";
                ps = conn.prepareStatement(sql);
            } else {
                sql = "SELECT BC_ID, BC_IS_ACTIVE, BC_FILTER, BC_ACTIVE_SINCE, BC_ACTIVE_UNTIL, BC_ITEM_ID, BC_TENANT_ID FROM BC_SUBSCRIPTION WHERE (BC_IS_ACTIVE=?) OR (BC_IS_ACTIVE=? AND BC_ACTIVE_UNTIL>=?)";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, 1);
                ps.setInt(2, 0);
                ps.setTimestamp(3, new Timestamp(lastInvoiceDate.getTime()));
            }
            result = ps.executeQuery();
            while (result.next()) {
                Subscription subscription = new Subscription();
                subscription.setId(result.getInt("BC_ID"));
                subscription.setActive(result.getInt("BC_IS_ACTIVE") == 1);
                subscription.setSubscriptionPlan(result.getString("BC_FILTER"));
                subscription.setActiveSince(new Date(result.getTimestamp("BC_ACTIVE_SINCE").getTime()));
                subscription.setActiveUntil(new Date(result.getTimestamp("BC_ACTIVE_UNTIL").getTime()));
                int itemId = result.getInt("BC_ITEM_ID");
                int customerId = result.getInt("BC_TENANT_ID");
                Item item = new Item();
                item.setId(itemId);
                subscription.setItem(item);
                Customer customer = new Customer();
                customer.setId(customerId);
                subscription.setCustomer(customer);
                subscriptions.add(subscription);
            }
            Object var14_15 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block18;
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            break block18;
            {
                catch (SQLException e) {
                    String msg2 = "Failed to get the active subscriptions for filter: " + filter + ".";
                    log.error((Object)msg2, (Throwable)e);
                    throw new BillingException(msg2, e);
                }
            }
            catch (Throwable throwable) {
                String msg3;
                Object var14_16 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return subscriptions;
    }

    /*
     * Loose catch block
     */
    public Invoice getLastInvoice(Customer customer) throws BillingException {
        Invoice invoice;
        block16: {
            String msg3;
            ResultSet result;
            PreparedStatement ps;
            block14: {
                Connection conn = Transaction.getConnection();
                ps = null;
                result = null;
                invoice = null;
                String sql = "SELECT BC_ID, BC_TENANT_ID, BC_DATE, BC_START_DATE, BC_END_DATE, BC_BOUGHT_FORWARD, BC_CARRIED_FORWARD, BC_TOTAL_COST, BC_TOTAL_PAYMENTS FROM BC_INVOICE WHERE BC_TENANT_ID=? AND BC_DATE=(SELECT MAX(BC_DATE) FROM BC_INVOICE WHERE BC_TENANT_ID=?) ";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, customer.getId());
                ps.setInt(2, customer.getId());
                result = ps.executeQuery();
                if (!result.next()) break block14;
                invoice = new Invoice();
                invoice.setId(result.getInt("BC_ID"));
                invoice.setCustomer(customer);
                invoice.setDate(result.getTimestamp("BC_DATE"));
                invoice.setStartDate(result.getTimestamp("BC_START_DATE"));
                invoice.setEndDate(result.getTimestamp("BC_END_DATE"));
                String boughtForwardStr = result.getString("BC_BOUGHT_FORWARD");
                invoice.setBoughtForward(new Cash(boughtForwardStr));
                String carriedForwardStr = result.getString("BC_CARRIED_FORWARD");
                invoice.setCarriedForward(new Cash(carriedForwardStr));
                String totalCostStr = result.getString("BC_TOTAL_COST");
                invoice.setTotalCost(new Cash(totalCostStr));
                String totalPaymentsStr = result.getString("BC_TOTAL_PAYMENTS");
                invoice.setTotalPayment(new Cash(totalPaymentsStr));
            }
            Object var12_13 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block16;
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            break block16;
            {
                catch (SQLException e) {
                    String msg2 = "Failed to get the invoice for customer: " + customer.getName() + ".";
                    log.error((Object)msg2, (Throwable)e);
                    throw new BillingException(msg2, e);
                }
            }
            catch (Throwable throwable) {
                String msg3;
                Object var12_14 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return invoice;
    }

    /*
     * Loose catch block
     */
    public List<Invoice> getAllInvoices(Customer customer) throws BillingException {
        ArrayList<Invoice> invoices;
        block16: {
            String msg3;
            Connection conn = Transaction.getConnection();
            invoices = new ArrayList<Invoice>();
            PreparedStatement ps = null;
            ResultSet result = null;
            String sql = "SELECT BC_ID, BC_TENANT_ID, BC_DATE, BC_START_DATE, BC_END_DATE, BC_BOUGHT_FORWARD, BC_CARRIED_FORWARD, BC_TOTAL_COST, BC_TOTAL_PAYMENTS FROM BC_INVOICE WHERE BC_TENANT_ID=? ";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, customer.getId());
            result = ps.executeQuery();
            while (result.next()) {
                Invoice invoice = new Invoice();
                invoice.setId(result.getInt("BC_ID"));
                invoice.setCustomer(customer);
                invoice.setDate(result.getTimestamp("BC_DATE"));
                invoice.setStartDate(result.getTimestamp("BC_START_DATE"));
                invoice.setEndDate(result.getTimestamp("BC_END_DATE"));
                String boughtForwardStr = result.getString("BC_BOUGHT_FORWARD");
                invoice.setBoughtForward(new Cash(boughtForwardStr));
                String carriedForwardStr = result.getString("BC_CARRIED_FORWARD");
                invoice.setCarriedForward(new Cash(carriedForwardStr));
                String totalCostStr = result.getString("BC_TOTAL_COST");
                invoice.setTotalCost(new Cash(totalCostStr));
                String totalPaymentsStr = result.getString("BC_TOTAL_PAYMENTS");
                invoice.setTotalPayment(new Cash(totalPaymentsStr));
                invoices.add(invoice);
            }
            Object var13_14 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block16;
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            break block16;
            {
                catch (SQLException e) {
                    String msg2 = "Failed to get invoices for customer: " + customer.getName() + ".";
                    log.error((Object)msg2, (Throwable)e);
                    throw new BillingException(msg2, e);
                }
            }
            catch (Throwable throwable) {
                String msg3;
                Object var13_15 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return invoices;
    }

    /*
     * Loose catch block
     */
    public void fillUnbilledPayments(Subscription subscription, Map<Integer, Payment> payments, Invoice invoice) throws BillingException {
        block19: {
            Connection conn = Transaction.getConnection();
            PreparedStatement ps = null;
            ResultSet results = null;
            Timestamp startDate = new Timestamp(invoice.getStartDate().getTime());
            Timestamp endDate = new Timestamp(invoice.getEndDate().getTime());
            String sql = "SELECT P.BC_ID, P.BC_DATE, P.BC_AMOUNT, P.BC_DESCRIPTION  FROM BC_PAYMENT P, BC_PAYMENT_SUBSCRIPTION PS WHERE PS.BC_SUBSCRIPTION_ID=? AND PS.BC_PAYMENT_ID=P.BC_ID AND P.BC_DATE>=? AND P.BC_DATE<?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, subscription.getId());
            Calendar cal = Calendar.getInstance();
            cal.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
            ps.setTimestamp(2, startDate, cal);
            ps.setTimestamp(3, endDate, cal);
            results = ps.executeQuery();
            while (results.next()) {
                Payment payment;
                int paymentId = results.getInt("BC_ID");
                if (payments.get(paymentId) != null) {
                    payment = payments.get(paymentId);
                } else {
                    payment = new Payment();
                    payment.setId(paymentId);
                    payment.setDate(results.getTimestamp("BC_DATE"));
                    payment.setDescription(results.getString("BC_DESCRIPTION"));
                    String amount = results.getString("BC_AMOUNT");
                    if (amount == null) {
                        amount = "0";
                    }
                    Cash paymentCash = new Cash(amount);
                    payment.setAmount(paymentCash);
                    payments.put(paymentId, payment);
                }
                payment.addSubscription(subscription);
            }
            Object var16_17 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (results != null) {
                    results.close();
                }
                break block19;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block19;
            {
                catch (SQLException e) {
                    String msg = "Failed to fill the payment for subscription: " + subscription.getId() + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void associatePaymentWithInvoice(Payment payment, Invoice invoice) throws BillingException {
        Connection conn = Transaction.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                String sql = "UPDATE BC_PAYMENT SET BC_INVOICE_ID=? WHERE BC_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, invoice.getId());
                ps.setInt(2, payment.getId());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "Error in associating invoice: " + invoice.getId() + " with payment: " + payment.getId() + ".";
                log.error((Object)msg, (Throwable)e);
                throw new BillingException(msg, e);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                throw throwable;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
        }
        try {}
        catch (SQLException ex) {
            String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
            log.error((Object)msg, (Throwable)ex);
            throw new BillingException(msg, ex);
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * Loose catch block
     */
    public int addInvoiceSubscription(Invoice invoice, Subscription subscription) throws BillingException {
        int invoiceSubscriptionId;
        block16: {
            String msg3;
            ResultSet result;
            Statement ps;
            block14: {
                Connection conn = Transaction.getConnection();
                ps = null;
                result = null;
                invoiceSubscriptionId = -1;
                String sql = "INSERT INTO BC_INVOICE_SUBSCRIPTION (BC_INVOICE_ID, BC_SUBSCRIPTION_ID) VALUES (?, ?)";
                ps = conn.prepareStatement(sql, new String[]{"BC_ID"});
                ps.setInt(1, invoice.getId());
                ps.setInt(2, subscription.getId());
                ps.executeUpdate();
                result = ps.getGeneratedKeys();
                if (!result.next()) break block14;
                invoiceSubscriptionId = result.getInt(1);
            }
            Object var10_9 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg3, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block16;
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            break block16;
            {
                catch (SQLException e) {
                    String msg2 = "Failed to insert the invoice subscription, invoice id: " + invoice.getId() + ", subscription id: " + subscription.getId() + ".";
                    log.error((Object)msg2, (Throwable)e);
                    throw new BillingException(msg2, e);
                }
            }
            catch (Throwable throwable) {
                String msg3;
                Object var10_10 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg3, (Throwable)ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return invoiceSubscriptionId;
    }

    /*
     * Loose catch block
     */
    public int addInvoiceSubscriptionItem(Item item, int invoiceSubscriptionId) throws BillingException {
        int invoiceSubscriptionItemId;
        block18: {
            ResultSet result;
            Statement ps;
            block16: {
                Connection conn = Transaction.getConnection();
                ps = null;
                result = null;
                invoiceSubscriptionItemId = -1;
                String sql = "INSERT INTO BC_INVOICE_SUBSCRIPTION_ITEM (BC_INVOICE_SUBSCRIPTION_ID, BC_ITEM_ID, BC_COST, BC_DESCRIPTION) VALUES (?, ?, ?, ?)";
                ps = conn.prepareStatement(sql, new String[]{"BC_ID"});
                ps.setInt(1, invoiceSubscriptionId);
                ps.setInt(2, item.getId());
                if (item.getCost() != null) {
                    ps.setString(3, item.getCost().serializeToString());
                } else {
                    ps.setString(3, new Cash("$0").serializeToString());
                }
                ps.setString(4, item.getDescription());
                ps.executeUpdate();
                result = ps.getGeneratedKeys();
                if (!result.next()) break block16;
                invoiceSubscriptionItemId = result.getInt(1);
            }
            Object var10_9 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block18;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block18;
            {
                catch (SQLException e) {
                    String msg = "Failed to insert the invoice subscription item, item id: " + item.getId() + ", invoice subscription id: " + invoiceSubscriptionId + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return invoiceSubscriptionItemId;
    }

    /*
     * Loose catch block
     */
    public int addPayment(Payment payment) throws BillingException {
        int paymentId;
        block22: {
            ResultSet result;
            Statement ps;
            block20: {
                Connection conn = Transaction.getConnection();
                ps = null;
                result = null;
                paymentId = -1;
                int invoiceId = -1;
                int customerId = -1;
                if (payment.getInvoice() != null) {
                    invoiceId = payment.getInvoice().getId();
                }
                if (invoiceId != -1) {
                    customerId = this.getCustomerIdFromInvoiceId(invoiceId);
                }
                String sql = "INSERT INTO BC_PAYMENT (BC_DATE, BC_AMOUNT, BC_DESCRIPTION, BC_INVOICE_ID, BC_TENANT_ID) VALUES (?, ?, ?, ?, ?)";
                ps = conn.prepareStatement(sql, new String[]{"BC_ID"});
                long paymentTime = System.currentTimeMillis();
                ps.setTimestamp(1, new Timestamp(paymentTime));
                ps.setString(2, payment.getAmount().serializeToString());
                ps.setString(3, payment.getDescription());
                if (invoiceId == -1) {
                    ps.setNull(4, 4);
                } else {
                    ps.setInt(4, invoiceId);
                }
                if (customerId == -1) {
                    ps.setNull(5, 4);
                } else {
                    ps.setInt(5, customerId);
                }
                ps.executeUpdate();
                result = ps.getGeneratedKeys();
                if (!result.next()) break block20;
                paymentId = result.getInt(1);
                payment.setId(paymentId);
            }
            Object var12_12 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block22;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block22;
            {
                catch (SQLException e) {
                    String msg = "Failed to insert the payment, payment id: " + paymentId + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        this.addPaymentSubscriptionsEntry(payment);
        return paymentId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addPaymentSubscriptionsEntry(Payment payment) throws BillingException {
        Connection conn = Transaction.getConnection();
        Statement ps = null;
        List<Subscription> subscriptions = payment.getSubscriptions();
        if (subscriptions == null) {
            return;
        }
        try {
            try {
                for (Subscription subscription : subscriptions) {
                    String sql = "INSERT INTO BC_PAYMENT_SUBSCRIPTION ( BC_PAYMENT_ID, BC_SUBSCRIPTION_ID) VALUES (?, ?)";
                    ps = conn.prepareStatement(sql);
                    ps.setInt(1, payment.getId());
                    ps.setInt(2, subscription.getId());
                    ps.executeUpdate();
                }
                Object var9_10 = null;
            }
            catch (SQLException e) {
                String msg = "Failed to insert the payment subscriptions, payment id: " + payment.getId() + ".";
                log.error((Object)msg, (Throwable)e);
                throw new BillingException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                throw throwable;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
        }
        try {}
        catch (SQLException ex) {
            String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
            log.error((Object)msg, (Throwable)ex);
            throw new BillingException(msg, ex);
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * Loose catch block
     */
    public List<Subscription> getFilteredActiveSubscriptionsForCustomer(String filter, Customer customer) throws BillingException {
        ArrayList<Subscription> subscriptions;
        block18: {
            String msg3;
            Connection conn = Transaction.getConnection();
            Statement ps = null;
            ResultSet result = null;
            subscriptions = new ArrayList<Subscription>();
            Date lastInvoiceDate = this.getLastInvoiceDate();
            String sql = "";
            if (lastInvoiceDate == null) {
                sql = "SELECT BC_ID, BC_IS_ACTIVE, BC_ACTIVE_SINCE, BC_ACTIVE_UNTIL, BC_ITEM_ID, BC_TENANT_ID FROM BC_SUBSCRIPTION WHERE BC_TENANT_ID=? ORDER BY BC_ACTIVE_UNTIL DESC";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, customer.getId());
            } else {
                sql = "SELECT BC_ID, BC_IS_ACTIVE, BC_ACTIVE_SINCE, BC_ACTIVE_UNTIL, BC_ITEM_ID, BC_TENANT_ID FROM BC_SUBSCRIPTION WHERE BC_TENANT_ID=? AND ((BC_IS_ACTIVE=? ) OR (BC_IS_ACTIVE=? AND BC_ACTIVE_UNTIL>=?)) ORDER BY BC_ACTIVE_UNTIL DESC";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, customer.getId());
                ps.setInt(2, 1);
                ps.setInt(3, 0);
                ps.setTimestamp(4, new Timestamp(lastInvoiceDate.getTime()));
            }
            result = ps.executeQuery();
            while (result.next()) {
                Subscription subscription = new Subscription();
                subscription.setId(result.getInt("BC_ID"));
                subscription.setActive(result.getInt("BC_IS_ACTIVE") == 1);
                subscription.setActiveSince(new Date(result.getTimestamp("BC_ACTIVE_SINCE").getTime()));
                subscription.setActiveUntil(new Date(result.getTimestamp("BC_ACTIVE_UNTIL").getTime()));
                int itemId = result.getInt("BC_ITEM_ID");
                Item item = new Item();
                item.setId(itemId);
                subscription.setItem(item);
                subscription.setCustomer(customer);
                subscriptions.add(subscription);
            }
            Object var13_14 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg3, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block18;
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            break block18;
            {
                catch (SQLException e) {
                    String msg2 = "Failed to get the active subscriptions for filter: " + filter + "," + "customer = " + customer.getName() + ".";
                    log.error((Object)msg2, (Throwable)e);
                    throw new BillingException(msg2, e);
                }
            }
            catch (Throwable throwable) {
                String msg3;
                Object var13_15 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg3, (Throwable)ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return subscriptions;
    }

    /*
     * Loose catch block
     */
    public List<Invoice> getInvoices(Customer customer) throws BillingException {
        ArrayList<Invoice> invoices;
        block20: {
            Connection conn = Transaction.getConnection();
            PreparedStatement ps = null;
            ResultSet result = null;
            invoices = new ArrayList<Invoice>();
            String sql = "SELECT BC_ID, BC_DATE, BC_START_DATE, BC_END_DATE, BC_BOUGHT_FORWARD, BC_CARRIED_FORWARD, BC_TOTAL_PAYMENTS, BC_TOTAL_COST FROM BC_INVOICE WHERE BC_TENANT_ID=? ORDER BY BC_DATE DESC";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, customer.getId());
            result = ps.executeQuery();
            while (result.next()) {
                Invoice invoice = new Invoice();
                invoice.setId(result.getInt("BC_ID"));
                invoice.setDate(new Date(result.getTimestamp("BC_DATE").getTime()));
                invoice.setStartDate(new Date(result.getTimestamp("BC_START_DATE").getTime()));
                invoice.setEndDate(new Date(result.getTimestamp("BC_END_DATE").getTime()));
                invoice.setCustomer(customer);
                String bfStr = result.getString("BC_BOUGHT_FORWARD");
                if (bfStr == null) {
                    bfStr = "$0";
                }
                invoice.setBoughtForward(new Cash(bfStr));
                String cfStr = result.getString("BC_CARRIED_FORWARD");
                if (cfStr == null) {
                    cfStr = "$0";
                }
                invoice.setCarriedForward(new Cash(cfStr));
                String totalPayStr = result.getString("BC_TOTAL_PAYMENTS");
                if (totalPayStr == null) {
                    totalPayStr = "$0";
                }
                invoice.setTotalPayment(new Cash(totalPayStr));
                String totalCostStr = result.getString("BC_TOTAL_COST");
                if (totalCostStr == null) {
                    totalCostStr = "$0";
                }
                invoice.setTotalCost(new Cash(totalCostStr));
                invoices.add(invoice);
            }
            Object var13_14 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block20;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block20;
            {
                catch (SQLException e) {
                    String msg = "Failed to get the invoice for: customer = " + customer.getName() + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return invoices;
    }

    /*
     * Loose catch block
     */
    public Invoice getInvoice(int invoiceId) throws BillingException {
        Invoice invoice;
        block20: {
            ResultSet result;
            PreparedStatement ps;
            block18: {
                Connection conn = Transaction.getConnection();
                ps = null;
                result = null;
                invoice = null;
                String sql = "SELECT BC_TENANT_ID, BC_DATE, BC_START_DATE, BC_END_DATE, BC_BOUGHT_FORWARD, BC_CARRIED_FORWARD, BC_TOTAL_PAYMENTS, BC_TOTAL_COST FROM BC_INVOICE WHERE BC_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, invoiceId);
                result = ps.executeQuery();
                if (!result.next()) break block18;
                invoice = new Invoice();
                invoice.setEndDate(new Date(result.getTimestamp("BC_END_DATE").getTime()));
                invoice.setId(invoiceId);
                invoice.setStartDate(new Date(result.getTimestamp("BC_START_DATE").getTime()));
                invoice.setDate(new Date(result.getTimestamp("BC_DATE").getTime()));
                String bfStr = result.getString("BC_BOUGHT_FORWARD");
                if (bfStr == null) {
                    bfStr = "$0";
                }
                invoice.setBoughtForward(new Cash(bfStr));
                String cfStr = result.getString("BC_CARRIED_FORWARD");
                if (cfStr == null) {
                    cfStr = "$0";
                }
                invoice.setCarriedForward(new Cash(cfStr));
                String totalPayStr = result.getString("BC_TOTAL_PAYMENTS");
                if (totalPayStr == null) {
                    totalPayStr = "$0";
                }
                invoice.setTotalPayment(new Cash(totalPayStr));
                String totalCostStr = result.getString("BC_TOTAL_COST");
                if (totalCostStr == null) {
                    totalCostStr = "$0";
                }
                invoice.setTotalCost(new Cash(totalCostStr));
                int customerId = result.getInt("BC_TENANT_ID");
                Customer customer = CustomerUtils.getCustomer(customerId);
                invoice.setCustomer(customer);
                this.fillInvoiceSubscriptions(invoice);
                this.fillInvoicePayments(invoice);
            }
            Object var14_15 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block20;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block20;
            {
                catch (SQLException e) {
                    String msg = "Failed to get the invoice for: invoice id = " + invoiceId + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return invoice;
    }

    /*
     * Loose catch block
     */
    private void fillInvoicePayments(Invoice invoice) throws BillingException {
        ArrayList<Payment> payments;
        block17: {
            Connection conn = Transaction.getConnection();
            PreparedStatement ps = null;
            ResultSet result = null;
            int customerId = -1;
            if (invoice.getCustomer() == null) {
                return;
            }
            customerId = invoice.getCustomer().getId();
            Timestamp startDate = new Timestamp(invoice.getStartDate().getTime());
            Timestamp endDate = new Timestamp(invoice.getEndDate().getTime());
            payments = new ArrayList<Payment>();
            String sql = "SELECT BC_ID, BC_DATE, BC_AMOUNT, BC_DESCRIPTION FROM BC_PAYMENT WHERE BC_TENANT_ID=? AND BC_DATE>=? AND BC_DATE<?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, customerId);
            Calendar cal = Calendar.getInstance();
            cal.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
            ps.setTimestamp(2, startDate, cal);
            ps.setTimestamp(3, endDate, cal);
            result = ps.executeQuery();
            while (result.next()) {
                Payment payment = new Payment();
                payment.setId(result.getInt("BC_ID"));
                String cashPayment = result.getString("BC_AMOUNT");
                payment.setAmount(new Cash(cashPayment));
                payment.setDate(result.getTimestamp("BC_DATE"));
                payment.setDescription(result.getString("BC_DESCRIPTION"));
                payments.add(payment);
            }
            Object var14_15 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block17;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block17;
            {
                catch (SQLException e) {
                    String msg = "Failed to get the invoice payments for: invoice id = " + invoice.getId() + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        invoice.setPayments(payments);
    }

    /*
     * Loose catch block
     */
    private void fillInvoiceSubscriptions(Invoice invoice) throws BillingException {
        ArrayList<Subscription> subscriptions;
        block16: {
            Connection conn = Transaction.getConnection();
            PreparedStatement ps = null;
            ResultSet result = null;
            int invoiceId = invoice.getId();
            subscriptions = new ArrayList<Subscription>();
            String sql = "SELECT BC_ID, BC_SUBSCRIPTION_ID FROM BC_INVOICE_SUBSCRIPTION WHERE BC_INVOICE_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, invoiceId);
            result = ps.executeQuery();
            while (result.next()) {
                int invoiceSubscriptionId = result.getInt("BC_ID");
                int subscriptionId = result.getInt("BC_SUBSCRIPTION_ID");
                Subscription subscription = this.getSubscription(subscriptionId);
                subscription.setInvoiceSubscriptionId(invoiceSubscriptionId);
                subscriptions.add(subscription);
            }
            Object var12_13 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block16;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block16;
            {
                catch (SQLException e) {
                    String msg = "Failed to get the invoice subscriptions for: invoice id = " + invoiceId + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        invoice.setSubscriptions(subscriptions);
    }

    /*
     * Loose catch block
     */
    public Subscription getSubscription(int subscriptionId) throws BillingException {
        Subscription subscription;
        block16: {
            ResultSet result;
            PreparedStatement ps;
            block14: {
                Connection conn = Transaction.getConnection();
                ps = null;
                result = null;
                subscription = null;
                String sql = "SELECT BC_ID, BC_ACTIVE_SINCE, BC_ACTIVE_UNTIL, BC_ITEM_ID, BC_TENANT_ID, BC_IS_ACTIVE, BC_FILTER FROM BC_SUBSCRIPTION WHERE BC_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, subscriptionId);
                result = ps.executeQuery();
                if (!result.next()) break block14;
                subscription = new Subscription();
                subscription.setId(subscriptionId);
                subscription.setActiveSince(new Date(result.getTimestamp("BC_ACTIVE_SINCE").getTime()));
                subscription.setActiveUntil(new Date(result.getTimestamp("BC_ACTIVE_UNTIL").getTime()));
                int itemId = result.getInt("BC_ITEM_ID");
                int customerId = result.getInt("BC_TENANT_ID");
                Item item = this.getItem(itemId);
                subscription.setItem(item);
                Customer customer = CustomerUtils.getCustomer(customerId);
                subscription.setCustomer(customer);
                int isActive = result.getInt("BC_IS_ACTIVE");
                subscription.setActive(isActive == 1);
                subscription.setSubscriptionPlan(result.getString("BC_FILTER"));
            }
            Object var13_14 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block16;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block16;
            {
                catch (SQLException e) {
                    String msg = "Failed to get the active subscription for id: " + subscriptionId + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return subscription;
    }

    /*
     * Loose catch block
     */
    public Subscription getActiveSubscriptionOfCustomer(int customerId) throws BillingException {
        Subscription subscription;
        block16: {
            ResultSet result;
            PreparedStatement ps;
            block14: {
                Connection conn = Transaction.getConnection();
                ps = null;
                result = null;
                subscription = null;
                String sql = "SELECT BC_ID, BC_ACTIVE_SINCE, BC_ACTIVE_UNTIL, BC_ITEM_ID, BC_TENANT_ID, BC_IS_ACTIVE, BC_FILTER FROM BC_SUBSCRIPTION WHERE BC_TENANT_ID=? AND BC_IS_ACTIVE=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, customerId);
                ps.setInt(2, 1);
                result = ps.executeQuery();
                if (!result.next()) break block14;
                subscription = new Subscription();
                subscription.setId(result.getInt("BC_ID"));
                subscription.setActiveSince(new Date(result.getTimestamp("BC_ACTIVE_SINCE").getTime()));
                subscription.setActiveUntil(new Date(result.getTimestamp("BC_ACTIVE_UNTIL").getTime()));
                int itemId = result.getInt("BC_ITEM_ID");
                Item item = this.getItem(itemId);
                subscription.setItem(item);
                Customer customer = CustomerUtils.getCustomer(customerId);
                subscription.setCustomer(customer);
                int isActive = result.getInt("BC_IS_ACTIVE");
                subscription.setActive(isActive == 1);
                subscription.setSubscriptionPlan(result.getString("BC_FILTER"));
            }
            Object var12_13 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block16;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block16;
            {
                catch (SQLException e) {
                    String msg = "Failed to get the active subscription for customer id: " + customerId + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return subscription;
    }

    /*
     * Loose catch block
     */
    public List<Item> getBilledItems(Subscription subscription) throws BillingException {
        ArrayList<Item> items;
        block19: {
            Connection conn = Transaction.getConnection();
            PreparedStatement ps = null;
            ResultSet result = null;
            int invoiceSubscriptionId = subscription.getInvoiceSubscriptionId();
            if (invoiceSubscriptionId == -1) {
                String msg = "Not a invoiced subscription, subscription id: " + subscription.getId() + ".";
                log.error((Object)msg);
                throw new BillingException(msg);
            }
            items = new ArrayList<Item>();
            String sql = "SELECT BC_ITEM_ID, BC_COST, BC_DESCRIPTION FROM BC_INVOICE_SUBSCRIPTION_ITEM WHERE BC_INVOICE_SUBSCRIPTION_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, invoiceSubscriptionId);
            result = ps.executeQuery();
            while (result.next()) {
                Item item = this.getItem(result.getInt("BC_ITEM_ID"));
                String cost = result.getString("BC_COST");
                String description = result.getString("BC_DESCRIPTION");
                if (cost != null) {
                    item.setCost(new Cash(cost));
                }
                if (description != null && !"".equals(description)) {
                    item.setDescription(description);
                }
                items.add(item);
            }
            Object var12_14 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block19;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block19;
            {
                catch (SQLException e) {
                    String msg = "Failed to get the invoiced subscription items for invoice subscription id: " + invoiceSubscriptionId + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return items;
    }

    /*
     * Loose catch block
     */
    public List<Subscription> getInvoiceSubscriptions(int invoiceId) throws BillingException {
        ArrayList<Subscription> subscriptions;
        block16: {
            String msg3;
            Connection conn = Transaction.getConnection();
            PreparedStatement ps = null;
            ResultSet result = null;
            subscriptions = new ArrayList<Subscription>();
            String sql = "SELECT S.BC_ID, S.BC_FILTER, S.BC_IS_ACTIVE, S.BC_ACTIVE_SINCE, S.BC_ACTIVE_UNTIL, S.BC_ITEM_ID, S.BC_TENANT_ID FROM BC_SUBSCRIPTION S, BC_INVOICE_SUBSCRIPTION BIS WHERE S.BC_ID=BIS.BC_SUBSCRIPTION_ID AND BIS.BC_INVOICE_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, invoiceId);
            result = ps.executeQuery();
            while (result.next()) {
                Subscription subscription = new Subscription();
                subscription.setId(result.getInt("BC_ID"));
                subscription.setSubscriptionPlan(result.getString("BC_FILTER"));
                subscription.setActiveSince(new Date(result.getTimestamp("BC_ACTIVE_SINCE").getTime()));
                subscription.setActiveUntil(new Date(result.getTimestamp("BC_ACTIVE_UNTIL").getTime()));
                int itemId = result.getInt("BC_ITEM_ID");
                int customerId = result.getInt("BC_TENANT_ID");
                boolean isActive = result.getBoolean("BC_IS_ACTIVE");
                Item item = new Item();
                item.setId(itemId);
                subscription.setItem(item);
                Customer customer = new Customer();
                customer.setId(customerId);
                subscription.setCustomer(customer);
                subscription.setActive(isActive);
                subscriptions.add(subscription);
            }
            Object var14_15 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block16;
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            break block16;
            {
                catch (SQLException e) {
                    String msg2 = "Failed to get the invoice subscriptions for invoice: " + invoiceId + ".";
                    log.error((Object)msg2, (Throwable)e);
                    throw new BillingException(msg2, e);
                }
            }
            catch (Throwable throwable) {
                String msg3;
                Object var14_16 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return subscriptions;
    }

    /*
     * Loose catch block
     */
    private int getCustomerIdFromInvoiceId(int invoiceId) throws BillingException {
        int customerId;
        block16: {
            String msg3;
            Connection conn = Transaction.getConnection();
            PreparedStatement ps = null;
            ResultSet result = null;
            customerId = -1;
            String sql = "SELECT BC_TENANT_ID FROM BC_INVOICE WHERE BC_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, invoiceId);
            result = ps.executeQuery();
            while (result.next()) {
                customerId = result.getInt("BC_TENANT_ID");
            }
            Object var9_8 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block16;
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            break block16;
            {
                catch (SQLException e) {
                    String msg2 = "Failed to get the customer Id for invoice: " + invoiceId + ".";
                    log.error((Object)msg2, (Throwable)e);
                    throw new BillingException(msg2, e);
                }
            }
            catch (Throwable throwable) {
                String msg3;
                Object var9_9 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return customerId;
    }

    /*
     * Loose catch block
     */
    public Payment getLastPayment(Customer customer) throws BillingException {
        Payment payment;
        block16: {
            String msg3;
            ResultSet result;
            PreparedStatement ps;
            block14: {
                Connection conn = Transaction.getConnection();
                ps = null;
                result = null;
                payment = null;
                String sql = "SELECT BC_ID, BC_DATE, BC_AMOUNT, BC_DESCRIPTION FROM BC_PAYMENT WHERE BC_TENANT_ID=? AND BC_DATE=(SELECT MAX(BC_DATE) FROM BC_PAYMENT WHERE BC_TENANT_ID=?) ";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, customer.getId());
                ps.setInt(2, customer.getId());
                result = ps.executeQuery();
                if (!result.next()) break block14;
                payment = new Payment();
                payment.setAmount(new Cash(result.getString("BC_AMOUNT")));
                payment.setDate(new Date(result.getTimestamp("BC_DATE").getTime()));
                payment.setDescription(result.getString("BC_DESCRIPTION"));
            }
            Object var9_8 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block16;
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            break block16;
            {
                catch (SQLException e) {
                    String msg2 = "Failed to get the last payment for customer: " + customer.getName() + ".";
                    log.error((Object)msg2, (Throwable)e);
                    throw new BillingException(msg2, e);
                }
            }
            catch (Throwable throwable) {
                String msg3;
                Object var9_9 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return payment;
    }

    /*
     * Loose catch block
     */
    public Date getLastInvoiceDate() throws BillingException {
        Date maxDate;
        block16: {
            String msg3;
            ResultSet result;
            PreparedStatement ps;
            block14: {
                Timestamp lastInvoiceTimestamp;
                Connection conn = Transaction.getConnection();
                ps = null;
                result = null;
                maxDate = null;
                String sql = "SELECT MAX(BC_DATE) FROM BC_INVOICE";
                ps = conn.prepareStatement(sql);
                result = ps.executeQuery();
                if (!result.next() || (lastInvoiceTimestamp = result.getTimestamp("MAX(BC_DATE)")) == null) break block14;
                maxDate = new Date(lastInvoiceTimestamp.getTime());
            }
            Object var8_9 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block16;
            }
            catch (SQLException ex) {
                msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg3, (Throwable)ex);
            }
            break block16;
            {
                catch (SQLException e) {
                    String msg2 = "Failed to get the last invoice date";
                    log.error((Object)msg2, (Throwable)e);
                    throw new BillingException(msg2, e);
                }
            }
            catch (Throwable throwable) {
                String msg3;
                Object var8_10 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    msg3 = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg3, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return maxDate;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deactivateCurrentSubscriptoin(int customerID) throws BillingException {
        block12: {
            block11: {
                conn = Transaction.getConnection();
                ps = null;
                try {
                    try {
                        sql = "UPDATE BC_SUBSCRIPTION SET BC_IS_ACTIVE=? ,BC_ACTIVE_UNTIL=?, BC_ACTIVE_SINCE=? WHERE BC_TENANT_ID=? AND BC_IS_ACTIVE=? ";
                        ps = conn.prepareStatement(sql);
                        subscription = this.getActiveSubscriptionOfCustomer(customerID);
                        ps.setInt(1, 0);
                        now = System.currentTimeMillis();
                        ps.setTimestamp(2, new Timestamp(now));
                        ps.setTimestamp(3, new Timestamp(subscription.getActiveSince().getTime()));
                        ps.setInt(4, customerID);
                        ps.setInt(5, subscription.isActive() != false ? 1 : 0);
                        updated = ps.executeUpdate();
                        if (updated > 0) {
                            var9_12 = true;
                            var11_14 = null;
                            break block11;
                        }
                        var9_13 = false;
                        break block12;
                    }
                    catch (SQLException e) {
                        msg = "Error in deactivating the subscription for tenant : " + customerID + ".";
                        DataAccessObject.log.error((Object)msg, (Throwable)e);
                        throw new BillingException(msg, e);
                    }
                    catch (Exception e) {
                        msg = "Error in deactivating the subscription for tenant : " + customerID + ".";
                        DataAccessObject.log.error((Object)msg, (Throwable)e);
                        throw new BillingException(msg, e);
                    }
                }
                catch (Throwable var10_23) {
                    var11_16 = null;
                    try {
                        if (ps == null) throw var10_23;
                        ps.close();
                        throw var10_23;
                    }
                    catch (SQLException ex) {
                        msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                        DataAccessObject.log.error((Object)msg, (Throwable)ex);
                        throw var10_23;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [7 : 253->266)] { 
lbl44:
            // 1 sources

            if (ps == null) return var9_12;
            ps.close();
            return var9_12;
lbl47:
            // 1 sources

            catch (SQLException ex) {
                msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                DataAccessObject.log.error((Object)msg, (Throwable)ex);
            }
            return var9_12;
        }
        var11_15 = null;
        try {}
        catch (SQLException ex) {
            msg = "A SQLException error has occurred when trying to close result set or prepared statement";
            DataAccessObject.log.error((Object)msg, (Throwable)ex);
            return var9_13;
        }
        if (ps == null) return var9_13;
        ps.close();
        return var9_13;
    }

    public boolean changeSubscription(int customerID, String newPlanName) throws BillingException {
        boolean isChanged = false;
        try {
            Subscription subscription = this.getActiveSubscriptionOfCustomer(customerID);
            if (subscription != null) {
                int newSubscriptionId;
                Item item = this.getItemsWithName(newPlanName).get(0);
                subscription.setItem(item);
                Calendar activeSinceDate = Calendar.getInstance();
                subscription.setActiveSince(activeSinceDate.getTime());
                subscription.setActiveUntil(null);
                subscription.setActive(true);
                boolean deactivatedCurrent = this.deactivateCurrentSubscriptoin(customerID);
                if (deactivatedCurrent && (newSubscriptionId = this.addSubscription(subscription, newPlanName)) > 0) {
                    isChanged = true;
                }
            } else {
                Customer currentCustomer = new Customer();
                currentCustomer.setId(customerID);
                Subscription currentSubscription = new Subscription();
                currentSubscription.setCustomer(currentCustomer);
                currentSubscription.setActive(true);
                long now = System.currentTimeMillis();
                currentSubscription.setActiveSince(new Date(now));
                this.addSubscription(currentSubscription, newPlanName);
                isChanged = true;
            }
        }
        catch (Exception e) {
            String msg = "Error in updating the subscription for tenant : " + customerID + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        return isChanged;
    }

    /*
     * Loose catch block
     */
    public List<Subscription> getInactiveSubscriptionsOfCustomer(int customerID) throws BillingException {
        ArrayList<Subscription> subscriptions;
        block16: {
            Connection conn = Transaction.getConnection();
            PreparedStatement ps = null;
            ResultSet result = null;
            subscriptions = new ArrayList<Subscription>();
            String sql = "SELECT BC_ACTIVE_SINCE, BC_ACTIVE_UNTIL, BC_ITEM_ID, BC_ID, BC_IS_ACTIVE, BC_FILTER FROM BC_SUBSCRIPTION WHERE BC_TENANT_ID=? AND BC_IS_ACTIVE=? ORDER BY BC_ACTIVE_SINCE DESC";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, customerID);
            ps.setInt(2, 0);
            result = ps.executeQuery();
            while (result.next()) {
                Subscription subscription = new Subscription();
                subscription.setActiveSince(new Date(result.getTimestamp("BC_ACTIVE_SINCE").getTime()));
                subscription.setActiveUntil(new Date(result.getTimestamp("BC_ACTIVE_UNTIL").getTime()));
                int itemId = result.getInt("BC_ITEM_ID");
                int bcID = result.getInt("BC_ID");
                subscription.setId(bcID);
                Item item = this.getItem(itemId);
                subscription.setItem(item);
                Customer customer = CustomerUtils.getCustomer(customerID);
                subscription.setCustomer(customer);
                int isActive = result.getInt("BC_IS_ACTIVE");
                subscription.setActive(isActive == 1);
                subscription.setSubscriptionPlan(result.getString("BC_FILTER"));
                subscriptions.add(subscription);
            }
            Object var14_15 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block16;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block16;
            {
                catch (SQLException e) {
                    String msg = "Failed to get the inactive subscriptions for customer id: " + customerID + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return subscriptions;
    }

    /*
     * Loose catch block
     */
    public boolean activateSubscription(int subscriptionId) throws BillingException {
        int updated;
        block9: {
            Connection conn = Transaction.getConnection();
            PreparedStatement ps = null;
            updated = 0;
            String sql = "UPDATE BC_SUBSCRIPTION SET BC_IS_ACTIVE=? ,BC_ACTIVE_UNTIL=?, BC_ACTIVE_SINCE=? WHERE BC_ID=?";
            ps = conn.prepareStatement(sql);
            Subscription subscription = this.getSubscription(subscriptionId);
            ps.setInt(1, 1);
            ps.setTimestamp(2, new Timestamp(subscription.getActiveUntil().getTime()));
            ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            ps.setInt(4, subscription.getId());
            updated = ps.executeUpdate();
            Object var8_9 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
                break block9;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block9;
            {
                catch (SQLException e) {
                    String msg = "Error in activating the subscription id : " + subscriptionId + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return updated > 0;
    }

    /*
     * Loose catch block
     */
    public boolean addDiscount(Discount discount) throws BillingException {
        int added;
        block13: {
            Connection conn = Transaction.getConnection();
            PreparedStatement ps = null;
            added = 0;
            String sql = "INSERT INTO BC_DISCOUNT (BC_TENANT_ID, BC_PERCENTAGE, BC_AMOUNT, BC_START_DATE, BC_END_DATE, BC_PERCENTAGE_TYPE) VALUES (?, ?, ?, ?, ?, ?)";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, discount.getTenantId());
            if (discount.isPercentageType()) {
                ps.setInt(6, 1);
                ps.setFloat(2, discount.getPercentage());
                ps.setNull(3, 6);
            } else {
                ps.setInt(6, 0);
                ps.setNull(2, 6);
                ps.setFloat(3, discount.getAmount());
            }
            ps.setTimestamp(4, new Timestamp(discount.getStartDate().getTime()));
            if (discount.getEndDate() != null) {
                ps.setTimestamp(5, new Timestamp(discount.getEndDate().getTime()));
            } else {
                ps.setNull(5, 93);
            }
            added = ps.executeUpdate();
            Object var8_7 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
                break block13;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block13;
            {
                catch (SQLException e) {
                    String msg = "Error in adding the discount for tenant: ";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return added > 0;
    }

    /*
     * Loose catch block
     */
    public List<Discount> getAllActiveDiscounts() throws BillingException {
        ArrayList<Discount> discounts;
        block19: {
            Connection conn = Transaction.getConnection();
            PreparedStatement ps = null;
            ResultSet result = null;
            discounts = new ArrayList<Discount>();
            String sql = "SELECT BC_ID, BC_TENANT_ID, BC_PERCENTAGE, BC_AMOUNT, BC_START_DATE, BC_END_DATE, BC_PERCENTAGE_TYPE FROM BC_DISCOUNT";
            ps = conn.prepareStatement(sql);
            result = ps.executeQuery();
            while (result.next()) {
                Discount discount = new Discount();
                discount.setId(result.getInt("BC_ID"));
                discount.setTenantId(result.getInt("BC_TENANT_ID"));
                int isPercentageType = result.getInt("BC_PERCENTAGE_TYPE");
                if (isPercentageType == 1) {
                    discount.setPercentageType(true);
                    discount.setPercentage(result.getFloat("BC_PERCENTAGE"));
                } else {
                    discount.setPercentageType(false);
                    discount.setAmount(result.getFloat("BC_AMOUNT"));
                }
                discount.setStartDate(new java.util.Date(result.getTimestamp("BC_START_DATE").getTime()));
                if (result.getTimestamp("BC_END_DATE") != null) {
                    discount.setEndDate(new java.util.Date(result.getTimestamp("BC_END_DATE").getTime()));
                }
                if (discount.getEndDate() != null && !discount.getEndDate().after(new java.util.Date())) continue;
                discounts.add(discount);
            }
            Object var9_10 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                log.error((Object)msg, (Throwable)ex);
                throw new BillingException(msg, ex);
            }
            try {
                if (result != null) {
                    result.close();
                }
                break block19;
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
            break block19;
            {
                catch (SQLException e) {
                    String msg = "Failed to get the list of discounts.";
                    log.error((Object)msg, (Throwable)e);
                    throw new BillingException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement" + ex.getMessage();
                    log.error((Object)msg, (Throwable)ex);
                    throw new BillingException(msg, ex);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
                throw throwable;
            }
        }
        return discounts;
    }
}

