/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingManager;
import org.wso2.carbon.billing.core.DataAccessManager;
import org.wso2.carbon.billing.core.conf.BillingConfiguration;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.rule.kernel.config.RuleEngineConfigService;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;

public class Util {
    private static RegistryService registryService;
    private static RealmService realmService;
    private static RuleEngineConfigService ruleEngineConfigService;
    private static List<TenantMgtListener> tenantMgtListeners;
    private static DataAccessManager dataAccessManager;
    private static DataSourceService dataSourceService;

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null) {
            registryService = service;
        }
    }

    public static synchronized void setRealmService(RealmService service) {
        if (realmService == null) {
            realmService = service;
        }
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static void setRuleEngineConfigService(RuleEngineConfigService ruleServerManagerService) {
        ruleEngineConfigService = ruleServerManagerService;
    }

    public static RuleEngineConfigService getRuleEngineConfigService() {
        return ruleEngineConfigService;
    }

    public static void initBillingManager(BundleContext bundleContext) throws BillingException {
        String configFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "billing-config.xml";
        BillingConfiguration billingConfiguration = new BillingConfiguration(configFile);
        BillingManager billingManager = new BillingManager(billingConfiguration);
        bundleContext.registerService(BillingManager.class.getName(), (Object)billingManager, null);
    }

    public static void initDataAccessManager() throws BillingException {
        dataAccessManager = new DataAccessManager(BillingManager.getInstance().getDataAccessObject());
    }

    public static DataAccessManager getDataAccessManager() {
        return dataAccessManager;
    }

    public static void cleanBillingManager() {
        BillingManager.destroyInstance();
    }

    public static void addTenantMgtListenerService(TenantMgtListener tenantMgtListener) {
        tenantMgtListeners.add(tenantMgtListener);
        Util.sortTenantMgtListeners();
    }

    public static void removeTenantMgtListenerService(TenantMgtListener tenantMgtListener) {
        tenantMgtListeners.remove(tenantMgtListener);
        Util.sortTenantMgtListeners();
    }

    public static void setDataSourceService(DataSourceService service) {
        if (dataSourceService == null) {
            dataSourceService = service;
        }
    }

    public static DataSourceService getDataSourceService() {
        return dataSourceService;
    }

    private static void sortTenantMgtListeners() {
        Collections.sort(tenantMgtListeners, new Comparator<TenantMgtListener>(){

            @Override
            public int compare(TenantMgtListener o1, TenantMgtListener o2) {
                return o1.getListenerOrder() - o2.getListenerOrder();
            }
        });
    }

    public static void alertTenantSubscriptionPlanChange(int tenantId, String oldSubscriptionPlan, String newSubscriptionPlan) throws StratosException {
        for (TenantMgtListener tenantMgtLister : tenantMgtListeners) {
            tenantMgtLister.onSubscriptionPlanChange(tenantId, oldSubscriptionPlan, newSubscriptionPlan);
        }
    }

    static {
        tenantMgtListeners = new ArrayList<TenantMgtListener>();
    }
}

