/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.billing.core.BillingHandler;
import org.wso2.carbon.billing.core.BillingTenantMgtListenerImpl;
import org.wso2.carbon.billing.core.conf.BillingTaskConfiguration;
import org.wso2.carbon.billing.core.internal.Util;
import org.wso2.carbon.billing.core.scheduler.ScheduleHelper;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.rule.kernel.config.RuleEngineConfigService;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.stratos.common.util.StratosConfiguration;
import org.wso2.carbon.user.core.service.RealmService;

public class BillingServiceComponent {
    private static Log log = LogFactory.getLog(BillingServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            if (CommonUtil.getStratosConfig() == null) {
                StratosConfiguration stratosConfig = CommonUtil.loadStratosConfiguration();
                CommonUtil.setStratosConfig((StratosConfiguration)stratosConfig);
            }
            Util.initBillingManager(context.getBundleContext());
            Util.initDataAccessManager();
            BillingTenantMgtListenerImpl billingTenantMgtListener = new BillingTenantMgtListenerImpl();
            context.getBundleContext().registerService(TenantMgtListener.class.getName(), (Object)billingTenantMgtListener, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"******* Billing bundle is activated ******* ");
            }
        }
        catch (Throwable e) {
            log.error((Object)"******* Billing bundle failed activating ****", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        Util.cleanBillingManager();
        log.debug((Object)"******* Billing is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        Util.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Util.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        Util.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        Util.setRealmService(null);
    }

    protected void setBillingHandlerService(BillingHandler billingHandler) {
        BillingTaskConfiguration.addBillingHandler(billingHandler);
    }

    protected void unsetBillingHandlerService(BillingHandler billingHandler) {
    }

    protected void setScheduleHelperService(ScheduleHelper scheduleHelper) {
        BillingTaskConfiguration.addScheduleHelper(scheduleHelper);
    }

    protected void unsetScheduleHelperService(ScheduleHelper scheduleHelper) {
    }

    protected void setRuleEngineConfigService(RuleEngineConfigService ruleEngineConfigService) {
        Util.setRuleEngineConfigService(ruleEngineConfigService);
    }

    protected void unsetRuleEngineConfigService(RuleEngineConfigService ruleEngineConfigService) {
        Util.setRuleEngineConfigService(null);
    }

    protected void setTenantMgtListenerService(TenantMgtListener tenantMgtListener) {
        Util.addTenantMgtListenerService(tenantMgtListener);
    }

    protected void unsetTenantMgtListenerService(TenantMgtListener tenantMgtListener) {
        Util.removeTenantMgtListenerService(tenantMgtListener);
    }

    protected void setDataSourceService(DataSourceService dataSourceService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Data Sources Service");
        }
        Util.setDataSourceService(dataSourceService);
    }

    protected void unsetDataSourceService(DataSourceService dataSourceService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Data Sources Service");
        }
        Util.setDataSourceService(null);
    }
}

