/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingEngineContext;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingHandler;
import org.wso2.carbon.billing.core.BillingManager;
import org.wso2.carbon.billing.core.dataobjects.Cash;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Invoice;
import org.wso2.carbon.billing.core.dataobjects.Payment;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.core.jdbc.DataAccessObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionTreeBuildingHandler
implements BillingHandler {
    private static Log log = LogFactory.getLog(SubscriptionTreeBuildingHandler.class);

    @Override
    public void init(Map<String, String> handlerConfig) throws BillingException {
    }

    @Override
    public void execute(BillingEngineContext handlerContext) throws BillingException {
        this.buildSubscriptionTree(handlerContext);
    }

    private void buildSubscriptionTree(BillingEngineContext handlerContext) throws BillingException {
        List<Subscription> customerSubscriptions;
        Customer customer;
        DataAccessObject dataAccessObject = BillingManager.getInstance().getDataAccessObject();
        List<Subscription> subscriptions = handlerContext.getSubscriptions();
        HashMap<Customer, List<Subscription>> customersSubscriptions = new HashMap<Customer, List<Subscription>>();
        for (Subscription subscription : subscriptions) {
            customer = subscription.getCustomer();
            customerSubscriptions = (ArrayList<Subscription>)customersSubscriptions.get(customer);
            if (customerSubscriptions == null) {
                customerSubscriptions = new ArrayList<Subscription>();
            }
            customerSubscriptions.add(subscription);
            customersSubscriptions.put(customer, customerSubscriptions);
        }
        for (Map.Entry entry : customersSubscriptions.entrySet()) {
            customer = (Customer)entry.getKey();
            customerSubscriptions = (List)entry.getValue();
            Invoice invoice = new Invoice();
            Invoice lastInvoice = dataAccessObject.getLastInvoice(customer);
            if (lastInvoice != null) {
                invoice.setBoughtForward(lastInvoice.getCarriedForward());
                long lastInvoiceEnd = lastInvoice.getEndDate().getTime();
                long currentInvoiceStart = lastInvoiceEnd + 1000L;
                invoice.setStartDate(new Date(currentInvoiceStart));
            } else {
                invoice.setBoughtForward(new Cash("$0"));
                long earliestSubscriptionStart = -1L;
                for (Subscription subscription : customerSubscriptions) {
                    long subscriptionStartDate = subscription.getActiveSince().getTime();
                    if (earliestSubscriptionStart != -1L && subscriptionStartDate >= earliestSubscriptionStart) continue;
                    earliestSubscriptionStart = subscriptionStartDate;
                }
                invoice.setStartDate(new Date(earliestSubscriptionStart));
            }
            Date currentDate = new Date();
            invoice.setEndDate(currentDate);
            invoice.setDate(currentDate);
            invoice.setSubscriptions(customerSubscriptions);
            HashMap<Integer, Payment> purchaseOrders = new HashMap<Integer, Payment>();
            for (Subscription subscription : customerSubscriptions) {
                dataAccessObject.fillUnbilledPayments(subscription, purchaseOrders, invoice);
            }
            for (Payment payment : purchaseOrders.values()) {
                invoice.addPayment(payment);
            }
            customer.setActiveInvoice(invoice);
            invoice.setCustomer(customer);
        }
        log.info((Object)"Subscription-tree building phase completed");
    }
}

