/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingEngineContext;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingHandler;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Invoice;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Payment;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.core.internal.Util;
import org.wso2.carbon.rule.common.Rule;
import org.wso2.carbon.rule.common.RuleSet;
import org.wso2.carbon.rule.common.exception.RuleRuntimeException;
import org.wso2.carbon.rule.kernel.backend.RuleBackendRuntime;
import org.wso2.carbon.rule.kernel.backend.RuleBackendRuntimeFactory;
import org.wso2.carbon.rule.kernel.backend.Session;
import org.wso2.carbon.rule.kernel.config.RuleEngineProvider;
import org.wso2.carbon.utils.CarbonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleHandler
implements BillingHandler {
    private static Log log = LogFactory.getLog(RuleHandler.class);
    private Session ruleSession;

    @Override
    public void init(Map<String, String> handlerConfig) throws BillingException {
        RuleEngineProvider ruleEngineProvider = Util.getRuleEngineConfigService().getRuleConfig().getRuleEngineProvider();
        try {
            Class<?> ruleBackendRuntimeFactoryClass = Class.forName(ruleEngineProvider.getClassName());
            RuleBackendRuntimeFactory ruleBackendRuntimeFactory = (RuleBackendRuntimeFactory)ruleBackendRuntimeFactoryClass.newInstance();
            RuleBackendRuntime ruleBackendRuntime = ruleBackendRuntimeFactory.getRuleBackendRuntime(ruleEngineProvider.getProperties(), Thread.currentThread().getContextClassLoader());
            RuleSet ruleSet = new RuleSet();
            Rule rule = new Rule();
            rule.setResourceType("regular");
            rule.setSourceType("url");
            String ruleFile = handlerConfig.get("file");
            ruleFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + ruleFile;
            rule.setValue("file://" + ruleFile);
            log.info((Object)("Rule: " + rule.getValue()));
            ruleSet.addRule(rule);
            ruleBackendRuntime.addRuleSet(ruleSet);
            this.ruleSession = ruleBackendRuntime.createSession(2);
        }
        catch (Exception e) {
            String msg = "Error occurred while initializing the rule executing environment: " + e.getMessage();
            log.error((Object)msg);
            throw new BillingException(msg, e);
        }
    }

    @Override
    public void execute(BillingEngineContext handlerContext) throws BillingException {
        List<Subscription> subscriptions = handlerContext.getSubscriptions();
        ArrayList<Object> rulesInput = new ArrayList<Object>();
        HashSet<Integer> customerSet = new HashSet<Integer>();
        for (Subscription subscription : subscriptions) {
            rulesInput.add(subscription);
            Customer customer = subscription.getCustomer();
            if (!customerSet.contains(customer.getId())) {
                customerSet.add(customer.getId());
                rulesInput.add(customer);
                Invoice invoice = customer.getActiveInvoice();
                rulesInput.add(invoice);
                List<Payment> payments = invoice.getPayments();
                if (payments != null) {
                    for (Payment payment : payments) {
                        rulesInput.add(payment);
                    }
                }
            }
            Item item = subscription.getItem();
            rulesInput.add(item);
            List<? extends Item> children = item.getChildren();
            if (children == null) continue;
            for (Item item2 : item.getChildren()) {
                rulesInput.add(item2);
            }
        }
        try {
            this.ruleSession.execute(rulesInput);
        }
        catch (RuleRuntimeException e) {
            String msg = "Error occurred while executing rules during the bill generation: " + e.getMessage();
            log.error((Object)msg);
            throw new BillingException(msg, (Exception)((Object)e));
        }
        log.info((Object)"Rule execution phase completed.");
    }
}

