/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.handlers;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingEngineContext;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingHandler;
import org.wso2.carbon.billing.core.BillingManager;
import org.wso2.carbon.billing.core.dataobjects.Cash;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Discount;
import org.wso2.carbon.billing.core.dataobjects.Invoice;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Payment;
import org.wso2.carbon.billing.core.dataobjects.Subscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvoiceCalculationHandler
implements BillingHandler {
    Log log = LogFactory.getLog(InvoiceCalculationHandler.class);
    Map<Integer, Discount> discountMap = new HashMap<Integer, Discount>();

    @Override
    public void init(Map<String, String> handlerConfig) throws BillingException {
        List<Discount> discountList = BillingManager.getInstance().getDataAccessObject().getAllActiveDiscounts();
        for (Discount discount : discountList) {
            this.discountMap.put(discount.getTenantId(), discount);
        }
    }

    @Override
    public void execute(BillingEngineContext handlerContext) throws BillingException {
        this.calculateInvoice(handlerContext);
    }

    private void calculateInvoice(BillingEngineContext handlerContext) throws BillingException {
        List<Subscription> subscriptions = handlerContext.getSubscriptions();
        HashMap<Integer, Invoice> invoiceMap = new HashMap<Integer, Invoice>();
        for (Subscription subscription : subscriptions) {
            Customer customer = subscription.getCustomer();
            Invoice invoice = customer.getActiveInvoice();
            Cash totalCost = invoice.getTotalCost();
            if (totalCost == null) {
                totalCost = new Cash("$0");
            }
            Item item = subscription.getItem();
            this.calculateItemCost(item, invoice, subscription);
            Cash itemCost = this.getItemCost(item);
            totalCost = Cash.add(totalCost, itemCost);
            invoice.setTotalCost(totalCost);
            if (invoiceMap.get(customer.getId()) != null) continue;
            invoiceMap.put(customer.getId(), invoice);
        }
        for (Invoice invoice : invoiceMap.values()) {
            List<Payment> payments;
            Cash totalPayment = invoice.getTotalPayment();
            if (totalPayment == null) {
                totalPayment = new Cash("$0");
            }
            if ((payments = invoice.getPayments()) != null) {
                for (Payment payment : payments) {
                    Cash paymentCash = payment.getAmount();
                    totalPayment = Cash.add(paymentCash, totalPayment);
                }
            }
            invoice.setTotalPayment(totalPayment);
            Cash boughtForward = invoice.getBoughtForward();
            if (boughtForward == null) {
                boughtForward = new Cash("$0");
            }
            Cash totalCost = invoice.getTotalCost();
            Cash carriedForward = Cash.subtract(Cash.add(boughtForward, totalCost), totalPayment);
            invoice.setCarriedForward(carriedForward);
        }
        this.log.info((Object)("Invoice calculation phase completed. " + invoiceMap.size() + " invoices were calculated"));
    }

    private Cash getItemCost(Item item) throws BillingException {
        Cash itemCost = item.getCost();
        if (itemCost == null) {
            itemCost = new Cash("$0");
        }
        if (item.getChildren() != null) {
            for (Item item2 : item.getChildren()) {
                Cash subItemCost = item2.getCost();
                if (subItemCost == null) continue;
                itemCost = Cash.add(itemCost, subItemCost);
            }
        }
        return itemCost;
    }

    private void calculateItemCost(Item item, Invoice invoice, Subscription subscription) throws BillingException {
        if (item.getChildren() != null) {
            for (Item item2 : item.getChildren()) {
                if (("bwOveruse".equals(item2.getName()) || "storageOveruse".equals(item2.getName())) && subscription.isActive()) {
                    this.calculateOverUseCharges(item, item2, subscription);
                    continue;
                }
                if (!"subscription".equals(item2.getName())) continue;
                this.prorateItemCosts(item2, invoice, subscription);
            }
        }
    }

    private void calculateOverUseCharges(Item item, Item subItem, Subscription subscription) throws BillingException {
        if ("bwOveruse".equals(subItem.getName())) {
            long bandwidthUsage = subscription.getCustomer().getTotalBandwidth() / 0x100000L;
            long bandwidthOveruse = 0L;
            if (bandwidthUsage > (long)item.getBandwidthLimit()) {
                bandwidthOveruse = bandwidthUsage - (long)item.getBandwidthLimit();
                subItem.setCost(item.getBandwidthOveruseCharge().multiply(bandwidthOveruse));
            }
            StringBuffer description = new StringBuffer();
            description.append(subItem.getDescription());
            description.append(": ").append(bandwidthOveruse).append("MB");
            subItem.setDescription(description.toString());
        } else if ("storageOveruse".equals(subItem.getName())) {
            long storageUsage = subscription.getCustomer().getTotalStorage() / 0x100000L;
            long storageOveruse = 0L;
            if (storageUsage > (long)item.getResourceVolumeLimit()) {
                storageOveruse = storageUsage - (long)item.getResourceVolumeLimit();
                subItem.setCost(item.getResourceVolumeOveruseCharge().multiply(storageOveruse));
            }
            StringBuffer description = new StringBuffer();
            description.append(subItem.getDescription());
            description.append(": ").append(storageOveruse).append("MB");
            subItem.setDescription(description.toString());
        }
    }

    private void prorateItemCosts(Item subItem, Invoice invoice, Subscription subscription) throws BillingException {
        long milisecondsPerDay = 86400000L;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        int tenantId = invoice.getCustomer().getId();
        Discount discount = this.discountMap.get(tenantId);
        long period = subscription.isActive() ? (subscription.getActiveSince().before(invoice.getStartDate()) ? invoice.getEndDate().getTime() - invoice.getStartDate().getTime() : invoice.getEndDate().getTime() - subscription.getActiveSince().getTime()) : (subscription.getActiveSince().before(invoice.getStartDate()) ? subscription.getActiveUntil().getTime() - invoice.getStartDate().getTime() : subscription.getActiveUntil().getTime() - subscription.getActiveSince().getTime());
        long days = period / milisecondsPerDay;
        if (days < 28L) {
            float multiplyingFactor = (float)days / 30.0f;
            multiplyingFactor = Float.parseFloat(nf.format(multiplyingFactor));
            if (subItem.getCost() != null) {
                subItem.setCost(subItem.getCost().multiply(multiplyingFactor));
            }
            if (discount != null && !discount.isPercentageType()) {
                discount.setAmount(Float.parseFloat(nf.format(discount.getAmount() * multiplyingFactor)));
            }
        }
        if (discount != null) {
            if (discount.isPercentageType()) {
                subItem.setCost(subItem.getCost().multiply(1.0f - discount.getPercentage() / 100.0f));
                subItem.setDescription(subItem.getDescription() + " (with " + discount.getPercentage() + "% discount)");
                this.log.info((Object)("Customer: " + tenantId + " was qualified for a discount of " + discount.getPercentage() + "% for subscription:" + subscription.getSubscriptionPlan() + " which started from:" + subscription.getActiveSince().toString()));
            } else {
                subItem.setCost(Cash.subtract(subItem.getCost(), new Cash(String.valueOf(discount.getAmount()))));
                subItem.setDescription(subItem.getDescription() + " (with " + new Cash(String.valueOf(discount.getAmount())).toString() + " discount)");
                this.log.info((Object)("Customer: " + tenantId + " was qualified for a discount of " + new Cash(String.valueOf(discount.getAmount())).toString() + " for subscription:" + subscription.getSubscriptionPlan() + " which started from:" + subscription.getActiveSince().toString()));
            }
        }
    }
}

