/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.handlers;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingEngineContext;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingHandler;
import org.wso2.carbon.billing.core.dataobjects.Cash;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Invoice;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Payment;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.core.internal.Util;
import org.wso2.carbon.email.sender.api.BulkEmailSender;
import org.wso2.carbon.email.sender.api.EmailDataHolder;
import org.wso2.carbon.email.sender.api.EmailSender;
import org.wso2.carbon.email.sender.api.EmailSenderConfiguration;
import org.wso2.carbon.stratos.common.util.ClaimsMgtUtil;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailSendingHandler
implements BillingHandler {
    private static Log log = LogFactory.getLog(EmailSendingHandler.class);
    private static String DEFAULT_EMAIL_NOTIFICATION_TEMPLATE_FILE = "email-billing-notification.xml";
    private static String DEFAULT_REPORT_EMAIL_TEMPLATE_FILE = "email-bill-generated.xml";
    private static String EMAIL_SENDING_CONF_KEY = "file";
    private static String REPORT_EMAIL_TO_ADDRESS = "cloudservice@wso2.com";
    BulkEmailSender bulkEmailSender;
    EmailSender reportMailSender;

    @Override
    public void init(Map<String, String> handlerConfig) throws BillingException {
        String confFileName;
        if (CommonUtil.getStratosConfig() != null) {
            REPORT_EMAIL_TO_ADDRESS = CommonUtil.getStratosConfig().getNotificationEmail();
        }
        if ((confFileName = handlerConfig.get(EMAIL_SENDING_CONF_KEY)) == null) {
            confFileName = DEFAULT_EMAIL_NOTIFICATION_TEMPLATE_FILE;
        }
        confFileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + confFileName;
        EmailSenderConfiguration emailSenderConfig = EmailSenderConfiguration.loadEmailSenderConfiguration((String)confFileName);
        this.bulkEmailSender = new BulkEmailSender(emailSenderConfig);
        String reportMailFileName = DEFAULT_REPORT_EMAIL_TEMPLATE_FILE;
        reportMailFileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + reportMailFileName;
        EmailSenderConfiguration reportEmailSenderConfig = EmailSenderConfiguration.loadEmailSenderConfiguration((String)reportMailFileName);
        this.reportMailSender = new EmailSender(reportEmailSenderConfig);
    }

    @Override
    public void execute(BillingEngineContext handlerContext) throws BillingException {
        List<Subscription> subscriptions = handlerContext.getSubscriptions();
        HashMap<Integer, Invoice> invoiceMap = new HashMap<Integer, Invoice>();
        ArrayList<Integer> creditLimitExceededCustomers = new ArrayList<Integer>();
        ArrayList<EmailDataHolder> emailDataList = new ArrayList<EmailDataHolder>();
        for (Subscription subscription : subscriptions) {
            Customer customer = subscription.getCustomer();
            Invoice invoice = customer.getActiveInvoice();
            if (invoiceMap.get(customer.getId()) != null) continue;
            invoiceMap.put(customer.getId(), invoice);
        }
        for (Invoice invoice : invoiceMap.values()) {
            Cash diff = Cash.subtract(new Cash("$0"), invoice.getCarriedForward());
            if (diff.getSign().equals((Object)Cash.Sign.NEGATIVE)) {
                Map<String, String> mailParameters = EmailSendingHandler.deriveInvoiceMailParameters(invoice);
                Customer customer = invoice.getCustomer();
                String emailAddress = customer.getEmail();
                EmailDataHolder emailData = new EmailDataHolder();
                emailData.setEmail(emailAddress);
                emailData.setEmailParameters(mailParameters);
                emailDataList.add(emailData);
            }
            if (!this.isExceedsCreditLimit(invoice)) continue;
            log.debug((Object)("Customer " + invoice.getCustomer().getName() + " needs to be reported"));
            creditLimitExceededCustomers.add(invoice.getCustomer().getId());
        }
        try {
            log.info((Object)("Sending emails to the customers: " + emailDataList.size()));
            this.bulkEmailSender.sendBulkEmails(emailDataList);
            log.info((Object)"Email (invoices) sending completed");
        }
        catch (Exception e) {
            String msg = "Error in sending the invoices to the customers";
            log.error((Object)msg, (Throwable)e);
        }
        Map<String, String> reportEmailParameters = this.deriveReportEmailParameters(creditLimitExceededCustomers, invoiceMap);
        try {
            this.reportMailSender.sendEmail(REPORT_EMAIL_TO_ADDRESS, reportEmailParameters);
            log.info((Object)"Email sent to the admin.");
        }
        catch (Exception e) {
            String msg = "Error in sending the bill generation completed email";
            log.error((Object)msg, (Throwable)e);
        }
    }

    public static Map<String, String> deriveInvoiceMailParameters(Invoice invoice) {
        HashMap<String, String> mailParameters = new HashMap<String, String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        mailParameters.put("start-date", dateFormat.format(invoice.getStartDate()));
        mailParameters.put("end-date", dateFormat.format(invoice.getEndDate()));
        Customer customer = invoice.getCustomer();
        try {
            TenantManager tenantManager = Util.getRealmService().getTenantManager();
            Tenant tenant = (Tenant)tenantManager.getTenant(customer.getId());
            mailParameters.put("tenant-domain", tenant.getDomain());
            String customerName = ClaimsMgtUtil.getFirstName((RealmService)Util.getRealmService(), (int)customer.getId());
            if (customerName != null) {
                mailParameters.put("customer-name", customerName);
            } else {
                mailParameters.put("customer-name", "");
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not get tenant information for tenant: " + customer.getName() + "\n" + e.getMessage()));
            mailParameters.put("customer-name", "");
        }
        List<Subscription> subscriptions = invoice.getSubscriptions();
        if (subscriptions != null) {
            StringBuffer subscriptionText = new StringBuffer();
            for (Subscription subscription : subscriptions) {
                if (subscription.isActive()) {
                    mailParameters.put("current-subscription", subscription.getSubscriptionPlan());
                }
                Item item = subscription.getItem();
                String itemName = item.getDescription();
                Cash itemCost = item.getCost();
                String subscriptionPlan = subscription.getSubscriptionPlan();
                if (itemCost != null) {
                    subscriptionText.append(subscriptionPlan).append("\t\t\t").append(itemCost.toString()).append("\n");
                } else {
                    subscriptionText.append(subscriptionPlan).append("\n");
                }
                List<? extends Item> children = item.getChildren();
                if (children != null) {
                    for (Item item2 : children) {
                        String childItemName = item2.getDescription();
                        Cash childItemCost = item2.getCost();
                        String childItemCostStr = childItemCost != null ? childItemCost.toString() : "$0.00";
                        subscriptionText.append("\t").append(childItemName).append("\t\t").append(childItemCostStr).append("\n");
                    }
                }
                subscriptionText.append("-------------------------------------------").append("\n");
            }
            mailParameters.put("subscription-charges", subscriptionText.toString());
        }
        StringBuffer paymentText = new StringBuffer();
        if (invoice.getPayments() != null && invoice.getPayments().size() > 0) {
            for (Payment payment : invoice.getPayments()) {
                Date paymentDate = payment.getDate();
                Cash paymentAmount = payment.getAmount();
                paymentText.append(dateFormat.format(paymentDate)).append("\t\t").append(paymentAmount.toString()).append("\n");
            }
        } else {
            paymentText.append("No payment details during this period");
        }
        mailParameters.put("payment-details", paymentText.toString());
        if (invoice.getBoughtForward() != null) {
            mailParameters.put("bought-forward", invoice.getBoughtForward().toString());
        } else {
            mailParameters.put("bought-forward", "$0");
        }
        if (invoice.getTotalCost() != null) {
            mailParameters.put("total-cost", invoice.getTotalCost().toString());
        } else {
            mailParameters.put("total-cost", "$0");
        }
        if (invoice.getTotalPayment() != null) {
            mailParameters.put("total-payments", invoice.getTotalPayment().toString());
        } else {
            mailParameters.put("total-payments", "$0");
        }
        if (invoice.getCarriedForward() != null) {
            mailParameters.put("carried-forward", invoice.getCarriedForward().toString());
        } else {
            mailParameters.put("carried-forward", "$0");
        }
        return mailParameters;
    }

    private boolean isExceedsCreditLimit(Invoice invoice) throws BillingException {
        Cash difference;
        boolean exceedsCreditLimit = false;
        Cash creditLimit = new Cash("$0");
        List<Subscription> subscriptions = invoice.getSubscriptions();
        block0: for (Subscription subscription : subscriptions) {
            if (!subscription.isActive()) continue;
            List<? extends Item> subItems = subscription.getItem().getChildren();
            for (Item item : subItems) {
                if (!"subscription".equals(item.getName())) continue;
                if (item.getCreditLimit() != null) {
                    creditLimit = Cash.add(creditLimit, item.getCreditLimit());
                    break block0;
                }
                creditLimit = Cash.add(creditLimit, new Cash("$0"));
                break block0;
            }
        }
        if (Cash.Sign.POSITIVE == (difference = Cash.subtract(invoice.getCarriedForward(), creditLimit)).getSign() && difference.getWholeNumber() > 0) {
            exceedsCreditLimit = true;
        }
        return exceedsCreditLimit;
    }

    public Map<String, String> deriveReportEmailParameters(List<Integer> creditExceededCustomers, Map<Integer, Invoice> invoiceMap) {
        HashMap<String, String> mailParameters = new HashMap<String, String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        mailParameters.put("date", dateFormat.format(new Date()));
        StringBuffer reportedCustomers = new StringBuffer();
        if (creditExceededCustomers.isEmpty()) {
            reportedCustomers.append("No customers to be reported");
        } else {
            for (Integer customerId : creditExceededCustomers) {
                Invoice invoice = invoiceMap.get(customerId);
                List<Subscription> subscriptions = invoice.getSubscriptions();
                String activeSubscriptionName = "";
                for (Subscription subscription : subscriptions) {
                    if (!subscription.isActive()) continue;
                    activeSubscriptionName = subscription.getSubscriptionPlan();
                    break;
                }
                reportedCustomers.append(invoice.getCustomer().getName()).append("\t\t").append(activeSubscriptionName).append("\t\t").append(invoice.getCarriedForward().toString()).append("\n");
            }
        }
        mailParameters.put("reported-customers", reportedCustomers.toString());
        return mailParameters;
    }
}

