/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.handlers;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingEngineContext;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingHandler;
import org.wso2.carbon.billing.core.BillingManager;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.core.jdbc.DataAccessObject;
import org.wso2.carbon.billing.core.utilities.CustomerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubscriptionFeedingHandler
implements BillingHandler {
    private static Log log = LogFactory.getLog(DefaultSubscriptionFeedingHandler.class);

    @Override
    public void init(Map<String, String> handlerConfig) throws BillingException {
    }

    @Override
    public void execute(BillingEngineContext handlerContext) throws BillingException {
        this.feedSubscriptions(handlerContext);
    }

    private void feedSubscriptions(BillingEngineContext handlerContext) throws BillingException {
        String filter = handlerContext.getTaskConfiguration().getSubscriptionFilter();
        Customer customer = handlerContext.getCustomer();
        List<Subscription> subscriptions = this.getFilteredActiveSubscriptions(filter, customer);
        handlerContext.setSubscriptions(subscriptions);
        String infoMsg = "Subscription feeding phase completed. ";
        infoMsg = subscriptions != null ? infoMsg + subscriptions.size() + " subscriptions fed. " : infoMsg + "0 subscriptions fed. ";
        log.info((Object)infoMsg);
    }

    private List<Subscription> getFilteredActiveSubscriptions(String filter, Customer customer) throws BillingException {
        DataAccessObject dataAccessObject = BillingManager.getInstance().getDataAccessObject();
        List<Subscription> subscriptions = null;
        try {
            dataAccessObject.beginTransaction();
            subscriptions = customer == null ? dataAccessObject.getFilteredActiveSubscriptions(filter) : dataAccessObject.getFilteredActiveSubscriptionsForCustomer(filter, customer);
            for (Subscription subscription : subscriptions) {
                Customer dummyCustomer = subscription.getCustomer();
                Customer correctCustomer = this.getCustomer(dummyCustomer.getId());
                subscription.setCustomer(correctCustomer);
                Item dummyItem = subscription.getItem();
                Item correctItem = this.getItem(dummyItem.getId());
                subscription.setItem(correctItem);
            }
            dataAccessObject.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while feeding subscription entries: " + e.getMessage();
            log.error((Object)msg);
            dataAccessObject.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return subscriptions;
    }

    private Item getItem(int itemId) throws BillingException {
        DataAccessObject dataAccessObject = BillingManager.getInstance().getDataAccessObject();
        Item item = null;
        try {
            dataAccessObject.beginTransaction();
            item = dataAccessObject.getItem(itemId);
            dataAccessObject.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while retrieving item for item id: " + itemId + ": " + e.getMessage();
            dataAccessObject.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return item;
    }

    private Customer getCustomer(int customerId) throws BillingException {
        Customer customer = new Customer();
        CustomerUtils.fillCustomerData(customerId, customer);
        return customer;
    }
}

