/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.handlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingEngineContext;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingHandler;
import org.wso2.carbon.billing.core.BillingManager;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Invoice;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.core.jdbc.DataAccessObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFinalizingHandler
implements BillingHandler {
    private static Log log = LogFactory.getLog(DefaultFinalizingHandler.class);

    @Override
    public void init(Map<String, String> handlerConfig) throws BillingException {
    }

    @Override
    public void execute(BillingEngineContext handlerContext) throws BillingException {
        this.saveInvoice(handlerContext);
    }

    private void saveInvoice(BillingEngineContext handlerContext) throws BillingException {
        DataAccessObject dataAccessObject = BillingManager.getInstance().getDataAccessObject();
        List<Subscription> subscriptions = handlerContext.getSubscriptions();
        HashMap<Integer, Invoice> invoiceMap = new HashMap<Integer, Invoice>();
        for (Subscription subscription : subscriptions) {
            Customer customer = subscription.getCustomer();
            Invoice invoice = customer.getActiveInvoice();
            if (invoiceMap.get(customer.getId()) != null) continue;
            invoiceMap.put(customer.getId(), invoice);
        }
        for (Invoice invoice : invoiceMap.values()) {
            dataAccessObject.addInvoice(invoice);
            subscriptions = invoice.getSubscriptions();
            for (Subscription subscription : subscriptions) {
                int invoiceSubscriptionId = dataAccessObject.addInvoiceSubscription(invoice, subscription);
                if (subscription.getItem() == null) continue;
                this.addInvoiceSubscriptionItem(subscription.getItem(), invoiceSubscriptionId);
            }
        }
        log.info((Object)(invoiceMap.size() + " Invoices saved to the database"));
    }

    private void addInvoiceSubscriptionItem(Item item, int invoiceSubscriptionId) throws BillingException {
        DataAccessObject dataAccessObject = BillingManager.getInstance().getDataAccessObject();
        dataAccessObject.addInvoiceSubscriptionItem(item, invoiceSubscriptionId);
        if (item.getChildren() != null) {
            for (Item item2 : item.getChildren()) {
                this.addInvoiceSubscriptionItem(item2, invoiceSubscriptionId);
            }
        }
    }
}

