/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.dataobjects;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingException;

public class Cash {
    private static final Log log = LogFactory.getLog(Cash.class);
    public static final String CURRENCY_USD = "$";
    public static final String DEFAULT_CURRENCY = "$";
    String currency;
    int wholeNumber;
    int decimalNumber;
    Sign sign = Sign.POSITIVE;
    private static final String notNumbersRegEx = "[^0-9]";
    private static final Pattern notNumbersPattern = Pattern.compile("[^0-9]");

    public Cash() {
    }

    public Cash(Cash copyFrom) {
        this.currency = copyFrom.getCurrency();
        this.wholeNumber = copyFrom.getWholeNumber();
        this.decimalNumber = copyFrom.getDecimalNumber();
        this.sign = copyFrom.getSign();
    }

    public Cash(String cashString) throws BillingException {
        if (cashString == null) {
            cashString = "$0";
        }
        if (cashString.startsWith("$")) {
            cashString = cashString.substring("$".length());
            this.currency = "$";
        } else {
            this.currency = "$";
        }
        if (cashString.startsWith("-")) {
            this.sign = Sign.NEGATIVE;
            cashString = cashString.substring(1);
        } else if (cashString.startsWith("+")) {
            this.sign = Sign.POSITIVE;
            cashString = cashString.substring(1);
        } else {
            this.sign = Sign.POSITIVE;
        }
        if (cashString.contains(".")) {
            String wholeNumberStr = cashString.substring(0, cashString.indexOf("."));
            if (wholeNumberStr.trim().equals("")) {
                String msg = "Whole number can not be empty";
                throw new BillingException(msg);
            }
            if (notNumbersPattern.matcher(wholeNumberStr).find()) {
                String msg = "The whole number expected to have only 0-9 characters.: " + wholeNumberStr + " is not a number. ";
                throw new BillingException(msg);
            }
            String decimalNumberStr = cashString.substring(cashString.indexOf(".") + 1);
            if (notNumbersPattern.matcher(decimalNumberStr).find()) {
                String msg = "The decimal number expected to have only 0-9 characters.: " + decimalNumberStr + " is not a number. ";
                throw new BillingException(msg);
            }
            if (decimalNumberStr.length() == 0) {
                String msg = "String after the decimal point is zero.";
                throw new BillingException(msg);
            }
            if (decimalNumberStr.length() > 2) {
                String msg = "String after the decimal point is greater than 2";
                throw new BillingException(msg);
            }
            if (decimalNumberStr.length() == 1) {
                decimalNumberStr = decimalNumberStr + "0";
            }
            this.wholeNumber = Integer.parseInt(wholeNumberStr);
            this.decimalNumber = Integer.parseInt(decimalNumberStr);
        } else {
            if (notNumbersPattern.matcher(cashString).find()) {
                String msg = "The cash string to have only 0-9 characters.: " + cashString + " is not a number. ";
                throw new BillingException(msg);
            }
            this.wholeNumber = Integer.parseInt(cashString);
            this.decimalNumber = 0;
        }
    }

    public Sign getSign() {
        return this.sign;
    }

    public void setSign(Sign sign) {
        this.sign = sign;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public int getWholeNumber() {
        return this.wholeNumber;
    }

    public void setWholeNumber(int wholeNumber) {
        this.wholeNumber = wholeNumber;
    }

    public int getDecimalNumber() {
        return this.decimalNumber;
    }

    public void setDecimalNumber(int decimalNumber) {
        this.decimalNumber = decimalNumber;
    }

    public String serializeToString() {
        String str = this.currency;
        if (this.sign == Sign.NEGATIVE) {
            str = str + "-";
        }
        str = str + this.wholeNumber + ".";
        str = this.decimalNumber < 10 ? str + "0" + this.decimalNumber : str + this.decimalNumber;
        return str;
    }

    public String toString() {
        return this.serializeToString();
    }

    public static Cash add(Cash a, Cash b) throws BillingException {
        if (!a.getCurrency().equals(b.getCurrency())) {
            String msg = "Can not add in-similar currencies: " + a.getCurrency() + "!=" + b.getCurrency() + ".";
            log.error((Object)msg);
            throw new BillingException(msg);
        }
        if (a.getSign() == Sign.POSITIVE && b.getSign() == Sign.NEGATIVE) {
            Cash b2 = new Cash(b);
            b2.setSign(Sign.POSITIVE);
            return Cash.subtract(a, b2);
        }
        if (a.getSign() == Sign.NEGATIVE && b.getSign() == Sign.POSITIVE) {
            Cash a2 = new Cash(a);
            a2.setSign(Sign.POSITIVE);
            return Cash.subtract(b, a2);
        }
        if (a.getSign() == Sign.NEGATIVE && b.getSign() == Sign.NEGATIVE) {
            Cash a2 = new Cash(a);
            Cash b2 = new Cash(b);
            a2.setSign(Sign.POSITIVE);
            b2.setSign(Sign.POSITIVE);
            Cash c2 = Cash.add(a2, b2);
            c2.setSign(Sign.NEGATIVE);
            return c2;
        }
        int decimalSum = a.getDecimalNumber() + b.getDecimalNumber();
        int wholeSum = a.getWholeNumber() + b.getWholeNumber();
        Cash cash = new Cash();
        cash.setCurrency(a.getCurrency());
        if (decimalSum >= 100) {
            decimalSum -= 100;
            ++wholeSum;
        }
        cash.setDecimalNumber(decimalSum);
        cash.setWholeNumber(wholeSum);
        cash.setSign(Sign.POSITIVE);
        return cash;
    }

    public static Cash subtract(Cash a, Cash b) throws BillingException {
        if (!a.getCurrency().equals(b.getCurrency())) {
            String msg = "Can not add in-similar currencies: " + a.getCurrency() + "!=" + b.getCurrency() + ".";
            log.error((Object)msg);
            throw new BillingException(msg);
        }
        if (a.getSign() == Sign.POSITIVE && b.getSign() == Sign.NEGATIVE) {
            Cash b2 = new Cash(b);
            b2.setSign(Sign.POSITIVE);
            return Cash.add(a, b2);
        }
        if (a.getSign() == Sign.NEGATIVE && b.getSign() == Sign.POSITIVE) {
            Cash a2 = new Cash(a);
            a2.setSign(Sign.POSITIVE);
            Cash c2 = Cash.add(b, a2);
            c2.setSign(Sign.NEGATIVE);
            return c2;
        }
        if (a.getSign() == Sign.NEGATIVE && b.getSign() == Sign.NEGATIVE) {
            Cash a2 = new Cash(a);
            Cash b2 = new Cash(b);
            a2.setSign(Sign.POSITIVE);
            b2.setSign(Sign.POSITIVE);
            Cash c2 = Cash.subtract(a2, b2);
            if (c2.getSign() == Sign.NEGATIVE) {
                c2.setSign(Sign.POSITIVE);
            } else {
                c2.setSign(Sign.NEGATIVE);
            }
            return c2;
        }
        int decimalSum = a.getDecimalNumber() - b.getDecimalNumber();
        int wholeSum = a.getWholeNumber() - b.getWholeNumber();
        if (wholeSum < 0 || decimalSum < 0 && wholeSum == 0) {
            Cash c = Cash.subtract(b, a);
            c.setSign(Sign.NEGATIVE);
            return c;
        }
        Cash cash = new Cash();
        cash.setCurrency(a.getCurrency());
        if (decimalSum < 0) {
            decimalSum += 100;
            --wholeSum;
        }
        cash.setDecimalNumber(decimalSum);
        cash.setWholeNumber(wholeSum);
        return cash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Cash)) {
            return false;
        }
        Cash otherCash = (Cash)o;
        return otherCash.serializeToString().equals(this.serializeToString());
    }

    public int hashCode() {
        return this.serializeToString().hashCode();
    }

    public Cash multiply(double multiplyBy) {
        long answerInCent = (long)((double)(this.wholeNumber * 100) * multiplyBy + (double)this.decimalNumber * multiplyBy);
        int newWholeNumber = (int)(answerInCent / 100L);
        int newDecimalNumber = (int)(answerInCent % 100L);
        Cash cash = new Cash();
        cash.setCurrency(this.getCurrency());
        if (newWholeNumber < 0) {
            cash.setSign(Sign.NEGATIVE);
        }
        cash.setWholeNumber(newWholeNumber);
        cash.setDecimalNumber(newDecimalNumber);
        return cash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sign {
        POSITIVE,
        NEGATIVE;

    }
}

