/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.conf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingHandler;
import org.wso2.carbon.billing.core.scheduler.ScheduleHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BillingTaskConfiguration {
    private static final Log log = LogFactory.getLog(BillingTaskConfiguration.class);
    private String id;
    private ScheduleHelper scheduleHelper = null;
    private Map<String, String> schedulerHelperArgs;
    private String schedulerServiceName;
    private String subscriptionFilter;
    private List<BillingHandler> billingHandlers = new ArrayList<BillingHandler>();
    private List<HandlerConfigBean> handlerArgs = new ArrayList<HandlerConfigBean>();
    private static Map<String, ScheduleHelper> schedulerServices = new HashMap<String, ScheduleHelper>();
    private static Map<String, BillingHandler> handlerServices = new HashMap<String, BillingHandler>();

    public BillingTaskConfiguration(String id, OMElement billingConfigEle) throws BillingException {
        this.id = id;
        this.deserialize(billingConfigEle);
    }

    private void deserialize(OMElement taskConfigEle) throws BillingException {
        Iterator billingConfigChildIt = taskConfigEle.getChildElements();
        while (billingConfigChildIt.hasNext()) {
            OMElement childEle = (OMElement)billingConfigChildIt.next();
            if (new QName("http://wso2.com/carbon/multitenancy/billing/config", "subscriptionFilter", "").equals(childEle.getQName())) {
                this.subscriptionFilter = childEle.getText().trim();
                continue;
            }
            if (new QName("http://wso2.com/carbon/multitenancy/billing/config", "schedule", "").equals(childEle.getQName())) {
                this.deserializeSchedule(childEle);
                continue;
            }
            if (new QName("http://wso2.com/carbon/multitenancy/billing/config", "handlers", "").equals(childEle.getQName())) {
                this.deserializeHandlers(childEle);
                continue;
            }
            String msg = "Unknown element in task configuration for task " + this.id + ": " + childEle.getQName().getLocalPart();
            log.error((Object)msg);
            throw new BillingException(msg);
        }
    }

    private void deserializeHandlers(OMElement handlersEle) throws BillingException {
        Iterator handlersChildIt = handlersEle.getChildElements();
        while (handlersChildIt.hasNext()) {
            OMElement handlerEle = (OMElement)handlersChildIt.next();
            if (!new QName("http://wso2.com/carbon/multitenancy/billing/config", "handler", "").equals(handlerEle.getQName())) {
                String msg = "Unknown element in handler configuration for task " + this.id + ": " + handlerEle.getQName().getLocalPart();
                log.error((Object)msg);
                throw new BillingException(msg);
            }
            Iterator handlerParametersIt = handlerEle.getChildElements();
            Map<String, String> constructorArgs = BillingTaskConfiguration.extractConstructorArgs(handlerParametersIt);
            String handlerClassName = handlerEle.getAttributeValue(new QName("class"));
            if (handlerClassName == null) {
                String handlerServiceName = handlerEle.getAttributeValue(new QName("service"));
                HandlerConfigBean bean = new HandlerConfigBean(handlerServiceName, true, constructorArgs);
                this.handlerArgs.add(bean);
                continue;
            }
            HandlerConfigBean bean = new HandlerConfigBean(handlerClassName, false, constructorArgs);
            this.handlerArgs.add(bean);
        }
    }

    private void deserializeSchedule(OMElement scheduleEle) throws BillingException {
        Iterator scheduleHelperConfigChildIt = scheduleEle.getChildElements();
        Map<String, String> constructorArgs = BillingTaskConfiguration.extractConstructorArgs(scheduleHelperConfigChildIt);
        String className = scheduleEle.getAttributeValue(new QName("scheduleHelperClass"));
        if (className == null) {
            this.schedulerServiceName = scheduleEle.getAttributeValue(new QName("scheduleHelperService"));
            this.schedulerHelperArgs = constructorArgs;
        } else {
            this.scheduleHelper = (ScheduleHelper)BillingTaskConfiguration.constructObject(className);
            this.scheduleHelper.init(constructorArgs);
        }
    }

    public String getSubscriptionFilter() {
        return this.subscriptionFilter;
    }

    public ScheduleHelper getScheduleHelper() throws BillingException {
        if (this.scheduleHelper == null && this.schedulerServiceName != null) {
            this.scheduleHelper = schedulerServices.get(this.schedulerServiceName);
            if (this.scheduleHelper == null) {
                String msg = "The scheduler helper service: " + this.schedulerServiceName + " is not loaded.";
                log.error((Object)msg);
                throw new BillingException(msg);
            }
            this.scheduleHelper.init(this.schedulerHelperArgs);
        }
        return this.scheduleHelper;
    }

    public List<BillingHandler> getBillingHandlers() throws BillingException {
        if (!this.handlerArgs.isEmpty()) {
            for (HandlerConfigBean bean : this.handlerArgs) {
                if (bean.isServiceType) {
                    BillingHandler handlerService = handlerServices.get(bean.name);
                    if (handlerService == null) {
                        this.billingHandlers = null;
                        String msg = "The handler service: " + bean.name + " is not loaded.";
                        log.error((Object)msg);
                        throw new BillingException(msg);
                    }
                    handlerService.init(bean.constructorArgs);
                    this.billingHandlers.add(handlerService);
                    continue;
                }
                BillingHandler handler = (BillingHandler)BillingTaskConfiguration.constructObject(bean.name);
                handler.init(bean.constructorArgs);
                this.billingHandlers.add(handler);
            }
            this.handlerArgs.clear();
        }
        return this.billingHandlers;
    }

    private static Object constructObject(String className) throws BillingException {
        try {
            return Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException e) {
            String msg = "The class: " + className + " is not in the classpath.";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        catch (Exception e) {
            String msg = "Error in initializing the object for " + className + ".";
            log.error((Object)msg);
            throw new BillingException(msg, e);
        }
    }

    private static Map<String, String> extractConstructorArgs(Iterator parameterIt) {
        HashMap<String, String> constructorArgs = new HashMap<String, String>();
        while (parameterIt.hasNext()) {
            OMElement paramEle = (OMElement)parameterIt.next();
            if (!new QName("http://wso2.com/carbon/multitenancy/billing/config", "parameter", "").equals(paramEle.getQName())) continue;
            String paramName = paramEle.getAttributeValue(new QName("name"));
            String paramValue = paramEle.getText();
            constructorArgs.put(paramName, paramValue);
        }
        return constructorArgs;
    }

    public String getId() {
        return this.id;
    }

    public static void addScheduleHelper(ScheduleHelper scheduleHelper) {
        schedulerServices.put(scheduleHelper.getClass().getName(), scheduleHelper);
    }

    public static void addBillingHandler(BillingHandler billingHandler) {
        handlerServices.put(billingHandler.getClass().getName(), billingHandler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HandlerConfigBean {
        public String name;
        public boolean isServiceType;
        public Map<String, String> constructorArgs;

        public HandlerConfigBean(String name, boolean isServiceType, Map<String, String> constructorArgs) {
            this.name = name;
            this.isServiceType = isServiceType;
            this.constructorArgs = constructorArgs;
        }
    }
}

