/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core.conf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.conf.BillingTaskConfiguration;
import org.wso2.carbon.billing.core.internal.Util;
import org.wso2.carbon.ndatasource.common.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BillingConfiguration {
    private static final Log log = LogFactory.getLog(BillingConfiguration.class);
    DataSource dataSource;
    Map<String, BillingTaskConfiguration> billingTaskConfigs = new HashMap<String, BillingTaskConfiguration>();

    public BillingConfiguration(String billingConfigFile) throws BillingException {
        try {
            this.dataSource = (DataSource)Util.getDataSourceService().getDataSource("WSO2BillingDS").getDSObject();
            OMElement billingConfig = this.buildOMElement(new FileInputStream(billingConfigFile));
            this.deserialize(billingConfig);
        }
        catch (FileNotFoundException e) {
            String msg = "Unable to find the file responsible for billing task configs: " + billingConfigFile;
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        catch (DataSourceException e) {
            String msg = "Error retrieving Billing datasource from master-datasources.xml configuration.";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, (Exception)((Object)e));
        }
    }

    private OMElement buildOMElement(InputStream inputStream) throws BillingException {
        XMLStreamReader parser;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException e) {
            String msg = "Error in initializing the parser to build the OMElement.";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    private void deserialize(OMElement billingConfigEle) throws BillingException {
        Iterator billingConfigChildIt = billingConfigEle.getChildElements();
        while (billingConfigChildIt.hasNext()) {
            OMElement billingConfigChildEle = (OMElement)billingConfigChildIt.next();
            if (new QName("http://wso2.com/carbon/multitenancy/billing/config", "tasks", "").equals(billingConfigChildEle.getQName())) {
                Iterator taskConfigChildIt = billingConfigChildEle.getChildElements();
                while (taskConfigChildIt.hasNext()) {
                    OMElement taskConfigEle = (OMElement)taskConfigChildIt.next();
                    String id = taskConfigEle.getAttributeValue(new QName("id"));
                    BillingTaskConfiguration taskConfig = new BillingTaskConfiguration(id, taskConfigEle);
                    this.billingTaskConfigs.put(id, taskConfig);
                }
                continue;
            }
            String msg = "Unknown element in Billing Configuration: " + billingConfigChildEle.getQName().getLocalPart();
            log.error((Object)msg);
            throw new BillingException(msg);
        }
    }

    public Map<String, BillingTaskConfiguration> getBillingTaskConfigs() {
        return this.billingTaskConfigs;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

