/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.core.internal.Util;
import org.wso2.carbon.billing.core.jdbc.DataAccessObject;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAccessManager {
    private static Log log = LogFactory.getLog(DataAccessManager.class);
    private DataAccessObject dataAccessObject = null;

    public DataAccessManager(DataSource dataSource) {
        this.dataAccessObject = new DataAccessObject(dataSource);
    }

    public DataAccessManager(DataAccessObject dao) {
        this.dataAccessObject = dao;
    }

    public void beginTransaction() throws BillingException {
        this.dataAccessObject.beginTransaction();
    }

    public void commitTransaction() throws BillingException {
        this.dataAccessObject.commitTransaction();
    }

    public void rollbackTransaction() throws BillingException {
        this.dataAccessObject.rollbackTransaction();
    }

    public int addSubscription(Subscription subscription) throws BillingException {
        int subscriptionId = 0;
        try {
            this.beginTransaction();
            subscriptionId = this.dataAccessObject.addSubscription(subscription, subscription.getSubscriptionPlan());
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while adding subscription: " + subscription.getSubscriptionPlan() + " for the customer " + subscription.getCustomer().getName() + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return subscriptionId;
    }

    public void deleteBillingData(int tenantId) throws BillingException {
        try {
            this.beginTransaction();
            this.dataAccessObject.deleteBillingData(tenantId);
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            String msg = "Error occurred while deleting subscription for tenant id: " + tenantId;
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
    }

    public List<Customer> getCustomersWithName(String customerName) throws BillingException {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        ArrayList<Customer> customers = new ArrayList<Customer>();
        try {
            int tenantId = tenantManager.getTenantId(customerName);
            Tenant tenant = tenantManager.getTenant(tenantId);
            if (tenant != null) {
                Customer customer = new Customer();
                customer.setId(tenant.getId());
                customer.setName(tenant.getDomain());
                customer.setStartedDate(tenant.getCreatedDate());
                customer.setEmail(tenant.getEmail());
                customers.add(customer);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get customers for customers: " + customerName + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        return customers;
    }

    public Subscription getSubscription(int subscriptionId) throws BillingException {
        Subscription subscription = null;
        try {
            this.beginTransaction();
            subscription = this.dataAccessObject.getSubscription(subscriptionId);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting subscription with id: " + subscriptionId + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return subscription;
    }

    public Subscription getActiveSubscriptionOfCustomer(int customerId) throws BillingException {
        Subscription subscription;
        try {
            this.beginTransaction();
            subscription = this.dataAccessObject.getActiveSubscriptionOfCustomer(customerId);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting active subscription for customer: " + customerId + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return subscription;
    }

    public int getItemIdWithName(String name, int parentId) throws BillingException {
        int itemId;
        try {
            this.beginTransaction();
            itemId = this.dataAccessObject.getItemId(name, parentId);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting item id for item name: " + name + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return itemId;
    }

    public boolean changeSubscription(int customerId, String subscriptionPlan) throws BillingException {
        boolean changed = false;
        String oldSubscriptionPlan = null;
        try {
            this.beginTransaction();
            Subscription oldSubscription = this.getActiveSubscriptionOfCustomer(customerId);
            if (oldSubscription != null) {
                oldSubscriptionPlan = oldSubscription.getSubscriptionPlan();
            }
            changed = this.dataAccessObject.changeSubscription(customerId, subscriptionPlan);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while changing subscription to: " + subscriptionPlan + " for customer: " + customerId + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        try {
            Util.alertTenantSubscriptionPlanChange(customerId, oldSubscriptionPlan, subscriptionPlan);
        }
        catch (StratosException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BillingException(e.getMessage(), (Exception)((Object)e));
        }
        return changed;
    }

    public List<Subscription> getInactiveSubscriptionsOfCustomer(int customerId) throws BillingException {
        List<Subscription> subscriptions;
        try {
            this.beginTransaction();
            subscriptions = this.dataAccessObject.getInactiveSubscriptionsOfCustomer(customerId);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting inactive subscriptions of customer: " + customerId + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return subscriptions;
    }

    public boolean activateSubscription(int subscriptionId) throws BillingException {
        boolean activated = false;
        try {
            this.beginTransaction();
            activated = this.dataAccessObject.activateSubscription(subscriptionId);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while activating subscription with id: " + subscriptionId + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return activated;
    }

    public boolean deactivateActiveSubscription(int tenantId) throws BillingException {
        boolean deactivated = false;
        try {
            this.beginTransaction();
            deactivated = this.dataAccessObject.deactivateCurrentSubscriptoin(tenantId);
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            String msg = "Error occurred while deactivating the active subscription of customer: " + tenantId;
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        return deactivated;
    }
}

