/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.core.internal.Util;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.internal.CloudCommonServiceComponent;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class BillingTenantMgtListenerImpl
implements TenantMgtListener {
    private static Log log = LogFactory.getLog(BillingTenantMgtListenerImpl.class);

    public void onTenantCreate(TenantInfoBean tenantInfo) throws StratosException {
        Customer customer = new Customer();
        customer.setName(tenantInfo.getTenantDomain());
        customer.setEmail(tenantInfo.getEmail());
        customer.setStartedDate(new Date(tenantInfo.getCreatedDate().getTimeInMillis()));
        customer.setFullName(tenantInfo.getFirstname() + " " + tenantInfo.getLastname());
        customer.setId(tenantInfo.getTenantId());
        Subscription subscription = new Subscription();
        subscription.setCustomer(customer);
        subscription.setActive(false);
        subscription.setActiveSince(Calendar.getInstance().getTime());
        subscription.setItem(new Item());
        subscription.setSubscriptionPlan(tenantInfo.getUsagePlan());
        try {
            Util.getDataAccessManager().addSubscription(subscription);
        }
        catch (Exception e) {
            String msg = "Could not add new subscription for tenant: " + tenantInfo.getTenantDomain();
            log.error((Object)(msg + e.getMessage()), (Throwable)e);
            throw new StratosException(msg, (Throwable)e);
        }
    }

    public void onTenantUpdate(TenantInfoBean tenantInfo) throws StratosException {
        try {
            Subscription currentSubscription = Util.getDataAccessManager().getActiveSubscriptionOfCustomer(tenantInfo.getTenantId());
            if (currentSubscription != null && currentSubscription.getSubscriptionPlan() != null) {
                boolean updated;
                if (!currentSubscription.getSubscriptionPlan().equals(tenantInfo.getUsagePlan()) && (updated = Util.getDataAccessManager().changeSubscription(tenantInfo.getTenantId(), tenantInfo.getUsagePlan()))) {
                    log.info((Object)("Usage plan was changed successfully from " + currentSubscription.getSubscriptionPlan() + " to " + tenantInfo.getUsagePlan()));
                }
            } else {
                TenantManager tenantManager = CloudCommonServiceComponent.getTenantManager();
                Tenant tenant = tenantManager.getTenant(tenantInfo.getTenantId());
                if (tenant.isActive()) {
                    Subscription subscription = new Subscription();
                    subscription.setActive(true);
                    subscription.setSubscriptionPlan(tenantInfo.getUsagePlan());
                    subscription.setActiveSince(null);
                    subscription.setActiveUntil(null);
                    Customer customer = new Customer();
                    customer.setName(tenantInfo.getTenantDomain());
                    customer.setId(tenantInfo.getTenantId());
                    subscription.setCustomer(customer);
                    int subsId = Util.getDataAccessManager().addSubscription(subscription);
                    if (subsId > 0) {
                        log.info((Object)("Added a new " + subscription.getSubscriptionPlan() + " usage plan for the tenant " + tenantInfo.getTenantDomain()));
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while changing the subscription plan for tenant: " + tenantInfo.getTenantDomain();
            log.error((Object)msg, (Throwable)e);
            throw new StratosException(msg, (Throwable)e);
        }
    }

    public void onTenantRename(int tenantId, String oldDomainName, String newDomainName) throws StratosException {
    }

    public void onTenantInitialActivation(int tenantId) throws StratosException {
    }

    public void onTenantActivation(int tenantId) throws StratosException {
        try {
            Subscription subscription = Util.getDataAccessManager().getActiveSubscriptionOfCustomer(tenantId);
            if (subscription != null) {
                String msg = "Unable to activate the subscription for tenant: " + tenantId + ". An active subscription already exists";
                log.info((Object)msg);
            } else {
                List<Subscription> inactiveSubscriptions = Util.getDataAccessManager().getInactiveSubscriptionsOfCustomer(tenantId);
                if (inactiveSubscriptions.size() == 1) {
                    subscription = inactiveSubscriptions.get(0);
                    boolean activated = Util.getDataAccessManager().activateSubscription(subscription.getId());
                    if (activated) {
                        log.info((Object)("Subscription was activated for tenant: " + tenantId));
                    }
                } else if (inactiveSubscriptions.size() > 1) {
                    Subscription subscriptionToAdd = inactiveSubscriptions.get(0);
                    subscriptionToAdd.setActive(true);
                    subscriptionToAdd.setActiveSince(null);
                    subscriptionToAdd.setActiveUntil(null);
                    int subsId = Util.getDataAccessManager().addSubscription(subscriptionToAdd);
                    if (subsId > 0) {
                        log.info((Object)("New subscription: " + subscriptionToAdd.getSubscriptionPlan() + " added and it was activated for tenant: " + tenantId));
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while activating the subscription for tenant: " + tenantId;
            log.error((Object)msg, (Throwable)e);
            throw new StratosException(msg, (Throwable)e);
        }
    }

    public void onTenantDeactivation(int tenantId) throws StratosException {
        try {
            Subscription currentActiveSubscription = Util.getDataAccessManager().getActiveSubscriptionOfCustomer(tenantId);
            if (currentActiveSubscription == null) {
                String msg = "There is no active subscription to deactivate for tenant: " + tenantId + " on tenant deactivation";
                log.info((Object)msg);
            } else {
                boolean deactivated = Util.getDataAccessManager().deactivateActiveSubscription(tenantId);
                if (deactivated) {
                    log.info((Object)"Subscription deactivated on tenant deactivation");
                } else {
                    log.info((Object)"Subscription was not deactivated on tenant deactivation");
                }
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while deactivating the active subscription for tenant: " + tenantId;
            log.error((Object)msg, (Throwable)e);
            throw new StratosException(msg, (Throwable)e);
        }
    }

    public void onSubscriptionPlanChange(int tenentId, String oldPlan, String newPlan) throws StratosException {
    }

    public int getListenerOrder() {
        return 0;
    }
}

