/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingEngine;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.conf.BillingConfiguration;
import org.wso2.carbon.billing.core.conf.BillingTaskConfiguration;
import org.wso2.carbon.billing.core.jdbc.DataAccessObject;

public class BillingManager {
    private static final Log log = LogFactory.getLog(BillingManager.class);
    private static BillingManager billingManager;
    private BillingConfiguration billingConfiguration;
    private DataAccessObject dataAccessObject;
    private Map<String, BillingEngine> billingEngines = new HashMap<String, BillingEngine>();

    public static BillingManager getInstance() throws BillingException {
        if (billingManager == null) {
            String msg = "Billing Manager is not initialized.";
            log.error((Object)msg);
            throw new BillingException(msg);
        }
        return billingManager;
    }

    public static void destroyInstance() {
        billingManager = null;
    }

    public BillingManager(BillingConfiguration billingConfiguration) throws BillingException {
        if (billingManager != null) {
            String msg = "Billing Manager should not be initialized twice";
            log.error((Object)msg);
            throw new BillingException(msg);
        }
        this.billingConfiguration = billingConfiguration;
        this.dataAccessObject = new DataAccessObject(billingConfiguration.getDataSource());
        Map<String, BillingTaskConfiguration> billingTaskConfigs = billingConfiguration.getBillingTaskConfigs();
        for (Map.Entry<String, BillingTaskConfiguration> entry : billingTaskConfigs.entrySet()) {
            String billingTaskName = entry.getKey();
            BillingTaskConfiguration billingTaskConfiguration = entry.getValue();
            BillingEngine billingEngine = new BillingEngine(billingTaskConfiguration, this.dataAccessObject);
            this.billingEngines.put(billingTaskName, billingEngine);
        }
        billingManager = this;
    }

    public BillingConfiguration getBillingConfiguration() {
        return this.billingConfiguration;
    }

    public DataAccessObject getDataAccessObject() {
        return this.dataAccessObject;
    }

    public BillingEngine getBillingEngine(String billingTaskName) {
        return this.billingEngines.get(billingTaskName);
    }
}

