/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingEngineContext;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingHandler;
import org.wso2.carbon.billing.core.beans.OutstandingBalanceInfoBean;
import org.wso2.carbon.billing.core.conf.BillingTaskConfiguration;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Discount;
import org.wso2.carbon.billing.core.dataobjects.Invoice;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Payment;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.core.internal.Util;
import org.wso2.carbon.billing.core.jdbc.DataAccessObject;
import org.wso2.carbon.billing.core.scheduler.BillingScheduler;
import org.wso2.carbon.billing.core.scheduler.SchedulerContext;
import org.wso2.carbon.billing.core.utilities.CustomerUtils;
import org.wso2.carbon.email.sender.api.EmailSender;
import org.wso2.carbon.email.sender.api.EmailSenderConfiguration;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BillingEngine {
    private static Log log = LogFactory.getLog(BillingEngine.class);
    private BillingTaskConfiguration billingTaskConfig;
    BillingScheduler billingScheduler;
    DataAccessObject dataAccessObject;

    public BillingEngine(BillingTaskConfiguration billingTaskConfig, DataAccessObject dataAccessObject) {
        this.billingTaskConfig = billingTaskConfig;
        this.billingScheduler = new BillingScheduler(this, billingTaskConfig);
        this.dataAccessObject = dataAccessObject;
    }

    public void scheduleBilling() throws BillingException {
        SchedulerContext schedulerContext = this.billingScheduler.createScheduleContext();
        this.billingScheduler.scheduleNextCycle(schedulerContext);
    }

    public void generateBill() throws BillingException {
        BillingEngineContext billingEngineContext = new BillingEngineContext();
        this.generateBill(billingEngineContext);
    }

    public void generateBill(SchedulerContext schedulerContext) throws BillingException {
        BillingEngineContext billingEngineContext = new BillingEngineContext();
        billingEngineContext.setSchedulerContext(schedulerContext);
        this.generateBill(billingEngineContext);
    }

    public void generateBill(BillingEngineContext billingEngineContext) throws BillingException {
        try {
            this.beginTransaction();
            if (billingEngineContext.getSchedulerContext() == null) {
                SchedulerContext schedulerContext = this.billingScheduler.createScheduleContext();
                billingEngineContext.setSchedulerContext(schedulerContext);
            }
            billingEngineContext.setTaskConfiguration(this.billingTaskConfig);
            List<BillingHandler> handlers = this.billingTaskConfig.getBillingHandlers();
            for (BillingHandler handler : handlers) {
                handler.execute(billingEngineContext);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while generating the bill:" + e.getMessage();
            log.error((Object)msg);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
    }

    public void beginTransaction() throws BillingException {
        this.dataAccessObject.beginTransaction();
    }

    public void commitTransaction() throws BillingException {
        this.dataAccessObject.commitTransaction();
    }

    public void rollbackTransaction() throws BillingException {
        this.dataAccessObject.rollbackTransaction();
    }

    public List<Item> getItemsWithName(String itemName) throws BillingException {
        List<Item> items;
        try {
            this.beginTransaction();
            items = this.dataAccessObject.getItemsWithName(itemName);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting item with name: " + itemName + " " + e.getMessage();
            log.error((Object)msg);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return items;
    }

    public int addItem(Item item) throws BillingException {
        int itemId = 0;
        try {
            this.beginTransaction();
            itemId = this.dataAccessObject.addItem(item);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while adding item: " + item.getName() + " " + e.getMessage();
            log.error((Object)msg);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return itemId;
    }

    public Item getItem(int itemId) throws BillingException {
        Item item;
        try {
            this.beginTransaction();
            item = this.dataAccessObject.getItem(itemId);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting item with id: " + itemId + " " + e.getMessage();
            log.error((Object)msg);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return item;
    }

    public List<Customer> getCustomersWithName(String customerName) throws BillingException {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        ArrayList<Customer> customers = new ArrayList<Customer>();
        try {
            int tenantId = tenantManager.getTenantId(customerName);
            Tenant tenant = tenantManager.getTenant(tenantId);
            if (tenant != null) {
                Customer customer = new Customer();
                customer.setId(tenant.getId());
                customer.setName(tenant.getDomain());
                customer.setStartedDate(tenant.getCreatedDate());
                customer.setEmail(tenant.getEmail());
                customers.add(customer);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get customers for customers: " + customerName + ".";
            log.error((Object)msg, (Throwable)e);
            throw new BillingException(msg, e);
        }
        return customers;
    }

    public int addSubscription(Subscription subscription) throws BillingException {
        int subscriptionId = 0;
        try {
            this.beginTransaction();
            subscriptionId = this.dataAccessObject.addSubscription(subscription, this.billingTaskConfig.getSubscriptionFilter());
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while adding subscription: " + subscription.getSubscriptionPlan() + " for the customer " + subscription.getCustomer().getName() + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return subscriptionId;
    }

    public int addPayment(Payment payment) throws BillingException {
        int paymentId = 0;
        try {
            this.beginTransaction();
            paymentId = this.dataAccessObject.addPayment(payment);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while adding payment record (transaction id): " + payment.getDescription() + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return paymentId;
    }

    public Invoice getLastInvoice(Customer customer) throws BillingException {
        Invoice invoice = null;
        try {
            this.beginTransaction();
            invoice = this.dataAccessObject.getLastInvoice(customer);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting last invoice for customer: " + customer.getId() + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return invoice;
    }

    public List<Invoice> getAllInvoices(Customer customer) throws BillingException {
        List<Invoice> invoices = null;
        try {
            this.beginTransaction();
            invoices = this.dataAccessObject.getAllInvoices(customer);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting all invoices for customer: " + customer.getId() + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return invoices;
    }

    public List<Subscription> getActiveSubscriptions(Customer customer) throws BillingException {
        List<Subscription> subscriptions;
        try {
            this.beginTransaction();
            subscriptions = this.dataAccessObject.getFilteredActiveSubscriptionsForCustomer(this.billingTaskConfig.getSubscriptionFilter(), customer);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting active subscriptions for customer: " + customer.getId() + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return subscriptions;
    }

    public Subscription getActiveSubscriptionOfCustomer(int customerId) throws BillingException {
        Subscription subscription;
        try {
            this.beginTransaction();
            subscription = this.dataAccessObject.getActiveSubscriptionOfCustomer(customerId);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting active subscription for customer: " + customerId + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return subscription;
    }

    public List<Invoice> getInvoices(Customer customer) throws BillingException {
        List<Invoice> invoices;
        try {
            this.beginTransaction();
            invoices = this.dataAccessObject.getInvoices(customer);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting invoices for customer: " + customer.getId() + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return invoices;
    }

    public Invoice getInvoice(int invoiceId) throws BillingException {
        Invoice invoice = null;
        try {
            this.beginTransaction();
            invoice = this.dataAccessObject.getInvoice(invoiceId);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting invoice with id: " + invoiceId + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return invoice;
    }

    public List<Item> getBilledItems(Subscription subscription) throws BillingException {
        List<Item> billedItems;
        try {
            this.beginTransaction();
            billedItems = this.dataAccessObject.getBilledItems(subscription);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting billed items for subscription: " + subscription.getId() + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return billedItems;
    }

    public List<Subscription> getInvoiceSubscriptions(int invoiceId) throws BillingException {
        List<Subscription> subscriptions;
        try {
            this.beginTransaction();
            subscriptions = this.dataAccessObject.getInvoiceSubscriptions(invoiceId);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting invoice subscriptions for invoice id: " + invoiceId + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return subscriptions;
    }

    public Payment getLastPayment(Customer customer) throws BillingException {
        Payment payment;
        try {
            this.beginTransaction();
            payment = this.dataAccessObject.getLastPayment(customer);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting the last payment for customer: " + customer.getId() + " " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return payment;
    }

    public List<Customer> getAllCustomers() throws BillingException {
        return CustomerUtils.getAllCustomers();
    }

    public List<OutstandingBalanceInfoBean> getAllOutstandingBalanceInfoBeans(String tenantDomain) throws BillingException {
        if (tenantDomain == null || "".equals(tenantDomain)) {
            return this.getAllOutstandingBalances(null);
        }
        List<Customer> customers = this.getCustomersWithName(tenantDomain);
        if (customers != null && customers.size() > 0) {
            return this.getAllOutstandingBalances(customers.get(0));
        }
        return new ArrayList<OutstandingBalanceInfoBean>();
    }

    public List<OutstandingBalanceInfoBean> getAllOutstandingBalances(Customer preferredCustomer) throws BillingException {
        List<Customer> customers;
        ArrayList<OutstandingBalanceInfoBean> outstandingBalances = new ArrayList<OutstandingBalanceInfoBean>();
        if (preferredCustomer != null) {
            customers = new ArrayList<Customer>();
            customers.add(preferredCustomer);
        } else {
            customers = this.getAllCustomers();
        }
        for (Customer customer : customers) {
            Subscription subscription;
            OutstandingBalanceInfoBean balanceBean = new OutstandingBalanceInfoBean();
            balanceBean.setCustomerName(customer.getName());
            Invoice invoice = this.getLastInvoice(customer);
            if (invoice != null) {
                balanceBean.setCarriedForward(invoice.getCarriedForward().toString());
                balanceBean.setLastInvoiceDate(invoice.getDate());
            }
            if ((subscription = this.getActiveSubscriptionOfCustomer(customer.getId())) != null) {
                balanceBean.setSubscription(subscription.getSubscriptionPlan());
            } else {
                balanceBean.setSubscription("Not Available");
            }
            Payment payment = this.getLastPayment(customer);
            if (payment != null) {
                balanceBean.setLastPaidAmount(payment.getAmount().toString());
                balanceBean.setLastPaymentDate(payment.getDate());
            }
            outstandingBalances.add(balanceBean);
        }
        return outstandingBalances;
    }

    public void sendPaymentReceivedEmail(String toAddress, String emailFile, Map<String, String> mailParameters) throws Exception {
        String emailTemplateFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + emailFile;
        EmailSenderConfiguration senderConfiguration = EmailSenderConfiguration.loadEmailSenderConfiguration((String)emailTemplateFile);
        EmailSender sender = new EmailSender(senderConfiguration);
        sender.sendEmail(toAddress, mailParameters);
    }

    public boolean addDiscount(Discount discount) throws Exception {
        boolean added = false;
        try {
            this.beginTransaction();
            added = this.dataAccessObject.addDiscount(discount);
            this.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred while adding the discount for tenant: " + discount.getTenantId() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            this.rollbackTransaction();
            throw new BillingException(msg, e);
        }
        return added;
    }
}

