/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.mgt.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.BillingPeriod;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.Discount;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.MultitenancyInvoice;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.OutstandingBalanceInfoBean;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.PaginatedBalanceInfoBean;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.Payment;
import org.wso2.carbon.billing.mgt.stub.services.MultitenancyBillingServiceStub;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class BillingServiceClient {
    private static final Log log = LogFactory.getLog(BillingServiceClient.class);
    private MultitenancyBillingServiceStub stub;
    private String epr;

    public BillingServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "MultitenancyBillingService";
        try {
            this.stub = new MultitenancyBillingServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate BillingService service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public BillingServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "MultitenancyBillingService";
        try {
            this.stub = new MultitenancyBillingServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate BillingService service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public BillingPeriod[] getAvailableBillingPeriods() throws Exception {
        return this.stub.getAvailableBillingPeriods();
    }

    public BillingPeriod[] getBillingPeriodsBySuperTenant(String tenantDomain) throws Exception {
        return this.stub.getAvailableBillingPeriodsBySuperTenant(tenantDomain);
    }

    public MultitenancyInvoice getPastInvoice(int invoiceId) throws Exception {
        return this.stub.getPastInvoice(invoiceId);
    }

    public MultitenancyInvoice getCurrentInvoice() throws Exception {
        return this.stub.getCurrentInvoice();
    }

    public int addPayment(Payment payment, String amount) throws Exception {
        return this.stub.addPayment(payment, amount);
    }

    public int makeAdjustment(Payment payment, String amount) throws Exception {
        return this.stub.makeAdjustment(payment, amount);
    }

    public PaginatedBalanceInfoBean getPaginatedBalanceInfo(int pageNumber) throws Exception {
        return this.stub.getPaginatedBalances(pageNumber);
    }

    public OutstandingBalanceInfoBean[] getOutstandingBalance(String tenantDomain) throws Exception {
        return this.stub.getOutstandingBalance(tenantDomain);
    }

    public boolean addDiscount(Discount discount, String tenantDomain) throws Exception {
        return this.stub.addDiscount(discount, tenantDomain);
    }
}

