/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.receiver.service;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.dataobjects.EventData;
import org.wso2.carbon.bam.receiver.ReceiverUtils;
import org.wso2.carbon.bam.receiver.authentication.ThriftAuthenticator;
import org.wso2.carbon.bam.receiver.authentication.ThriftSession;
import org.wso2.carbon.bam.service.Event;
import org.wso2.carbon.bam.service.ReceiverService;
import org.wso2.carbon.bam.service.SessionTimeOutException;

public class ReceiverServiceImpl
implements ReceiverService.Iface {
    private static final Log log = LogFactory.getLog(ReceiverServiceImpl.class);
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Event event, String sessionId) throws SessionTimeOutException {
        ThriftSession session;
        block12: {
            boolean isAuthenticated;
            String string = sessionId.intern();
            synchronized (string) {
                isAuthenticated = ThriftAuthenticator.getInstance().isAuthenticated(sessionId);
                session = ThriftAuthenticator.getInstance().getSessionInfo(sessionId);
            }
            if (isAuthenticated) {
                String date = formatter.format(new Date());
                Charset charset = Charset.forName("UTF-8");
                Map meta = event.getMeta();
                try {
                    if (!meta.containsKey("timeStamp")) {
                        meta.put("timeStamp", charset.newEncoder().encode(CharBuffer.wrap(date)));
                    }
                    break block12;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Unable to put timestamp for received event..", (Throwable)e);
                    }
                    break block12;
                }
            }
            throw new SessionTimeOutException("Session expired. Retry with authentication..");
        }
        EventData eventData = new EventData();
        eventData.setEventData(event.getEvent());
        eventData.setCorrelationData(event.getCorrelation());
        eventData.setMetaData(event.getMeta());
        String userName = session.getUserName();
        String password = session.getPassword();
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", userName);
        credentials.put("password", password);
        eventData.setCredentials(credentials);
        ReceiverUtils.getQueue().queue(eventData);
        if (log.isDebugEnabled()) {
            Map correlation = event.getCorrelation();
            Map meta = event.getMeta();
            Map eventData2 = event.getEvent();
            for (Map.Entry entry : correlation.entrySet()) {
                log.debug((Object)("Correlation - Key : " + (String)entry.getKey() + " Value : " + entry.getValue()));
            }
            for (Map.Entry entry : meta.entrySet()) {
                log.debug((Object)("Meta - Key : " + (String)entry.getKey() + " Value : " + entry.getValue()));
            }
            for (Map.Entry entry : eventData2.entrySet()) {
                log.debug((Object)("Event - Key : " + (String)entry.getKey() + " Value : " + entry.getValue()));
            }
        }
    }
}

