/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.receiver.internal;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.Servlet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.bam.receiver.ReceiverUtils;
import org.wso2.carbon.bam.receiver.authentication.ThriftAuthenticator;
import org.wso2.carbon.bam.receiver.internal.EventQueue;
import org.wso2.carbon.bam.receiver.service.AuthenticatorServiceImpl;
import org.wso2.carbon.bam.receiver.service.AuthenticatorServlet;
import org.wso2.carbon.bam.receiver.service.ReceiverServiceImpl;
import org.wso2.carbon.bam.receiver.service.ReceiverServlet;
import org.wso2.carbon.bam.service.AuthenticatorService;
import org.wso2.carbon.bam.service.ReceiverService;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.cassandra.dataaccess.DataAccessService;
import org.wso2.carbon.identity.authentication.AuthenticationService;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class BAMReceiverServiceComponent {
    private static Log log = LogFactory.getLog(BAMReceiverServiceComponent.class);
    private static HttpService httpServiceInstance;
    private AuthenticationService authenticationService;
    private ExecutorService executor = Executors.newFixedThreadPool(2);

    protected void activate(ComponentContext ctx) {
        try {
            ReceiverUtils.setQueue(new EventQueue());
            if (log.isDebugEnabled()) {
                log.debug((Object)"BAM Core bundle is activated");
            }
            ThriftAuthenticator.getInstance().init(this.authenticationService);
            ReceiverService.Processor processor = new ReceiverService.Processor((ReceiverService.Iface)new ReceiverServiceImpl());
            TCompactProtocol.Factory inProtFactory = new TCompactProtocol.Factory();
            TCompactProtocol.Factory outProtFactory = new TCompactProtocol.Factory();
            httpServiceInstance.registerServlet("/thriftReceiver", (Servlet)new ReceiverServlet((TProcessor)processor, (TProtocolFactory)inProtFactory, (TProtocolFactory)outProtFactory), new Hashtable(), httpServiceInstance.createDefaultHttpContext());
            AuthenticatorService.Processor authProcessor = new AuthenticatorService.Processor((AuthenticatorService.Iface)new AuthenticatorServiceImpl());
            httpServiceInstance.registerServlet("/thriftAuthenticator", (Servlet)new AuthenticatorServlet((TProcessor)authProcessor, (TProtocolFactory)inProtFactory, (TProtocolFactory)outProtFactory), new Hashtable(), httpServiceInstance.createDefaultHttpContext());
            this.startThriftServices();
        }
        catch (Throwable e) {
            log.fatal((Object)"Unable to start receiver..", e);
        }
    }

    private void startThriftServices() {
        int receiverPort = this.getReceiverPort();
        this.startThriftReceiverService(receiverPort);
    }

    private int getReceiverPort() {
        int port = this.readReceiverPortFromConfig();
        int offset = this.getPortOffset();
        return port + offset;
    }

    private int getPortOffset() {
        String portOffset = ReceiverUtils.getCarbonConfiguration().getFirstProperty("Ports.Offset");
        try {
            return portOffset != null ? Integer.parseInt(portOffset.trim()) : 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int readReceiverPortFromConfig() {
        int port = 7620;
        String bamConfig = CarbonUtils.getCarbonConfigDirPath() + "/" + "bam.xml";
        try {
            OMElement root = new StAXOMBuilder((InputStream)new FileInputStream(bamConfig)).getDocumentElement();
            OMElement portElement = root.getFirstChildWithName(new QName("receiverServicePort"));
            String portStr = portElement.getText();
            try {
                if (portStr != null) {
                    port = Integer.parseInt(portStr);
                }
            }
            catch (Exception ignored) {}
        }
        catch (FileNotFoundException e) {
            log.error((Object)(bamConfig + " not found. Using default receiver port : " + port));
        }
        catch (XMLStreamException e) {
            log.error((Object)("Invalid configuration for receiver port in " + bamConfig + ". Using default " + "receiver port : " + port));
        }
        return port;
    }

    private void startThriftReceiverService(int receiverPort) {
        try {
            TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(receiverPort);
            ReceiverService.Processor processor = new ReceiverService.Processor((ReceiverService.Iface)new ReceiverServiceImpl());
            THsHaServer server = new THsHaServer((TProcessor)processor, (TNonblockingServerTransport)serverTransport, (TProtocolFactory)new TCompactProtocol.Factory());
            ServerRunnable serRunnable = new ServerRunnable((TServer)server);
            this.executor.submit(serRunnable);
            log.info((Object)("Started Thrift receiver service at port : " + receiverPort));
        }
        catch (TTransportException e) {
            log.error((Object)("Unable to start Thrift receiver service at port : " + receiverPort));
        }
    }

    protected void deactivate(ComponentContext ctx) {
        ReceiverUtils.setQueue(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"BAM Core bundle is deactivated");
        }
    }

    protected void setDataAccessService(DataAccessService dataAccessService) {
        ReceiverUtils.setDataAccessService(dataAccessService);
    }

    protected void unsetDataAccessService(DataAccessService dataAccessService) {
        ReceiverUtils.setDataAccessService(null);
    }

    protected void setRegistryService(RegistryService registryService) throws RegistryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in BAM bundle");
        }
        ReceiverUtils.setRegistry((Registry)registryService.getConfigSystemRegistry());
    }

    protected void unsetRegistryService(RegistryService registryService) {
        ReceiverUtils.setRegistry(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in BAM bundle");
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService ccService) {
        ReceiverUtils.setConfigurationContextService(ccService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService set in BAM bundle");
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService ccService) {
        ReceiverUtils.setConfigurationContextService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService unset in BAM bundle");
        }
    }

    protected void setRealmService(RealmService realmService) {
        ReceiverUtils.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        ReceiverUtils.setRealmService(null);
    }

    protected void setServerConfiguration(ServerConfiguration serverConfiguration) {
        ReceiverUtils.setCarbonConfiguration(serverConfiguration);
    }

    protected void unsetServerConfiguration(ServerConfiguration serverConfiguration) {
        ReceiverUtils.setCarbonConfiguration(null);
    }

    protected void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void unsetAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = null;
    }

    protected void setHttpService(HttpService httpService) {
        httpServiceInstance = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        httpServiceInstance = null;
    }

    private class ServerRunnable
    implements Runnable {
        private TServer server;

        public ServerRunnable(TServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.serve();
        }
    }
}

