/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.receiver.authentication;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.receiver.authentication.ThriftSession;
import org.wso2.carbon.bam.service.AuthenticationException;
import org.wso2.carbon.identity.authentication.AuthenticationService;

public class ThriftAuthenticator {
    private static final Log log = LogFactory.getLog(ThriftAuthenticator.class);
    private static ThriftAuthenticator instance = new ThriftAuthenticator();
    private ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
    private AuthenticationService authenticationService;
    private Map<String, ThriftSession> authenticatedSessions = new ConcurrentHashMap<String, ThriftSession>();

    private ThriftAuthenticator() {
    }

    public static ThriftAuthenticator getInstance() {
        return instance;
    }

    public void init(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public String authenticate(String userName, String password) throws AuthenticationException {
        boolean isSuccessful;
        String domainName;
        if (userName == null) {
            this.logAndAuthenticationException("Authentication request was missing the user name ");
        }
        if (userName.indexOf("@") > 0 && ((domainName = userName.substring(userName.indexOf("@") + 1)) == null || domainName.trim().equals(""))) {
            this.logAndAuthenticationException("Authentication request was missing the domain name of the user");
        }
        if (password == null) {
            this.logAndAuthenticationException("Authentication request was missing the required password");
        }
        if (isSuccessful = this.authenticationService.authenticate(userName, password)) {
            String sessionId = UUID.randomUUID().toString();
            ThriftSession session = new ThriftSession();
            session.setSessionId(sessionId);
            session.setUserName(userName);
            session.setPassword(password);
            session.setCreatedAt(System.currentTimeMillis());
            this.authenticatedSessions.put(sessionId, session);
            return sessionId;
        }
        return null;
    }

    public boolean isAuthenticated(String sessionId) {
        if (sessionId == null) {
            return false;
        }
        return this.authenticatedSessions.containsKey(sessionId);
    }

    public ThriftSession getSessionInfo(String sessionId) {
        return this.authenticatedSessions.get(sessionId);
    }

    private void logAndAuthenticationException(String msg) throws AuthenticationException {
        log.error((Object)msg);
        throw new AuthenticationException(msg);
    }

    private class SessionInvalidator
    implements Runnable {
        private SessionInvalidator() {
        }

        @Override
        public void run() {
        }
    }
}

