/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.presentation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.configurations.TableConfiguration;
import org.wso2.carbon.bam.core.dataobjects.Record;
import org.wso2.carbon.bam.core.persistence.MetaDataManager;
import org.wso2.carbon.bam.core.persistence.QueryIndex;
import org.wso2.carbon.bam.core.persistence.QueryManager;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;
import org.wso2.carbon.bam.core.utils.Utils;
import org.wso2.carbon.bam.presentation.CompositeIndex;
import org.wso2.carbon.bam.presentation.QueryException;
import org.wso2.carbon.context.CarbonContext;

public class QueryService {
    private static final Log log = LogFactory.getLog(QueryService.class);
    private static final String ROWS = "rows";
    private static final String ROW = "row";

    public OMElement queryColumnFamily(String table, String indexName, CompositeIndex[] indexes) throws StoreException {
        QueryIndex index = null;
        if (indexName != null && !indexName.trim().equals("")) {
            index = new QueryIndex(indexName);
            if (indexes != null) {
                for (CompositeIndex compositeIndex : indexes) {
                    index.addCompositeRange(compositeIndex.getIndexName(), compositeIndex.getRangeFirst(), compositeIndex.getRangeLast());
                }
            }
        }
        QueryManager queryManager = new QueryManager();
        List records = null;
        try {
            records = queryManager.getRecords(this.getCredentials(), table, index, null);
        }
        catch (ConfigurationException e) {
            throw new StoreException("Unable to fetch credentials..", (Throwable)e);
        }
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement rowsEl = fac.createOMElement(new QName(ROWS));
        if (records != null) {
            for (Record record : records) {
                OMElement keyEl = fac.createOMElement(new QName(ROW));
                Map columns = record.getColumns();
                if (columns != null) {
                    for (Map.Entry entry : columns.entrySet()) {
                        OMElement key = fac.createOMElement(new QName((String)entry.getKey()));
                        OMText value = fac.createOMText((String)entry.getValue());
                        key.addChild((OMNode)value);
                        keyEl.addChild((OMNode)key);
                    }
                }
                rowsEl.addChild((OMNode)keyEl);
            }
        }
        return rowsEl;
    }

    public String[] getAllColumnFamilies() throws ConfigurationException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        MetaDataManager manager = MetaDataManager.getInstance();
        List tableConfigurations = manager.getAllTableMetaData(Utils.getConnectionParameters((int)tenantId));
        ArrayList<String> tables = new ArrayList<String>();
        for (TableConfiguration tableConfiguration : tableConfigurations) {
            tables.add(tableConfiguration.getTableName());
        }
        return tables.toArray(new String[0]);
    }

    public String[] getIndexes(String cfName) throws ConfigurationException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        MetaDataManager manager = MetaDataManager.getInstance();
        List configurations = manager.getIndexMetaDataOfTable(this.getCredentials(), cfName);
        ArrayList<String> indexes = new ArrayList<String>();
        for (IndexConfiguration configuration : configurations) {
            indexes.add(configuration.getIndexName());
        }
        return indexes.toArray(new String[0]);
    }

    public String[] getAllIndexValues(String cfName, String indexName) throws QueryException {
        return null;
    }

    private Map<String, String> getCredentials() throws ConfigurationException {
        return Utils.getConnectionParameters();
    }
}

