/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.service.server;

import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.bam.service.ReceiverService;

public class ReceiverServer {
    public static void start(ReceiverService.Iface service) {
        ThriftServerThread serverThread = new ThriftServerThread(service);
        serverThread.start();
    }

    private static class ThriftServerThread
    extends Thread {
        ReceiverService.Iface service;

        public ThriftServerThread(ReceiverService.Iface service) {
            this.service = service;
        }

        @Override
        public void run() {
            this.startThriftServer();
        }

        private void startThriftServer() {
            try {
                TServerSocket serverTransport = new TServerSocket(7911);
                ReceiverService.Processor processor = new ReceiverService.Processor(this.service);
                TBinaryProtocol.Factory protFactory = new TBinaryProtocol.Factory(true, true);
                TThreadPoolServer server = new TThreadPoolServer((TProcessor)processor, (TServerTransport)serverTransport, (TProtocolFactory)protFactory);
                System.out.println("Starting server on port 7911 ...");
                server.serve();
            }
            catch (TTransportException e) {
                e.printStackTrace();
            }
        }
    }
}

