/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.internal.ServiceHolder;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    public static int getTenantIdFromUserName(String userName) throws StoreException {
        int tenantId;
        String domain = MultitenantUtils.getTenantDomain((String)userName);
        try {
            tenantId = ServiceHolder.getRealmService().getTenantManager().getTenantId(domain);
        }
        catch (UserStoreException e) {
            throw new StoreException("Unable to get tenant information from user name '" + userName + "'..", e);
        }
        return tenantId;
    }

    public static boolean credentialsValid(Map<String, String> credentials) {
        if (credentials == null) {
            return false;
        }
        if (credentials.size() < 2) {
            return false;
        }
        for (Map.Entry<String, String> entry : credentials.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || value == null) {
                return false;
            }
            if (key.equals("username") || key.equals("password")) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> getConnectionParameters() throws ConfigurationException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        return Utils.getConnectionParameters(tenantId);
    }

    public static Map<String, String> getConnectionParameters(int tenantId) throws ConfigurationException {
        String password;
        String username;
        try {
            Resource connectionResource;
            UserRegistry configSystemRegistry = ServiceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
            String connectionResourcePath = "/components/org.wso2.carbon.bam.core/connection";
            if (configSystemRegistry.resourceExists(connectionResourcePath)) {
                connectionResource = configSystemRegistry.get(connectionResourcePath);
            } else {
                connectionResource = configSystemRegistry.newResource();
                configSystemRegistry.put(connectionResourcePath, connectionResource);
                connectionResource = configSystemRegistry.get(connectionResourcePath);
            }
            username = connectionResource.getProperty("Username");
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            try {
                String cipherTextPassword = connectionResource.getProperty("Password");
                if (cipherTextPassword != null) {
                    byte[] passwordBytes = cryptoUtil.base64DecodeAndDecrypt(cipherTextPassword);
                    password = new String(passwordBytes);
                } else {
                    password = null;
                }
            }
            catch (CryptoException e) {
                throw new ConfigurationException("Failed to fetch connection parameters ", e);
            }
        }
        catch (RegistryException e) {
            String message = "Failed to fetch connection parameters for tenant : " + tenantId;
            log.error((Object)message, (Throwable)e);
            throw new ConfigurationException(message);
        }
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", username);
        credentials.put("password", password);
        return credentials;
    }
}

