/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.bam.core.configurations.Granularity;

public class TimeStampFactory {
    private static TimeStampFactory instance = null;
    private Map<String, Integer[]> granularityMap = new HashMap<String, Integer[]>();

    private TimeStampFactory() {
        this.populateGranularityMap();
    }

    public static synchronized TimeStampFactory getFactory() {
        if (instance == null) {
            instance = new TimeStampFactory();
        }
        return instance;
    }

    private void populateGranularityMap() {
        this.granularityMap.put("year", new Integer[]{12, 13, 11, 5, 2});
        this.granularityMap.put("month", new Integer[]{12, 13, 11, 5});
        this.granularityMap.put("day", new Integer[]{12, 13, 11});
        this.granularityMap.put("hour", new Integer[]{12, 13});
        this.granularityMap.put("minute", new Integer[]{13});
        this.granularityMap.put("none", new Integer[]{0});
    }

    public String getTimeStamp(String eventTimeStamp, Granularity granularity) throws IllegalArgumentException, ParseException {
        Integer[] deltaFactors;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!this.granularityMap.containsKey(granularity.getName())) {
            throw new IllegalArgumentException("Invalid granularity value - " + granularity.getName());
        }
        Date date = formatter.parse(eventTimeStamp);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        for (Integer deltaFactor : deltaFactors = this.granularityMap.get(granularity.getName())) {
            calendar.add(deltaFactor, calendar.get(deltaFactor) * -1);
        }
        return formatter.format(calendar.getTime());
    }
}

