/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.service;

import org.wso2.carbon.bam.core.internal.ServiceHolder;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.service.ConnectionDTO;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ConnectionMgtService
extends AbstractAdmin {
    public boolean configureConnectionParameters(String userName, String password) throws ConfigurationException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        try {
            Resource connectionResource;
            UserRegistry configSystemRegistry = ServiceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
            String connectionResourcePath = "/components/org.wso2.carbon.bam.core/connection";
            if (configSystemRegistry.resourceExists(connectionResourcePath)) {
                connectionResource = configSystemRegistry.get(connectionResourcePath);
            } else {
                connectionResource = configSystemRegistry.newResource();
                configSystemRegistry.put(connectionResourcePath, connectionResource);
                connectionResource = configSystemRegistry.get(connectionResourcePath);
            }
            connectionResource.setProperty("Username", userName);
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            try {
                String cipherTextPassword = cryptoUtil.encryptAndBase64Encode(password.getBytes());
                connectionResource.setProperty("Password", cipherTextPassword);
            }
            catch (CryptoException e) {
                throw new ConfigurationException("Failed to store connection parameters ", e);
            }
            configSystemRegistry.put(connectionResourcePath, connectionResource);
        }
        catch (RegistryException e) {
            throw new ConfigurationException("Failed to store connection parameters for tenant : " + tenantId);
        }
        return true;
    }

    public ConnectionDTO getConnectionParameters() throws ConfigurationException {
        String password;
        String username;
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        try {
            Resource connectionResource;
            UserRegistry configSystemRegistry = ServiceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
            String connectionResourcePath = "/components/org.wso2.carbon.bam.core/connection";
            if (configSystemRegistry.resourceExists(connectionResourcePath)) {
                connectionResource = configSystemRegistry.get(connectionResourcePath);
            } else {
                connectionResource = configSystemRegistry.newResource();
                configSystemRegistry.put(connectionResourcePath, connectionResource);
                connectionResource = configSystemRegistry.get(connectionResourcePath);
            }
            username = connectionResource.getProperty("Username");
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            try {
                String cipherTextPassword = connectionResource.getProperty("Password");
                if (cipherTextPassword != null) {
                    byte[] passwordBytes = cryptoUtil.base64DecodeAndDecrypt(cipherTextPassword);
                    password = new String(passwordBytes);
                } else {
                    password = null;
                }
            }
            catch (CryptoException e) {
                throw new ConfigurationException("Failed to fetch connection parameters ", e);
            }
        }
        catch (RegistryException e) {
            String message = "Failed to fetch connection parameters for tenant : " + tenantId;
            throw new ConfigurationException(message);
        }
        return new ConnectionDTO(username, password);
    }
}

