/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.persistence.cassandra;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.dataaccess.ClusterConfiguration;
import org.wso2.carbon.cassandra.dataaccess.ClusterConfigurationFactory;
import org.wso2.carbon.cassandra.dataaccess.ClusterInformation;
import org.wso2.carbon.cassandra.dataaccess.DataAccessComponentException;

public class CassandraUtils {
    private static final Log log = LogFactory.getLog(CassandraUtils.class);
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private static final String DEFAULT_HOST = "localhost:9160";
    private static final String LOCAL_HOST_NAME = "localhost";
    private static final String CASSANDRA_COMPONENT_CONF = "/repository/conf/advanced/cassandra-component.xml";

    public static Cluster createCluster(ClusterInformation clusterInformation) {
        String username = clusterInformation.getUsername();
        String clusterName = clusterInformation.getClusterName();
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put(USERNAME_KEY, username);
        credentials.put(PASSWORD_KEY, clusterInformation.getPassword());
        CassandraHostConfigurator configurator = clusterInformation.getCassandraHostConfigurator();
        if (configurator == null) {
            configurator = CassandraUtils.createCassandraHostConfigurator();
        }
        return HFactory.createCluster((String)clusterName, (CassandraHostConfigurator)configurator, credentials);
    }

    private static CassandraHostConfigurator createCassandraHostConfigurator() {
        ClusterConfiguration configuration = ClusterConfigurationFactory.create((OMElement)CassandraUtils.loadConfigXML());
        String carbonCassandraRPCPort = null;
        carbonCassandraRPCPort = System.getProperty("cassandra.rpcport");
        String cassandraHosts = null;
        int cassandraDefaultPort = 0;
        if (carbonCassandraRPCPort != null) {
            cassandraHosts = "localhost:" + carbonCassandraRPCPort;
            cassandraDefaultPort = Integer.parseInt(carbonCassandraRPCPort);
        } else {
            cassandraHosts = configuration.getNodesString();
        }
        if (cassandraHosts == null || "".equals(cassandraHosts)) {
            cassandraHosts = DEFAULT_HOST;
        }
        CassandraHostConfigurator configurator = new CassandraHostConfigurator(cassandraHosts);
        configurator.setAutoDiscoverHosts(configuration.isAutoDiscovery());
        configurator.setAutoDiscoveryDelayInSeconds(configuration.getAutoDiscoveryDelay());
        if (cassandraDefaultPort > 0 && cassandraDefaultPort < 65536) {
            configurator.setPort(cassandraDefaultPort);
        } else {
            configurator.setPort(configuration.getDefaultPort());
        }
        return configurator;
    }

    private static OMElement loadConfigXML() {
        String carbonHome = System.getProperty("carbon.home");
        String path = carbonHome + CASSANDRA_COMPONENT_CONF;
        BufferedInputStream inputStream = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                log.info((Object)"There is no /repository/conf/advanced/cassandra-component.xml. Using the default configuration");
                inputStream = new BufferedInputStream(new ByteArrayInputStream("<Cassandra/>".getBytes()));
            } else {
                inputStream = new BufferedInputStream(new FileInputStream(file));
            }
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement oMElement = builder.getDocumentElement();
            return oMElement;
        }
        catch (FileNotFoundException e) {
            throw new DataAccessComponentException("/repository/conf/advanced/cassandra-component.xmlcannot be found in the path : " + path, (Throwable)e, log);
        }
        catch (XMLStreamException e) {
            throw new DataAccessComponentException("Invalid XML for /repository/conf/advanced/cassandra-component.xml located in the path : " + path, (Throwable)e, log);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ingored) {}
        }
    }
}

