/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.persistence.cassandra;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.beans.Rows;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.MultigetSliceQuery;
import me.prettyprint.hector.api.query.QueryResult;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.dataobjects.Cursor;
import org.wso2.carbon.bam.core.dataobjects.Record;
import org.wso2.carbon.bam.core.persistence.MetaDataManager;
import org.wso2.carbon.bam.core.persistence.QueryIndex;
import org.wso2.carbon.bam.core.persistence.StoreFetcher;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraCFConfiguration;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraDataStore;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraIndexConfiguration;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraStoreFactory;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraUtils;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;
import org.wso2.carbon.bam.core.utils.Utils;
import org.wso2.carbon.cassandra.dataaccess.ClusterInformation;

public class CassandraStoreFetcher
implements StoreFetcher {
    private static final int RANGE_FIRST_INDEX = 0;
    private static final int RANGE_LAST_INDEX = 1;
    private Keyspace keyspace;
    private int tenantId;
    private Map<String, String> credentials;
    private static StringSerializer stringSerializer = StringSerializer.get();
    CassandraDataStore store = null;

    @Override
    public void initialize(Map<String, String> credentials) throws StoreException {
        this.credentials = credentials;
        String userName = credentials.get("username");
        String password = credentials.get("password");
        ClusterInformation clusterInfo = new ClusterInformation(userName, password);
        clusterInfo.setClusterName(userName);
        Cluster cluster = CassandraUtils.createCluster(clusterInfo);
        this.store = (CassandraDataStore)CassandraStoreFactory.getInstance().getDataStore(credentials);
        this.keyspace = this.store.getKeySpace();
        this.tenantId = Utils.getTenantIdFromUserName("username");
    }

    @Override
    public List<String> fetchIndexValues(String indexName) {
        return null;
    }

    @Override
    public List<String> fetchTableColumns(String cfName) {
        return null;
    }

    @Override
    public List<Record> fetchRecords(String cfName, String rowKey, List<String> filterByColumns) throws StoreException {
        CassandraCFConfiguration configuration;
        try {
            configuration = (CassandraCFConfiguration)MetaDataManager.getInstance().getTableMetaData(this.tenantId, cfName);
        }
        catch (ConfigurationException e) {
            throw new StoreException("Unable to fetch column family meta data..", e);
        }
        ArrayList<Record> result = new ArrayList<Record>();
        List<HColumn<String, String>> columns = this.getColumnsOfRow(cfName, rowKey, "", "", Integer.MAX_VALUE);
        if (configuration.isPrimaryTable() && configuration.getSecondaryTables() != null && configuration.getSecondaryTables().size() > 0) {
            for (HColumn<String, String> column : columns) {
                String secondaryCfRecordKey = (String)column.getName();
                List<String> secondaryCfs = configuration.getSecondaryTables();
                ArrayList<String> clonedSecondaryCfs = new ArrayList<String>();
                for (String secondaryCf : secondaryCfs) {
                    clonedSecondaryCfs.add(secondaryCf);
                }
                String firstSecondaryCf = (String)clonedSecondaryCfs.get(0);
                List<Record> secondaryCfRecords = this.fetchRecords(firstSecondaryCf, secondaryCfRecordKey, filterByColumns);
                ArrayList<Record> secondaryRecords = new ArrayList<Record>();
                if (secondaryCfRecords != null && secondaryCfRecords.size() > 0) {
                    Record secondaryRecord = secondaryCfRecords.get(0);
                    Map secondaryCfColumns = secondaryRecord.getColumns();
                    clonedSecondaryCfs.remove(0);
                    for (String secondaryCf : clonedSecondaryCfs) {
                        List<Record> records = this.fetchRecords(secondaryCf, secondaryCfRecordKey, filterByColumns);
                        if (records == null || records.size() <= 0) continue;
                        secondaryCfColumns.putAll(records.get(0).getColumns());
                    }
                    secondaryRecords.add(secondaryRecord);
                }
                result.addAll(secondaryRecords);
            }
        } else {
            HashMap<Object, Object> columnsMap = new HashMap<Object, Object>();
            for (HColumn<String, String> column : columns) {
                if (filterByColumns != null && filterByColumns.contains(column.getName())) {
                    columnsMap.put(column.getName(), column.getValue());
                    continue;
                }
                if (filterByColumns != null) continue;
                columnsMap.put(column.getName(), column.getValue());
            }
            result.add(new Record(rowKey, columnsMap));
        }
        return result;
    }

    @Override
    public List<Record> fetchRecords(String cfName, QueryIndex index, List<String> filterByColumns) throws StoreException {
        IndexConfiguration indexConfiguration;
        ArrayList<Record> result = new ArrayList<Record>();
        if (index == null) {
            List<HColumn<String, String>> rowIndexColumns = this.getColumnsOfRow(cfName, "ROW_INDEX", "", "", Integer.MAX_VALUE);
            for (HColumn<String, String> rowIndexColumn : rowIndexColumns) {
                String rowKey = (String)rowIndexColumn.getName();
                List<Record> rows = this.fetchRecords(cfName, rowKey, filterByColumns);
                result.addAll(rows);
            }
            return result;
        }
        String indexName = index.getIndexName();
        try {
            indexConfiguration = MetaDataManager.getInstance().getIndexMetaData(this.credentials, indexName);
        }
        catch (ConfigurationException e) {
            throw new StoreException("Unable to fetch index meta data..", e);
        }
        if (indexConfiguration == null) {
            throw new StoreException("Index not found for index name " + indexName + "..");
        }
        if (!(indexConfiguration instanceof CassandraIndexConfiguration)) {
            throw new StoreException("Invalid index type. Expected Cassandra index..");
        }
        CassandraIndexConfiguration cassandraIndexConfiguration = (CassandraIndexConfiguration)indexConfiguration;
        String indexingCf = cassandraIndexConfiguration.getIndexingColumnFamily();
        List<String> ranges = this.getIndexRanges(index, indexConfiguration);
        List<HColumn<String, String>> rowIndexColumns = this.getColumnsOfRow(indexingCf, "ROW_INDEX", ranges.get(0), ranges.get(1), Integer.MAX_VALUE);
        for (HColumn<String, String> rowIndexColumn : rowIndexColumns) {
            String rowKey = (String)rowIndexColumn.getName();
            List<Record> rows = this.fetchRecords(indexingCf, rowKey, filterByColumns);
            result.addAll(rows);
        }
        return result;
    }

    @Override
    public List<Record> fetchRecords(String cfName, QueryIndex index, List<String> filterByColumns, int batchSize, Cursor cursor) throws StoreException {
        Cursor lastCursor;
        IndexConfiguration indexConfiguration;
        ArrayList<Record> result = new ArrayList<Record>();
        if (index == null) {
            Cursor lastCursor2;
            MetaDataManager manager = MetaDataManager.getInstance();
            try {
                lastCursor2 = manager.getCursorMetaData(this.credentials, cfName, cursor.getCursorName());
            }
            catch (ConfigurationException e) {
                throw new StoreException("Unable to fetch cursor meta data..", e);
            }
            String resumePoint = null;
            if (lastCursor2 != null) {
                resumePoint = lastCursor2.getResumePoint();
            }
            List<HColumn<String, String>> timeStampIndexColumns = this.getColumnsOfRow(cfName, "TIMESTAMP_INDEX", resumePoint, "", batchSize);
            for (HColumn<String, String> timeStampIndexColumn : timeStampIndexColumns) {
                String rowKey = (String)timeStampIndexColumn.getValue();
                List<Record> rows = this.fetchRecords(cfName, rowKey, filterByColumns);
                result.addAll(rows);
            }
            if (timeStampIndexColumns.size() > 0) {
                HColumn<String, String> lastTimeStampIndex = timeStampIndexColumns.get(timeStampIndexColumns.size() - 1);
                String nextResumePoint = (String)lastTimeStampIndex.getName();
                cursor.setTable(cfName);
                cursor.setResumePoint(this.getNextStringInLexicalOrder(nextResumePoint));
            }
            return result;
        }
        String indexName = index.getIndexName();
        try {
            indexConfiguration = MetaDataManager.getInstance().getIndexMetaData(this.credentials, indexName);
        }
        catch (ConfigurationException e) {
            throw new StoreException("Unable to fetch index meta data..", e);
        }
        if (indexConfiguration == null) {
            throw new StoreException("Index not found for index name " + indexName + "..");
        }
        if (!(indexConfiguration instanceof CassandraIndexConfiguration)) {
            throw new StoreException("Invalid index type. Expected Cassandra index..");
        }
        CassandraIndexConfiguration cassandraIndexConfiguration = (CassandraIndexConfiguration)indexConfiguration;
        String indexingCf = cassandraIndexConfiguration.getIndexingColumnFamily();
        List<String> ranges = this.getIndexRanges(index, indexConfiguration);
        MetaDataManager manager = MetaDataManager.getInstance();
        try {
            lastCursor = manager.getCursorMetaData(this.credentials, indexingCf, cursor.getCursorName());
        }
        catch (ConfigurationException e) {
            throw new StoreException("Unable to fetch cursor meta data..", e);
        }
        String resumePoint = null;
        if (lastCursor != null) {
            resumePoint = lastCursor.getResumePoint();
        }
        if (resumePoint == null) {
            resumePoint = "";
        }
        List<HColumn<String, String>> timeStampIndexColumns = this.getColumnsOfRow(indexingCf, "TIMESTAMP_INDEX", resumePoint, "", batchSize);
        String rangeFirst = ranges.get(0);
        String rangeLast = ranges.get(1);
        for (HColumn<String, String> timeStampIndexColumn : timeStampIndexColumns) {
            List<Record> rows;
            String rowKey = (String)timeStampIndexColumn.getValue();
            if (rowKey.compareTo(rangeFirst) >= 0 && rowKey.compareTo(rangeLast) < 0) {
                rows = this.fetchRecords(indexingCf, rowKey, filterByColumns);
                result.addAll(rows);
                continue;
            }
            if (!"".equals(rangeFirst) || !"".equals(rangeLast)) continue;
            rows = this.fetchRecords(indexingCf, rowKey, filterByColumns);
            result.addAll(rows);
        }
        if (timeStampIndexColumns.size() > 0) {
            HColumn<String, String> lastTimeStampIndex = timeStampIndexColumns.get(timeStampIndexColumns.size() - 1);
            String nextResumePoint = (String)lastTimeStampIndex.getName();
            cursor.setTable(indexingCf);
            cursor.setResumePoint(this.getNextStringInLexicalOrder(nextResumePoint));
            try {
                manager.storeCursorMetaData(this.credentials, cursor);
            }
            catch (ConfigurationException e) {
                throw new StoreException("Unable to persist cursor meta data..", e);
            }
        }
        return result;
    }

    @Override
    public DataSourceType getDataSourceType() {
        return DataSourceType.CASSANDRA;
    }

    private List<HColumn<String, String>> getColumnsOfRow(String cfName, String rowKey, String rangeFirst, String rangeLast, int batchSize) {
        if (this.store.isTableExists(cfName)) {
            MultigetSliceQuery multigetSliceQuery = HFactory.createMultigetSliceQuery((Keyspace)this.keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
            multigetSliceQuery.setColumnFamily(cfName);
            multigetSliceQuery.setKeys((Object[])new String[]{rowKey});
            multigetSliceQuery.setRange((Object)rangeFirst, (Object)rangeLast, false, batchSize);
            QueryResult result = multigetSliceQuery.execute();
            Row indexRow = ((Rows)result.get()).getByKey((Object)rowKey);
            List list = indexRow.getColumnSlice().getColumns();
            return list;
        }
        return null;
    }

    private List<String> getIndexRanges(QueryIndex index, IndexConfiguration configuration) throws StoreException {
        String rangeLastStr;
        String rangeFirstStr;
        if (index == null) {
            return this.getDefaultRanges();
        }
        String[] indexedColumns = configuration.getIndexedColumns();
        Map<String, List<String>> indexRanges = index.getCompositeRanges();
        if (indexRanges == null) {
            return this.getDefaultRanges();
        }
        int compositeColumnsInQuery = indexRanges.size();
        StringBuilder rangeFirst = new StringBuilder("");
        StringBuilder rangeLast = new StringBuilder("");
        for (String indexedColumn : indexedColumns) {
            if (compositeColumnsInQuery <= 0) break;
            List<String> rangesForIndex = indexRanges.get(indexedColumn);
            if (rangesForIndex == null && compositeColumnsInQuery > 0) {
                throw new StoreException("Unable to find column " + indexedColumn + " in defined composite index");
            }
            if (rangesForIndex == null) {
                return null;
            }
            if (rangesForIndex.size() == 2 || rangesForIndex.get(0) != null || rangesForIndex.get(1) != null) {
                rangeFirst.append(rangesForIndex.get(0));
                rangeFirst.append("---");
                rangeLast.append(rangesForIndex.get(1));
                rangeLast.append("---");
            }
            --compositeColumnsInQuery;
        }
        if (!"".equals(rangeFirstStr = rangeFirst.toString())) {
            rangeFirstStr = rangeFirstStr.substring(0, rangeFirstStr.lastIndexOf("---"));
        }
        if (!"".equals(rangeLastStr = rangeLast.toString())) {
            rangeLastStr = rangeLastStr.substring(0, rangeLastStr.lastIndexOf("---"));
        }
        ArrayList<String> ranges = new ArrayList<String>();
        ranges.add(rangeFirstStr);
        ranges.add(rangeLastStr);
        return ranges;
    }

    private List<String> getDefaultRanges() {
        ArrayList<String> ranges = new ArrayList<String>();
        ranges.add("");
        ranges.add("");
        return ranges;
    }

    public String getNextStringInLexicalOrder(String str) {
        if (str == null || str.equals("")) {
            return str;
        }
        byte[] bytes = str.getBytes();
        byte last = bytes[bytes.length - 1];
        bytes[bytes.length - 1] = last = (byte)(last + 1);
        return new String(bytes);
    }
}

