/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.persistence.cassandra;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.persistence.DataStore;
import org.wso2.carbon.bam.core.persistence.StoreFactory;
import org.wso2.carbon.bam.core.persistence.StoreFetcher;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraDataStore;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraStoreFetcher;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;
import org.wso2.carbon.bam.core.utils.Utils;

public class CassandraStoreFactory
implements StoreFactory {
    private static CassandraStoreFactory instance = new CassandraStoreFactory();
    private Map<Integer, List<DataStore>> dataStorePool = new HashMap<Integer, List<DataStore>>();
    private Map<Integer, List<StoreFetcher>> storeFetcherPool = new HashMap<Integer, List<StoreFetcher>>();

    private CassandraStoreFactory() {
    }

    public static StoreFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getDataStore(Map<String, String> credentials) throws StoreException {
        CassandraDataStore store;
        int tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        List<DataStore> tenantStores = this.dataStorePool.get(tenantId);
        if (tenantStores != null) {
            for (DataStore store2 : tenantStores) {
                if (!store2.getDataSourceType().equals((Object)DataSourceType.CASSANDRA)) continue;
                return store2;
            }
        }
        CassandraStoreFactory cassandraStoreFactory = this;
        synchronized (cassandraStoreFactory) {
            tenantStores = this.dataStorePool.get(tenantId);
            if (tenantStores != null) {
                for (DataStore tenantStore : tenantStores) {
                    if (!tenantStore.getDataSourceType().equals((Object)DataSourceType.CASSANDRA)) continue;
                    return tenantStore;
                }
            } else {
                tenantStores = new ArrayList<DataStore>();
            }
            store = new CassandraDataStore();
            store.initialize(credentials);
            tenantStores.add(store);
            this.dataStorePool.put(tenantId, tenantStores);
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreFetcher getStoreFetcher(Map<String, String> credentials) throws StoreException {
        int tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        List<StoreFetcher> storeFetchers = this.storeFetcherPool.get(tenantId);
        if (storeFetchers != null) {
            for (StoreFetcher storeFetcher : storeFetchers) {
                if (!storeFetcher.getDataSourceType().equals((Object)DataSourceType.CASSANDRA)) continue;
                return storeFetcher;
            }
        }
        CassandraStoreFetcher fetcher = null;
        CassandraStoreFactory cassandraStoreFactory = this;
        synchronized (cassandraStoreFactory) {
            storeFetchers = this.storeFetcherPool.get(tenantId);
            if (storeFetchers != null) {
                for (StoreFetcher storeFetcher : storeFetchers) {
                    if (!storeFetcher.getDataSourceType().equals((Object)DataSourceType.CASSANDRA)) continue;
                    return storeFetcher;
                }
            } else {
                storeFetchers = new ArrayList<StoreFetcher>();
                fetcher = new CassandraStoreFetcher();
                fetcher.initialize(credentials);
                storeFetchers.add(fetcher);
                this.storeFetcherPool.put(tenantId, storeFetchers);
            }
        }
        return fetcher;
    }
}

