/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.persistence.cassandra;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.configurations.AbstractMetaDataPersistor;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.Granularity;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.configurations.TableConfiguration;
import org.wso2.carbon.bam.core.dataobjects.Record;
import org.wso2.carbon.bam.core.persistence.PersistenceManager;
import org.wso2.carbon.bam.core.persistence.QueryIndex;
import org.wso2.carbon.bam.core.persistence.QueryManager;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraCFConfiguration;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraIndexConfiguration;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;

public class CassandraMetaDataPersistor
extends AbstractMetaDataPersistor {
    private static final Log log = LogFactory.getLog(CassandraMetaDataPersistor.class);

    @Override
    public void persistIndex(Map<String, String> credentials, IndexConfiguration configuration) throws ConfigurationException {
        CassandraIndexConfiguration cassandraIndexConfiguration = (CassandraIndexConfiguration)configuration;
        String indexName = cassandraIndexConfiguration.getIndexName();
        Record<String> record = new Record<String>(indexName, new HashMap());
        record.addColumn("name", indexName);
        record.addColumn("indexedTable", cassandraIndexConfiguration.getIndexedTable());
        record.addColumn("indexType", cassandraIndexConfiguration.getIndexType().getName());
        record.addColumn("indexingTable", cassandraIndexConfiguration.getIndexingColumnFamily());
        record.addColumn("autoGenerated", Boolean.valueOf(cassandraIndexConfiguration.isAutoGenerated()).toString());
        record.addColumn("manuallyIndexed", Boolean.valueOf(cassandraIndexConfiguration.isManuallyIndexed()).toString());
        record.addColumn("dataSourceType", cassandraIndexConfiguration.getDataSourceType().getName());
        record.addColumn("cron", cassandraIndexConfiguration.getCron());
        String[] indexedColumns = cassandraIndexConfiguration.getIndexedColumns();
        StringBuilder sb = new StringBuilder();
        for (String indexedColumn : indexedColumns) {
            sb.append(indexedColumn);
            sb.append(":");
        }
        sb.deleteCharAt(sb.length() - 1);
        record.addColumn("indexedColumns", sb.toString());
        if (cassandraIndexConfiguration.getGranularity() != null) {
            record.addColumn("granularity", cassandraIndexConfiguration.getGranularity().getName());
        }
        PersistenceManager persistenceManager = new PersistenceManager();
        try {
            persistenceManager.storeRecord(credentials, "INDEX_INFO", record);
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to store index configuration for index " + configuration.getIndexName() + "..", e);
        }
    }

    @Override
    public void persistTableMetaData(Map<String, String> credentials, TableConfiguration configuration) throws ConfigurationException {
        CassandraCFConfiguration cassandraCFConfiguration = (CassandraCFConfiguration)configuration;
        String columnFamily = cassandraCFConfiguration.getTableName();
        Record<String> record = new Record<String>(columnFamily, new HashMap());
        record.addColumn("name", columnFamily);
        record.addColumn("dataSourceType", cassandraCFConfiguration.getDataSourceType().getName());
        List<String> secondaryTables = cassandraCFConfiguration.getSecondaryTables();
        StringBuffer sb = new StringBuffer();
        if (secondaryTables != null && secondaryTables.size() > 0) {
            for (String secondaryTable : secondaryTables) {
                sb.append(secondaryTable);
                sb.append(":");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        String secondaryList = sb.toString();
        record.addColumn("secondaryColumnFamilies", secondaryList);
        record.addColumn("isPrimaryCF", Boolean.valueOf(cassandraCFConfiguration.isPrimaryTable()).toString());
        record.addColumn("autoGenerated", Boolean.valueOf(cassandraCFConfiguration.getAutoGenerated()).toString());
        List<String> columns = cassandraCFConfiguration.getColumns();
        StringBuffer columnsSb = new StringBuffer();
        if (columns != null && columns.size() > 0) {
            for (String column : columns) {
                columnsSb.append(column);
                columnsSb.append(":");
            }
            columnsSb.deleteCharAt(columnsSb.length() - 1);
        }
        String columnList = columnsSb.toString();
        record.addColumn("columns", columnList);
        PersistenceManager persistenceManager = new PersistenceManager();
        try {
            persistenceManager.storeRecord(credentials, "TABLE_INFO", record);
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to store column family configuration for column family " + configuration.getTableName() + "..", e);
        }
    }

    public static Map<String, String> getTableMetaDataAsMap(TableConfiguration configuration) {
        CassandraCFConfiguration cassandraCFConfiguration = (CassandraCFConfiguration)configuration;
        String columnFamily = cassandraCFConfiguration.getTableName();
        Record<String> record = new Record<String>(columnFamily, new HashMap());
        record.addColumn("name", columnFamily);
        record.addColumn("dataSourceType", cassandraCFConfiguration.getDataSourceType().getName());
        List<String> secondaryTables = cassandraCFConfiguration.getSecondaryTables();
        StringBuffer sb = new StringBuffer();
        if (secondaryTables != null && secondaryTables.size() > 0) {
            for (String secondaryTable : secondaryTables) {
                sb.append(secondaryTable);
                sb.append(":");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        String secondaryList = sb.toString();
        record.addColumn("secondaryColumnFamilies", secondaryList);
        record.addColumn("isPrimaryCF", Boolean.valueOf(cassandraCFConfiguration.isPrimaryTable()).toString());
        record.addColumn("autoGenerated", Boolean.valueOf(cassandraCFConfiguration.getAutoGenerated()).toString());
        List<String> columns = cassandraCFConfiguration.getColumns();
        StringBuffer columnsSb = new StringBuffer();
        if (columns != null && columns.size() > 0) {
            for (String column : columns) {
                columnsSb.append(column);
                columnsSb.append(":");
            }
            columnsSb.deleteCharAt(columnsSb.length() - 1);
        }
        String columnList = columnsSb.toString();
        record.addColumn("columns", columnList);
        return record.getColumns();
    }

    @Override
    public List<IndexConfiguration> getAllIndexMetaData(Map<String, String> credentials) throws ConfigurationException {
        QueryManager queryManager = new QueryManager();
        ArrayList<IndexConfiguration> indexConfigurations = new ArrayList<IndexConfiguration>();
        try {
            List<Record> records = queryManager.getRecords(credentials, "INDEX_INFO", (QueryIndex)null, null);
            if (records != null) {
                for (Record record : records) {
                    String indexName = record.getKey();
                    Map columns = record.getColumns();
                    if (columns == null || columns.size() <= 0) continue;
                    String indexedTable = (String)columns.get("indexedTable");
                    String indexingTable = (String)columns.get("indexingTable");
                    String granularity = (String)columns.get("granularity");
                    String columnList = (String)columns.get("indexedColumns");
                    String[] indexedColumns = columnList.split(":");
                    String isManuallyIndexed = (String)columns.get("manuallyIndexed");
                    String isAutoGenerated = (String)columns.get("autoGenerated");
                    String dataSourceTypeStr = (String)columns.get("dataSourceType");
                    String cron = (String)columns.get("cron");
                    DataSourceType dataSourceType = DataSourceType.valueOf(dataSourceTypeStr);
                    CassandraIndexConfiguration indexConfiguration = new CassandraIndexConfiguration(indexName, indexedTable, indexedColumns, dataSourceType);
                    indexConfiguration.setIndexingColumnFamily(indexingTable);
                    indexConfiguration.setAutoGenerated(Boolean.parseBoolean(isAutoGenerated));
                    indexConfiguration.setManuallyIndexed(Boolean.parseBoolean(isManuallyIndexed));
                    indexConfiguration.setCron(cron);
                    if (granularity != null) {
                        indexConfiguration.setGranularity(Granularity.valueOf(granularity.toUpperCase()));
                    }
                    indexConfigurations.add(indexConfiguration);
                }
            }
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to fetch index configurations..", e);
        }
        return indexConfigurations;
    }

    @Override
    public IndexConfiguration getIndexMetaData(Map<String, String> credentials, String indexName) throws ConfigurationException {
        QueryManager queryManager = new QueryManager();
        CassandraIndexConfiguration indexConfiguration = null;
        try {
            Record record;
            Map columns;
            List<Record> records = queryManager.getRecords(credentials, "INDEX_INFO", indexName, null);
            if (records != null && (columns = (record = records.get(0)).getColumns()) != null) {
                String indexedTable = (String)columns.get("indexedTable");
                String indexingTable = (String)columns.get("indexingTable");
                String granularity = (String)columns.get("granularity");
                String columnList = (String)columns.get("indexedColumns");
                String[] indexedColumns = columnList.split(":");
                String isManuallyIndexed = (String)columns.get("manuallyIndexed");
                String isAutoGenerated = (String)columns.get("autoGenerated");
                String dataSourceTypeStr = (String)columns.get("dataSourceType");
                String cron = (String)columns.get("cron");
                DataSourceType dataSourceType = DataSourceType.valueOf(dataSourceTypeStr);
                indexConfiguration = new CassandraIndexConfiguration(indexName, indexedTable, indexedColumns, dataSourceType);
                indexConfiguration.setIndexingColumnFamily(indexingTable);
                indexConfiguration.setAutoGenerated(Boolean.parseBoolean(isAutoGenerated));
                indexConfiguration.setManuallyIndexed(Boolean.parseBoolean(isManuallyIndexed));
                indexConfiguration.setCron(cron);
                if (granularity != null) {
                    indexConfiguration.setGranularity(Granularity.valueOf(granularity.toUpperCase()));
                }
            }
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to fetch the configuration for index " + indexName + "..", e);
        }
        return indexConfiguration;
    }

    @Override
    public List<TableConfiguration> getAllTableMetaData(Map<String, String> credentials) throws ConfigurationException {
        QueryManager queryManager = new QueryManager();
        ArrayList<TableConfiguration> cfConfigurations = new ArrayList<TableConfiguration>();
        try {
            List<Record> records = queryManager.getRecords(credentials, "TABLE_INFO", (QueryIndex)null, null);
            if (records != null) {
                for (Record record : records) {
                    String columnFamily = record.getKey();
                    Map columns = record.getColumns();
                    if (columns == null || columns.size() <= 0) continue;
                    DataSourceType dataSourceType = DataSourceType.valueOf((String)columns.get("dataSourceType"));
                    String columnList = (String)columns.get("columns");
                    ArrayList<String> cfColumns = new ArrayList<String>();
                    if (columnList != null) {
                        String[] columnTokens;
                        for (String columnToken : columnTokens = columnList.split(":")) {
                            if ("".equals(columnToken)) continue;
                            cfColumns.add(columnToken);
                        }
                    }
                    CassandraCFConfiguration cfConfiguration = new CassandraCFConfiguration(columnFamily, cfColumns, dataSourceType);
                    String secondaryTableList = (String)columns.get("secondaryColumnFamilies");
                    ArrayList<String> secondaryTables = new ArrayList<String>();
                    if (secondaryTableList != null) {
                        String[] secondaryTableTokens;
                        for (String secondaryTableToken : secondaryTableTokens = secondaryTableList.split(":")) {
                            if ("".equals(secondaryTableToken)) continue;
                            secondaryTables.add(secondaryTableToken);
                        }
                    }
                    cfConfiguration.setSecondaryTables(secondaryTables);
                    cfConfiguration.setAutoGenerated(Boolean.valueOf((String)columns.get("autoGenerated")));
                    cfConfiguration.setPrimaryTable(Boolean.valueOf((String)columns.get("isPrimaryCF")));
                    cfConfigurations.add(cfConfiguration);
                }
            }
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to fetch column family configurations..", e);
        }
        return cfConfigurations;
    }

    @Override
    public TableConfiguration getTableMetaData(Map<String, String> credentials, String columnFamily) throws ConfigurationException {
        QueryManager queryManager = new QueryManager();
        CassandraCFConfiguration cfConfiguration = null;
        try {
            Record record;
            Map columns;
            List<Record> records = queryManager.getRecords(credentials, "TABLE_INFO", columnFamily, null);
            if (records != null && (columns = (record = records.get(0)).getColumns()) != null) {
                DataSourceType dataSourceType = DataSourceType.valueOf((String)columns.get("dataSourceType"));
                String columnList = (String)columns.get("columns");
                ArrayList<String> cfColumns = new ArrayList<String>();
                if (columnList != null) {
                    String[] columnTokens;
                    for (String columnToken : columnTokens = columnList.split(":")) {
                        if ("".equals(columnToken)) continue;
                        cfColumns.add(columnToken);
                    }
                }
                cfConfiguration = new CassandraCFConfiguration(columnFamily, cfColumns, dataSourceType);
                String secondaryTableList = (String)columns.get("secondaryColumnFamilies");
                ArrayList<String> secondaryTables = new ArrayList<String>();
                if (secondaryTableList != null) {
                    String[] secondaryTableTokens;
                    for (String secondaryTableToken : secondaryTableTokens = secondaryTableList.split(":")) {
                        if ("".equals(secondaryTableToken)) continue;
                        secondaryTables.add(secondaryTableToken);
                    }
                }
                cfConfiguration.setSecondaryTables(secondaryTables);
                cfConfiguration.setAutoGenerated(Boolean.valueOf((String)columns.get("autoGenerated")));
                cfConfiguration.setPrimaryTable(Boolean.valueOf((String)columns.get("isPrimaryCF")));
            }
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to fetch column family configuration for column family " + columnFamily + "..", e);
        }
        return cfConfiguration;
    }
}

