/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.persistence.cassandra;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.Granularity;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.configurations.IndexingTaskConfiguration;
import org.wso2.carbon.bam.core.dataobjects.Cursor;
import org.wso2.carbon.bam.core.dataobjects.Record;
import org.wso2.carbon.bam.core.persistence.IndexManager;
import org.wso2.carbon.bam.core.persistence.IndexingStrategy;
import org.wso2.carbon.bam.core.persistence.MetaDataManager;
import org.wso2.carbon.bam.core.persistence.PersistenceManager;
import org.wso2.carbon.bam.core.persistence.QueryManager;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraCFConfiguration;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraIndexConfiguration;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.IndexingException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;
import org.wso2.carbon.bam.core.utils.TimeStampFactory;
import org.wso2.carbon.bam.core.utils.Utils;

public class CassandraIndexingStrategy
implements IndexingStrategy {
    private static final Log log = LogFactory.getLog(PersistenceManager.class);

    @Override
    public void createIndex(IndexConfiguration indexConfiguration, Map<String, String> credentials) throws IndexingException {
        try {
            int tenantId;
            PersistenceManager manager = new PersistenceManager();
            manager.getDataStore(indexConfiguration.getDataSourceType(), credentials);
            try {
                tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
            }
            catch (StoreException e) {
                throw new IndexingException("Unable to create index " + indexConfiguration.getIndexName() + " ..", e);
            }
            if (!manager.isTableExists(credentials, indexConfiguration.getIndexedTable())) {
                CassandraCFConfiguration cfConfiguration = new CassandraCFConfiguration(indexConfiguration.getIndexedTable(), null, DataSourceType.CASSANDRA);
                manager.createTable(credentials, cfConfiguration);
            }
            if (indexConfiguration.isAutoGenerated()) {
                MetaDataManager metaDataManager = MetaDataManager.getInstance();
                metaDataManager.storeIndexMetaData(credentials, indexConfiguration);
                return;
            }
            CassandraCFConfiguration config = new CassandraCFConfiguration(indexConfiguration.getIndexName() + "_Index_" + indexConfiguration.getIndexedTable(), null, DataSourceType.CASSANDRA);
            config.setPrimaryTable(Boolean.TRUE);
            config.setAutoGenerated(Boolean.TRUE);
            ArrayList<String> secondaryTables = new ArrayList<String>();
            if (indexConfiguration.getIndexedTable().equalsIgnoreCase("BASE")) {
                secondaryTables.add("EVENT");
                secondaryTables.add("META");
                secondaryTables.add("CORRELATION");
            } else {
                secondaryTables.add(indexConfiguration.getIndexedTable());
            }
            config.setSecondaryTables(secondaryTables);
            manager.createTable(credentials, config);
            ((CassandraIndexConfiguration)indexConfiguration).setIndexingColumnFamily(config.getTableName());
            indexConfiguration.setManuallyIndexed(Boolean.TRUE);
            MetaDataManager metaDataManager = MetaDataManager.getInstance();
            metaDataManager.storeIndexMetaData(credentials, indexConfiguration);
            IndexingTaskConfiguration taskConfiguration = new IndexingTaskConfiguration();
            taskConfiguration.setCredentials(credentials);
            taskConfiguration.setTenantId(tenantId);
            taskConfiguration.setTaskName(indexConfiguration.getIndexName() + "_Index_" + indexConfiguration.getIndexedTable());
            String cron = ((CassandraIndexConfiguration)indexConfiguration).getCron();
            if (cron != null && !"".equals(cron)) {
                taskConfiguration.setCron(cron);
            } else {
                taskConfiguration.setInterval(30000);
            }
            IndexManager.getInstance().scheduleIndexingTask(indexConfiguration, taskConfiguration);
        }
        catch (StoreException e) {
            throw new IndexingException("Unable to create index..", e);
        }
        catch (ConfigurationException e) {
            throw new IndexingException("Unable to create index..", e);
        }
        catch (IndexingException e) {
            throw e;
        }
    }

    @Override
    public void editIndex(IndexConfiguration configuration, Map<String, String> credentials) throws IndexingException {
        int tenantId;
        try {
            tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        }
        catch (StoreException e) {
            throw new IndexingException("Unable to obtain tenant information", e);
        }
        String taskName = configuration.getIndexName() + "_Index_" + configuration.getIndexedTable();
        IndexingTaskConfiguration taskConfiguration = new IndexingTaskConfiguration();
        taskConfiguration.setTaskName(taskName);
        taskConfiguration.setTenantId(tenantId);
        IndexManager.getInstance().unScheduleIndexingTask(taskConfiguration);
        taskConfiguration = new IndexingTaskConfiguration();
        taskConfiguration.setCredentials(credentials);
        taskConfiguration.setTenantId(tenantId);
        taskConfiguration.setTaskName(taskName);
        String cron = ((CassandraIndexConfiguration)configuration).getCron();
        if (cron != null) {
            taskConfiguration.setCron(cron);
        } else {
            taskConfiguration.setInterval(30000);
        }
        IndexManager.getInstance().scheduleIndexingTask(configuration, taskConfiguration);
    }

    @Override
    public void deleteIndex(String indexName, Map<String, String> credentials) throws IndexingException {
        int tenantId;
        if (!Utils.credentialsValid(credentials) && log.isDebugEnabled()) {
            log.debug((Object)"Credentials invalid or not yet provided..");
        }
        try {
            tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        }
        catch (StoreException e) {
            throw new IndexingException("Unable to obtain tenant information", e);
        }
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        try {
            CassandraIndexConfiguration configuration = (CassandraIndexConfiguration)metaDataManager.getIndexMetaData(credentials, indexName);
            String indexingColumnFamily = configuration.getIndexingColumnFamily();
            PersistenceManager persistenceManager = new PersistenceManager();
            persistenceManager.deleteTable(credentials, indexingColumnFamily);
            metaDataManager.deleteIndexMetaData(credentials, indexName);
            String taskName = configuration.getIndexName() + "_Index_" + configuration.getIndexedTable();
            IndexingTaskConfiguration taskConfiguration = new IndexingTaskConfiguration();
            taskConfiguration.setTaskName(taskName);
            taskConfiguration.setTenantId(tenantId);
            IndexManager.getInstance().unScheduleIndexingTask(taskConfiguration);
        }
        catch (ConfigurationException e) {
            throw new IndexingException("Unable to delete index meta data..", e);
        }
        catch (StoreException e) {
            throw new IndexingException("Unable to delete indexing column family..", e);
        }
    }

    @Override
    public void indexData(IndexConfiguration configuration, Cursor cursor, Map<String, String> credentials) throws IndexingException {
        List<Record> recordsToBeIndexed;
        CassandraIndexConfiguration config = (CassandraIndexConfiguration)configuration;
        String indexedCfName = config.getIndexedTable();
        String indexingCfName = config.getIndexingColumnFamily();
        QueryManager queryManager = new QueryManager();
        try {
            recordsToBeIndexed = queryManager.getRecords(credentials, indexedCfName, null, null, 10000, cursor);
        }
        catch (StoreException e) {
            throw new IndexingException("Error while indexing column family " + indexedCfName + " for index " + configuration.getIndexName() + "..", e);
        }
        ArrayList<Record> indexedRecords = new ArrayList<Record>();
        ArrayList<Record> indexRecords = new ArrayList<Record>();
        for (Record recordToBeIndexed : recordsToBeIndexed) {
            String rowKey = this.createRowKey(configuration.getIndexedColumns(), configuration.getGranularity(), recordToBeIndexed.getColumns());
            if (rowKey == null) continue;
            HashMap<String, String> columns = new HashMap<String, String>();
            columns.put(recordToBeIndexed.getKey(), "");
            Record indexedRecord = new Record(rowKey, columns);
            indexedRecords.add(indexedRecord);
            String[][] indexes = this.getIndexValueArrayOfRecord(indexedRecord, configuration);
            if (indexes == null) continue;
            for (int i = 0; i < indexes.length; ++i) {
                String subIndexValue = indexes[i][1];
                HashMap<String, String> column = new HashMap<String, String>();
                column.put(subIndexValue, "");
                String subIndexName = indexes[i][0];
                String subIndexRecordKey = "INDEX---" + config.getIndexName() + "---" + "SUB_INDEX" + "---" + subIndexName;
                Record subIndexValueRecord = new Record(subIndexRecordKey, column);
                if (i + 1 != indexes.length) {
                    String nextSubIndexValuesRecordKey = "INDEX---" + config.getIndexName() + "---" + "SUB_INDEX" + "---" + subIndexName + "---" + "SUB_INDEX_VALUE" + "---" + subIndexValue;
                    String nextSubIndexValue = indexes[i + 1][1];
                    HashMap<String, String> nexSubIndexValueColumn = new HashMap<String, String>();
                    nexSubIndexValueColumn.put(nextSubIndexValue, "");
                    Record nextSubIndexRecord = new Record(nextSubIndexValuesRecordKey, nexSubIndexValueColumn);
                    indexRecords.add(nextSubIndexRecord);
                }
                indexRecords.add(subIndexValueRecord);
            }
        }
        PersistenceManager persistenceManager = new PersistenceManager();
        try {
            persistenceManager.storeRecords(credentials, indexingCfName, indexedRecords);
        }
        catch (StoreException e) {
            throw new IndexingException("Error while indexing column family " + indexedCfName + " for index " + configuration.getIndexName() + "..", e);
        }
        try {
            persistenceManager.storeRecords(credentials, "META_INFO", indexRecords);
        }
        catch (StoreException e) {
            throw new IndexingException("Error while storing index value meta data for column family " + indexedCfName + " for index " + configuration.getIndexName() + "..", e);
        }
    }

    @Override
    public Map<String, String> getIndexValuesOfRecord(Record record, IndexConfiguration configuration) {
        String key = record.getKey();
        if (key != null) {
            String[] compositeValues = key.split("---");
            LinkedHashMap<String, String> indexValues = new LinkedHashMap<String, String>();
            String[] columns = configuration.getIndexedColumns();
            for (int i = 0; i < compositeValues.length; ++i) {
                String compositeValue = compositeValues[i];
                String compositeColumn = columns[i];
                indexValues.put(compositeColumn, compositeValue);
            }
            return indexValues;
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getIndexValues(String indexName, Map<String, String> credentials) throws IndexingException {
        if (!Utils.credentialsValid(credentials) && log.isDebugEnabled()) {
            log.debug((Object)"Credentials invalid or not yet provided..");
        }
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        HashMap<String, List<String>> indexValues = new HashMap<String, List<String>>();
        try {
            CassandraIndexConfiguration configuration = (CassandraIndexConfiguration)metaDataManager.getIndexMetaData(credentials, indexName);
            String indexingColumnFamily = configuration.getIndexingColumnFamily();
            String[] indexedColumns = configuration.getIndexedColumns();
            QueryManager queryManager = new QueryManager();
            try {
                for (String indexedColumn : indexedColumns) {
                    String indexValuesRowKey = "INDEX---" + configuration.getIndexName() + "---" + "SUB_INDEX" + "---" + indexedColumn;
                    List<Record> records = queryManager.getRecords(credentials, "META_INFO", indexValuesRowKey, null);
                    if (records == null || records.size() <= 0) continue;
                    Record record = records.get(0);
                    Map columns = record.getColumns();
                    ArrayList<String> values = new ArrayList<String>();
                    for (String value : columns.keySet()) {
                        values.add(value);
                    }
                    indexValues.put(indexedColumn, values);
                }
            }
            catch (StoreException e) {
                throw new IndexingException("Unable to fetch index value information for index " + indexName + "..", e);
            }
        }
        catch (ConfigurationException e) {
            throw new IndexingException("Unable to fetch index value information for index " + indexName + "..", e);
        }
        return indexValues;
    }

    @Override
    public String[] getNextSubIndexValues(String indexName, String subIndex, String subIndexValue, Map<String, String> credentials) throws IndexingException {
        if (!Utils.credentialsValid(credentials) && log.isDebugEnabled()) {
            log.debug((Object)"Credentials invalid or not yet provided..");
        }
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        try {
            CassandraIndexConfiguration configuration = (CassandraIndexConfiguration)metaDataManager.getIndexMetaData(credentials, indexName);
            String indexingColumnFamily = configuration.getIndexingColumnFamily();
            QueryManager queryManager = new QueryManager();
            String subIndexValuesRecordKey = "INDEX---" + configuration.getIndexName() + "---" + "SUB_INDEX" + "---" + subIndex + "---" + "SUB_INDEX_VALUE" + "---" + subIndexValue;
            try {
                List<Record> records = queryManager.getRecords(credentials, "META_INFO", subIndexValuesRecordKey, null);
                if (records != null && records.size() > 0) {
                    Record record = records.get(0);
                    Map columns = record.getColumns();
                    ArrayList<String> values = new ArrayList<String>();
                    if (columns != null) {
                        for (String value : columns.keySet()) {
                            values.add(value);
                        }
                    }
                    return values.toArray(new String[0]);
                }
            }
            catch (StoreException e) {
                throw new IndexingException("Unable to fetch index value information for index " + indexName + "..", e);
            }
        }
        catch (ConfigurationException e) {
            throw new IndexingException("Unable to fetch index value information for index " + indexName + "..", e);
        }
        return null;
    }

    public String createRowKey(String[] indexedColumns, Granularity granularity, Map<String, String> columns) throws IndexingException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < indexedColumns.length; ++i) {
            String columnName = indexedColumns[i];
            if (columns.containsKey(columnName)) {
                String rowKeyPartValue = columns.get(columnName);
                if (columnName.equals("timeStamp")) {
                    try {
                        rowKeyPartValue = TimeStampFactory.getFactory().getTimeStamp(columns.get(columnName), granularity);
                    }
                    catch (ParseException e) {
                        throw new IndexingException("Cannot parse time stamp : " + columns.get(columnName));
                    }
                }
                buffer.append(rowKeyPartValue);
                if (i + 1 == indexedColumns.length) continue;
                buffer.append("---");
                continue;
            }
            return null;
        }
        buffer.trimToSize();
        return buffer.toString();
    }

    private String[][] getIndexValueArrayOfRecord(Record record, IndexConfiguration configuration) {
        String key = record.getKey();
        if (key != null) {
            String[] compositeValues = key.split("---");
            String[][] indexValues = new String[compositeValues.length][2];
            String[] columns = configuration.getIndexedColumns();
            for (int i = 0; i < compositeValues.length; ++i) {
                indexValues[i][0] = columns[i];
                indexValues[i][1] = compositeValues[i];
            }
            return indexValues;
        }
        return null;
    }
}

