/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.persistence.cassandra;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.beans.Rows;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.MultigetSliceQuery;
import me.prettyprint.hector.api.query.QueryResult;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.persistence.AbstractDataStore;
import org.wso2.carbon.bam.core.persistence.MetaDataManager;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraCFConfiguration;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraIndexConfiguration;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraIndexingStrategy;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraMetaDataPersistor;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraUtils;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.IndexingException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;
import org.wso2.carbon.bam.core.utils.Utils;
import org.wso2.carbon.cassandra.dataaccess.ClusterInformation;

public class CassandraDataStore
extends AbstractDataStore {
    private static final Log log = LogFactory.getLog(CassandraDataStore.class);
    private static final int SUPER_TENANT = 0;
    private static StringSerializer stringSerializer = StringSerializer.get();
    private static ByteBufferSerializer byteBufferSerializer = ByteBufferSerializer.get();
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Cluster cluster = null;
    private Keyspace keySpace = null;
    private KeyspaceDefinition keySpaceDef = null;
    private Map<String, String> credentials;
    private ThreadLocal<Boolean> startBatchCommit = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private ThreadLocal<Mutator<String>> mutatorThreadLocal = new ThreadLocal();

    public static void main(String[] args) {
        TSocket socket = new TSocket("192.168.0.100", 9160);
        TBinaryProtocol tBinaryProtocol = new TBinaryProtocol((TTransport)socket, true, true);
        TSocket transport = socket;
        try {
            transport.open();
            Cassandra.Client client = new Cassandra.Client((TProtocol)tBinaryProtocol);
            Map schemaVersions = client.describe_schema_versions();
            transport.close();
        }
        catch (TTransportException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize(Map<String, String> credentials) throws StoreException {
        int tenantId;
        this.credentials = credentials;
        String userName = credentials.get("username");
        String password = credentials.get("password");
        ClusterInformation clusterInfo = new ClusterInformation(userName, password);
        clusterInfo.setClusterName(userName);
        this.cluster = CassandraUtils.createCluster(clusterInfo);
        this.keySpaceDef = this.cluster.describeKeyspace("BAMKeySpace");
        CassandraCFConfiguration tableInfoCfConfiguration = new CassandraCFConfiguration("TABLE_INFO", null, DataSourceType.CASSANDRA);
        tableInfoCfConfiguration.setAutoGenerated(Boolean.TRUE);
        CassandraCFConfiguration cursorInfoCfConfiguration = new CassandraCFConfiguration("CURSOR_INFO", null, DataSourceType.CASSANDRA);
        cursorInfoCfConfiguration.setAutoGenerated(Boolean.TRUE);
        CassandraCFConfiguration indexInfoCfConfiguration = new CassandraCFConfiguration("INDEX_INFO", null, DataSourceType.CASSANDRA);
        indexInfoCfConfiguration.setAutoGenerated(Boolean.TRUE);
        CassandraCFConfiguration metaInfoCfConfiguration = new CassandraCFConfiguration("META_INFO", null, DataSourceType.CASSANDRA);
        metaInfoCfConfiguration.setAutoGenerated(Boolean.TRUE);
        CassandraCFConfiguration eventCfConfiguration = new CassandraCFConfiguration("EVENT", null, DataSourceType.CASSANDRA);
        CassandraCFConfiguration metaCfConfiguration = new CassandraCFConfiguration("META", null, DataSourceType.CASSANDRA);
        CassandraCFConfiguration baseCfConfiguration = new CassandraCFConfiguration("BASE", null, DataSourceType.CASSANDRA);
        CassandraCFConfiguration correlationCfConfiguration = new CassandraCFConfiguration("CORRELATION", null, DataSourceType.CASSANDRA);
        this.keySpace = HFactory.createKeyspace((String)"BAMKeySpace", (Cluster)this.cluster);
        if (this.keySpaceDef == null) {
            List<ColumnFamilyDefinition> columnFamilyDefinitionList = this.getAllColumnFamiliesAsList();
            this.cluster.addKeyspace(HFactory.createKeyspaceDefinition((String)"BAMKeySpace", (String)"org.apache.cassandra.locator.SimpleStrategy", (int)1, columnFamilyDefinitionList));
            this.keySpaceDef = this.cluster.describeKeyspace("BAMKeySpace");
            int retryCount = 0;
            while (this.keySpaceDef == null && retryCount < 100) {
                try {
                    Thread.sleep(100L);
                    this.keySpaceDef = this.cluster.describeKeyspace("BAMKeySpace");
                    if (this.keySpaceDef == null) continue;
                    break;
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            Map<String, String> tableConfigurationData = CassandraMetaDataPersistor.getTableMetaDataAsMap(tableInfoCfConfiguration);
            this.persistData("TABLE_INFO", "TABLE_INFO", tableConfigurationData);
            Map<String, String> cursorInfoTableConfigurationData = CassandraMetaDataPersistor.getTableMetaDataAsMap(cursorInfoCfConfiguration);
            this.persistData("TABLE_INFO", "CURSOR_INFO", cursorInfoTableConfigurationData);
            Map<String, String> tableConfigurationIndexInfoData = CassandraMetaDataPersistor.getTableMetaDataAsMap(indexInfoCfConfiguration);
            this.persistData("TABLE_INFO", "INDEX_INFO", tableConfigurationIndexInfoData);
            Map<String, String> tableConfigurationMetaInfoData = CassandraMetaDataPersistor.getTableMetaDataAsMap(metaInfoCfConfiguration);
            this.persistData("TABLE_INFO", "META_INFO", tableConfigurationMetaInfoData);
            Map<String, String> tableConfigurationEventData = CassandraMetaDataPersistor.getTableMetaDataAsMap(eventCfConfiguration);
            this.persistData("TABLE_INFO", "EVENT", tableConfigurationEventData);
            Map<String, String> tableConfigurationBaseData = CassandraMetaDataPersistor.getTableMetaDataAsMap(baseCfConfiguration);
            this.persistData("TABLE_INFO", "BASE", tableConfigurationBaseData);
            Map<String, String> tableConfigurationMetaData = CassandraMetaDataPersistor.getTableMetaDataAsMap(metaCfConfiguration);
            this.persistData("TABLE_INFO", "META", tableConfigurationMetaData);
            Map<String, String> tableConfigurationCorrelationData = CassandraMetaDataPersistor.getTableMetaDataAsMap(correlationCfConfiguration);
            this.persistData("TABLE_INFO", "CORRELATION", tableConfigurationCorrelationData);
        }
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        try {
            tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        }
        catch (StoreException e) {
            tenantId = 0;
            log.error((Object)"Unable to obtain tenant information. Assuming tenant super tenant..");
        }
        metaDataManager.addTableMetaDataForTenant(tenantId, tableInfoCfConfiguration);
        metaDataManager.addTableMetaDataForTenant(tenantId, cursorInfoCfConfiguration);
        metaDataManager.addTableMetaDataForTenant(tenantId, indexInfoCfConfiguration);
        metaDataManager.addTableMetaDataForTenant(tenantId, metaInfoCfConfiguration);
        metaDataManager.addTableMetaDataForTenant(tenantId, eventCfConfiguration);
        metaDataManager.addTableMetaDataForTenant(tenantId, baseCfConfiguration);
        metaDataManager.addTableMetaDataForTenant(tenantId, metaCfConfiguration);
        metaDataManager.addTableMetaDataForTenant(tenantId, correlationCfConfiguration);
    }

    public Keyspace getKeySpace() {
        return this.keySpace;
    }

    private List<ColumnFamilyDefinition> getAllColumnFamiliesAsList() {
        return Arrays.asList(HFactory.createColumnFamilyDefinition((String)"BAMKeySpace", (String)"TABLE_INFO"), HFactory.createColumnFamilyDefinition((String)"BAMKeySpace", (String)"CURSOR_INFO"), HFactory.createColumnFamilyDefinition((String)"BAMKeySpace", (String)"INDEX_INFO"), HFactory.createColumnFamilyDefinition((String)"BAMKeySpace", (String)"META_INFO"), HFactory.createColumnFamilyDefinition((String)"BAMKeySpace", (String)"EVENT"), HFactory.createColumnFamilyDefinition((String)"BAMKeySpace", (String)"META"), HFactory.createColumnFamilyDefinition((String)"BAMKeySpace", (String)"CORRELATION"));
    }

    @Override
    public void persistData(String cfName, String rowKey, Map<String, String> columns) throws StoreException {
        if (!this.isTableExists(cfName)) {
            throw new StoreException("The column family '" + cfName + "' does not exist..");
        }
        Mutator mutator = this.startBatchCommit.get() != false ? this.mutatorThreadLocal.get() : HFactory.createMutator((Keyspace)this.keySpace, (Serializer)stringSerializer);
        for (Map.Entry<String, String> column : columns.entrySet()) {
            mutator.addInsertion((Object)rowKey, cfName, HFactory.createStringColumn((String)column.getKey(), (String)column.getValue()));
        }
        this.persistMetaInformation(cfName, rowKey);
        if (!this.startBatchCommit.get().booleanValue()) {
            mutator.execute();
        }
    }

    @Override
    public void deleteData(String cfName, String rowKey) throws StoreException {
        if (!this.isTableExists(cfName)) {
            throw new StoreException("The column family '" + cfName + "' does not exist..");
        }
        this.startBatchCommit();
        Mutator mutator = HFactory.createMutator((Keyspace)this.keySpace, (Serializer)stringSerializer);
        List<HColumn<String, String>> columns = this.getColumnsOfRow(cfName, "ROW_INDEX", rowKey, rowKey + "1", Integer.MAX_VALUE);
        String timeStampIndex = null;
        if (columns != null) {
            for (HColumn<String, String> column : columns) {
                if (!((String)column.getName()).equals(rowKey)) continue;
                timeStampIndex = (String)column.getValue();
            }
        }
        if (!rowKey.equals("ROW_INDEX") && !rowKey.equals("TIMESTAMP_INDEX")) {
            this.deleteRowColumn(cfName, "ROW_INDEX", rowKey);
            if (timeStampIndex != null) {
                this.deleteRowColumn(cfName, "TIMESTAMP_INDEX", timeStampIndex);
            }
        }
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        try {
            List<IndexConfiguration> indexConfigurations = metaDataManager.getIndexMetaDataOfTable(this.credentials, cfName);
            if (indexConfigurations != null) {
                for (IndexConfiguration indexConfiguration : indexConfigurations) {
                    if (!(indexConfiguration instanceof CassandraIndexConfiguration)) continue;
                    CassandraIndexConfiguration cassandraIndexConfiguration = (CassandraIndexConfiguration)indexConfiguration;
                    String indexingColumnFamily = cassandraIndexConfiguration.getIndexingColumnFamily();
                    columns = this.getColumnsOfRow(cfName, rowKey, "", "", Integer.MAX_VALUE);
                    HashMap<String, String> columnMap = new HashMap<String, String>();
                    for (HColumn<String, String> column : columns) {
                        columnMap.put((String)column.getName(), (String)column.getValue());
                    }
                    CassandraIndexingStrategy indexingStrategy = new CassandraIndexingStrategy();
                    String indexRowKey = indexingStrategy.createRowKey(cassandraIndexConfiguration.getIndexedColumns(), null, columnMap);
                    if (indexRowKey == null) continue;
                    this.deleteRowColumn(indexingColumnFamily, indexRowKey, rowKey);
                }
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)("Unable to fetch table meta data. Will not be deleting indexed data for the row '" + rowKey + "' of table '" + cfName + "'. May cause in inconsistencies on indexed data.."), (Throwable)e);
        }
        catch (IndexingException e) {
            log.error((Object)("Unable to fetch indexed data for deletion for the row '" + rowKey + "' of the table '" + cfName + "'.."));
        }
        mutator.addDeletion((Object)rowKey, cfName, null, (Serializer)stringSerializer);
        mutator.execute();
    }

    @Override
    public void updateData(String table, String key, Map<String, String> columns) throws StoreException {
    }

    @Override
    public void persistBinaryData(String cfName, String rowKey, Map<String, ByteBuffer> data) throws StoreException {
        if (!this.isTableExists(cfName)) {
            throw new StoreException("The column family '" + cfName + "' does not exist..");
        }
        Mutator mutator = this.startBatchCommit.get() != false ? this.mutatorThreadLocal.get() : HFactory.createMutator((Keyspace)this.keySpace, (Serializer)stringSerializer);
        for (Map.Entry<String, ByteBuffer> column : data.entrySet()) {
            mutator.addInsertion((Object)rowKey, cfName, HFactory.createColumn((Object)column.getKey(), (Object)column.getValue(), (Serializer)stringSerializer, (Serializer)byteBufferSerializer));
        }
        this.persistMetaInformation(cfName, rowKey);
        if (!this.startBatchCommit.get().booleanValue()) {
            mutator.execute();
        }
    }

    @Override
    public void startBatchCommit() {
        if (!this.startBatchCommit.get().booleanValue()) {
            this.startBatchCommit.set(true);
            this.mutatorThreadLocal.set((Mutator<String>)HFactory.createMutator((Keyspace)this.keySpace, (Serializer)stringSerializer));
        }
    }

    @Override
    public void endBatchCommit() {
        if (this.startBatchCommit.get().booleanValue()) {
            this.mutatorThreadLocal.get().execute();
            this.mutatorThreadLocal.set(null);
            this.startBatchCommit.set(false);
        }
    }

    @Override
    public boolean isTableExists(String table) {
        int retryCount = 0;
        while (!this.isCfExists(table)) {
            if (retryCount < 100) {
                try {
                    Thread.sleep(100L);
                    ++retryCount;
                    continue;
                }
                catch (InterruptedException ignored) {
                    break;
                }
            }
            return false;
        }
        return true;
    }

    private boolean isCfExists(String table) {
        MultigetSliceQuery multigetSliceQuery = HFactory.createMultigetSliceQuery((Keyspace)this.keySpace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
        multigetSliceQuery.setColumnFamily(table);
        multigetSliceQuery.setKeys((Object[])new String[]{"test"});
        multigetSliceQuery.setRange((Object)"", (Object)"", false, 1);
        try {
            multigetSliceQuery.execute();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createTable(String table, List<String> fields) throws StoreException {
        ColumnFamilyDefinition columnFamilyDefinition = HFactory.createColumnFamilyDefinition((String)"BAMKeySpace", (String)table);
        Class<CassandraDataStore> clazz = CassandraDataStore.class;
        synchronized (CassandraDataStore.class) {
            boolean cfDefFound = false;
            this.keySpaceDef = this.cluster.describeKeyspace("BAMKeySpace");
            if (this.keySpaceDef != null) {
                for (ColumnFamilyDefinition cfDef : this.keySpaceDef.getCfDefs()) {
                    if (!cfDef.getName().equals(table)) continue;
                    cfDefFound = true;
                    break;
                }
                if (cfDefFound) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return false;
                }
            } else {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return false;
            }
            this.cluster.addColumnFamily(columnFamilyDefinition);
            KeyspaceDefinition keyspaceDefinition = this.cluster.describeKeyspace("BAMKeySpace");
            int retryCount = 0;
            int size = 0;
            try {
                Set knownPoolHosts = this.cluster.getKnownPoolHosts(true);
                Iterator hostIterator = knownPoolHosts.iterator();
                CassandraHost firstCassandraHost = null;
                if (hostIterator.hasNext()) {
                    firstCassandraHost = (CassandraHost)hostIterator.next();
                }
                TSocket socket = null;
                if (firstCassandraHost == null) {
                    throw new StoreException("Cassandra hosts are null. Why: Cassandra cluster has gone down");
                }
                socket = new TSocket(firstCassandraHost.getHost(), firstCassandraHost.getPort());
                TFramedTransport transport = new TFramedTransport((TTransport)socket);
                TBinaryProtocol tBinaryProtocol = new TBinaryProtocol((TTransport)transport, true, true);
                transport.open();
                Cassandra.Client client = new Cassandra.Client((TProtocol)tBinaryProtocol);
                while (size != 1 && retryCount < 100) {
                    Map describeSV = client.describe_schema_versions();
                    try {
                        size = describeSV.size();
                        Thread.sleep(1000L);
                        ++retryCount;
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("No. of schema versions in cluster : " + size));
                    }
                    catch (InterruptedException ignored) {}
                }
                if (size != 1) {
                    String message = "Fatal Error: Cassandra Schema not in agreement";
                    RuntimeException runtimeException = new RuntimeException(message);
                    log.error((Object)message, (Throwable)runtimeException);
                    throw runtimeException;
                }
                transport.close();
            }
            catch (InvalidRequestException e) {
                String message = "Invalid request when connecting to Cassandra cluster";
                log.error((Object)message, (Throwable)e);
                throw new StoreException(message, e);
            }
            catch (TException e) {
                String message = "Transport issue when connecting to Cassandra cluster";
                log.error((Object)message, (Throwable)e);
                throw new StoreException(message, e);
            }
            return true;
        }
    }

    @Override
    public boolean deleteTable(String columnFamily) throws StoreException {
        if (this.isTableExists(columnFamily)) {
            this.cluster.dropColumnFamily("BAMKeySpace", columnFamily);
        }
        while (this.isTableExists(columnFamily)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    @Override
    public DataSourceType getDataSourceType() {
        return DataSourceType.CASSANDRA;
    }

    private void persistMetaInformation(String table, String key) {
        Mutator mutator = this.startBatchCommit.get() != false ? this.mutatorThreadLocal.get() : HFactory.createMutator((Keyspace)this.keySpace, (Serializer)stringSerializer);
        String date = this.formatter.format(new Date());
        long currentTime = System.nanoTime();
        String dateTime = date + ":" + Long.toString(currentTime);
        mutator.addInsertion((Object)"ROW_INDEX", table, HFactory.createStringColumn((String)key, (String)dateTime));
        mutator.addInsertion((Object)"TIMESTAMP_INDEX", table, HFactory.createStringColumn((String)dateTime, (String)key));
        if (!this.startBatchCommit.get().booleanValue()) {
            mutator.execute();
        }
    }

    private void deleteRowColumn(String cfName, String rowKey, String column) throws StoreException {
        if (!this.isTableExists(cfName)) {
            throw new StoreException("The column family '" + cfName + "' does not exist..");
        }
        Mutator mutator = this.startBatchCommit.get() != false ? this.mutatorThreadLocal.get() : HFactory.createMutator((Keyspace)this.keySpace, (Serializer)stringSerializer);
        mutator.addDeletion((Object)rowKey, cfName, (Object)column, (Serializer)stringSerializer);
        if (!this.startBatchCommit.get().booleanValue()) {
            mutator.execute();
        }
    }

    private List<HColumn<String, String>> getColumnsOfRow(String cfName, String rowKey, String rangeFirst, String rangeLast, int batchSize) {
        MultigetSliceQuery multigetSliceQuery = HFactory.createMultigetSliceQuery((Keyspace)this.keySpace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
        multigetSliceQuery.setColumnFamily(cfName);
        multigetSliceQuery.setKeys((Object[])new String[]{rowKey});
        multigetSliceQuery.setRange((Object)rangeFirst, (Object)rangeLast, false, batchSize);
        QueryResult result = multigetSliceQuery.execute();
        Row indexRow = ((Rows)result.get()).getByKey((Object)rowKey);
        List list = indexRow.getColumnSlice().getColumns();
        return list;
    }
}

