/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.persistence;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.TableConfiguration;
import org.wso2.carbon.bam.core.dataobjects.Cursor;
import org.wso2.carbon.bam.core.dataobjects.Record;
import org.wso2.carbon.bam.core.persistence.MetaDataManager;
import org.wso2.carbon.bam.core.persistence.PersistenceManager;
import org.wso2.carbon.bam.core.persistence.QueryIndex;
import org.wso2.carbon.bam.core.persistence.StoreFactory;
import org.wso2.carbon.bam.core.persistence.StoreFetcher;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraStoreFactory;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;
import org.wso2.carbon.bam.core.persistence.sql.SQLStoreFactory;
import org.wso2.carbon.bam.core.utils.Utils;

public class QueryManager {
    private static final Log log = LogFactory.getLog(QueryManager.class);

    public List<String> getIndexValues(Map<String, String> credentials, String indexName) {
        return null;
    }

    public List<String> getTableColumns(Map<String, String> credentials, String tableName) {
        return null;
    }

    public List<Record> getRecords(Map<String, String> credentials, String table, String primaryKey, List<String> filterByColumns) throws StoreException {
        if (table != null && primaryKey != null && Utils.credentialsValid(credentials)) {
            PersistenceManager persistenceManager = new PersistenceManager();
            int tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
            if (persistenceManager.isTableExists(credentials, table)) {
                TableConfiguration tableConfiguration;
                try {
                    tableConfiguration = MetaDataManager.getInstance().getTableMetaData(tenantId, table);
                }
                catch (ConfigurationException e) {
                    throw new StoreException("Unable to fetch table meta data..", e);
                }
                DataSourceType type = tableConfiguration.getDataSourceType();
                StoreFetcher fetcher = this.getStoreFetcher(type, credentials);
                if ("BASE".equalsIgnoreCase(table.trim())) {
                    List<Record> eventRecords = fetcher.fetchRecords("EVENT", primaryKey, filterByColumns);
                    for (Record eventRecord : eventRecords) {
                        List<Record> correlationRecords;
                        String key = eventRecord.getKey();
                        Map columns = eventRecord.getColumns();
                        List<Record> metaRecords = fetcher.fetchRecords("META", key, filterByColumns);
                        if (metaRecords != null && metaRecords.size() > 0) {
                            Record metaRecord = metaRecords.get(0);
                            columns.putAll(metaRecord.getColumns());
                        }
                        if ((correlationRecords = fetcher.fetchRecords("CORRELATION", key, filterByColumns)) == null || correlationRecords.size() <= 0) continue;
                        Record correlationRecord = correlationRecords.get(0);
                        columns.putAll(correlationRecord.getColumns());
                    }
                    return eventRecords;
                }
                List<Record> result = fetcher.fetchRecords(table, primaryKey, filterByColumns);
                return result;
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Either table name, primary key or credentials invalid..");
        }
        return null;
    }

    public List<Record> getRecords(Map<String, String> credentials, String table, QueryIndex index, List<String> filterByColumns) throws StoreException {
        if (table != null && Utils.credentialsValid(credentials)) {
            PersistenceManager persistenceManager = new PersistenceManager();
            int tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
            if (persistenceManager.isTableExists(credentials, table)) {
                TableConfiguration tableConfiguration;
                try {
                    tableConfiguration = MetaDataManager.getInstance().getTableMetaData(tenantId, table);
                }
                catch (ConfigurationException e) {
                    throw new StoreException("Unable to fetch table meta data..", e);
                }
                DataSourceType type = tableConfiguration.getDataSourceType();
                StoreFetcher fetcher = this.getStoreFetcher(type, credentials);
                if ("BASE".equalsIgnoreCase(table.trim())) {
                    List<Record> eventRecords = fetcher.fetchRecords("EVENT", index, filterByColumns);
                    for (Record eventRecord : eventRecords) {
                        List<Record> correlationRecords;
                        String key = eventRecord.getKey();
                        Map columns = eventRecord.getColumns();
                        List<Record> metaRecords = fetcher.fetchRecords("META", key, filterByColumns);
                        if (metaRecords != null && metaRecords.size() > 0) {
                            Record metaRecord = metaRecords.get(0);
                            columns.putAll(metaRecord.getColumns());
                        }
                        if ((correlationRecords = fetcher.fetchRecords("CORRELATION", key, filterByColumns)) == null || correlationRecords.size() <= 0) continue;
                        Record correlationRecord = correlationRecords.get(0);
                        columns.putAll(correlationRecord.getColumns());
                    }
                    return eventRecords;
                }
                List<Record> result = fetcher.fetchRecords(table, index, filterByColumns);
                return result;
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Either table name or credentials invalid at query manager.");
        }
        return null;
    }

    public List<Record> getRecords(Map<String, String> credentials, String table, QueryIndex index, List<String> filterByColumns, int batchSize, Cursor cursor) throws StoreException {
        if (table != null && Utils.credentialsValid(credentials)) {
            PersistenceManager persistenceManager = new PersistenceManager();
            int tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
            if (persistenceManager.isTableExists(credentials, table)) {
                TableConfiguration tableConfiguration;
                try {
                    tableConfiguration = MetaDataManager.getInstance().getTableMetaData(tenantId, table);
                }
                catch (ConfigurationException e) {
                    throw new StoreException("Unable to fetch table meta data..", e);
                }
                DataSourceType type = tableConfiguration.getDataSourceType();
                StoreFetcher fetcher = this.getStoreFetcher(type, credentials);
                if ("BASE".equalsIgnoreCase(table.trim())) {
                    List<Record> eventRecords = fetcher.fetchRecords("EVENT", index, filterByColumns, batchSize, cursor);
                    for (Record eventRecord : eventRecords) {
                        List<Record> correlationRecords;
                        String key = eventRecord.getKey();
                        Map columns = eventRecord.getColumns();
                        List<Record> metaRecords = fetcher.fetchRecords("META", key, filterByColumns);
                        if (metaRecords != null && metaRecords.size() > 0) {
                            Record metaRecord = metaRecords.get(0);
                            columns.putAll(metaRecord.getColumns());
                        }
                        if ((correlationRecords = fetcher.fetchRecords("CORRELATION", key, filterByColumns)) == null || correlationRecords.size() <= 0) continue;
                        Record correlationRecord = correlationRecords.get(0);
                        columns.putAll(correlationRecord.getColumns());
                    }
                    return eventRecords;
                }
                List<Record> result = fetcher.fetchRecords(table, index, filterByColumns, batchSize, cursor);
                return result;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Table " + table + " does not exist.."));
            }
        }
        return null;
    }

    public StoreFetcher getStoreFetcher(DataSourceType type, Map<String, String> credentials) throws StoreException {
        StoreFetcher store;
        switch (type) {
            case CASSANDRA: {
                StoreFactory factory = CassandraStoreFactory.getInstance();
                store = factory.getStoreFetcher(credentials);
                break;
            }
            case SQL: {
                SQLStoreFactory factory = SQLStoreFactory.getInstance();
                store = factory.getStoreFetcher(credentials);
                break;
            }
            default: {
                throw new StoreException("Unknown data source type..");
            }
        }
        return store;
    }
}

