/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.persistence;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.TableConfiguration;
import org.wso2.carbon.bam.core.dataobjects.EventData;
import org.wso2.carbon.bam.core.dataobjects.Record;
import org.wso2.carbon.bam.core.persistence.DataStore;
import org.wso2.carbon.bam.core.persistence.MetaDataManager;
import org.wso2.carbon.bam.core.persistence.StoreFactory;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraStoreFactory;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;
import org.wso2.carbon.bam.core.persistence.sql.SQLStoreFactory;
import org.wso2.carbon.bam.core.utils.Utils;

public class PersistenceManager {
    private static final Log log = LogFactory.getLog(PersistenceManager.class);
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void storeEvent(Map<String, String> credentials, EventData eventData) throws StoreException {
        if (!Utils.credentialsValid(credentials)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Credentials invalid or not yet provided. Discarding data..");
            }
            return;
        }
        DataStore store = this.getDataStoreForTable(credentials, "BASE");
        String timeStamp = formatter.format(new Date());
        String uuid = UUID.randomUUID().toString();
        String rowKey = timeStamp + "---" + System.nanoTime() + "---" + uuid;
        store.startBatchCommit();
        store.persistBinaryData("META", rowKey, eventData.getMetaData());
        store.persistBinaryData("CORRELATION", rowKey, eventData.getCorrelationData());
        store.persistBinaryData("EVENT", rowKey, eventData.getEventData());
        store.endBatchCommit();
    }

    public void storeRecord(Map<String, String> credentials, String table, Record record) throws StoreException {
        if (!Utils.credentialsValid(credentials)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Credentials invalid or not yet provided. Discarding data..");
            }
            return;
        }
        if (table != null && record != null) {
            DataStore store = this.getDataStoreForTable(credentials, table);
            store.persistData(table, record.getKey(), record.getColumns());
        }
    }

    public void storeRecords(Map<String, String> credentials, String table, List<Record> records) throws StoreException {
        if (!Utils.credentialsValid(credentials)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Credentials invalid or not yet provided. Discarding data..");
            }
            return;
        }
        if (table != null && records != null) {
            DataStore store = this.getDataStoreForTable(credentials, table);
            store.startBatchCommit();
            for (Record record : records) {
                store.persistData(table, record.getKey(), record.getColumns());
            }
            store.endBatchCommit();
        }
    }

    public void deleteRecord(Map<String, String> credentials, String table, String recordKey) throws StoreException {
        if (!Utils.credentialsValid(credentials)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Credentials invalid or not yet provided. Discarding data..");
            }
            return;
        }
        if (table != null && recordKey != null) {
            DataStore store = this.getDataStoreForTable(credentials, table);
            store.deleteData(table, recordKey);
        }
    }

    public synchronized boolean createTable(Map<String, String> credentials, TableConfiguration configuration) throws StoreException {
        if (!Utils.credentialsValid(credentials)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Credentials invalid or not yet provided..");
            }
            return false;
        }
        DataSourceType type = configuration.getDataSourceType();
        DataStore store = this.getDataStore(type, credentials);
        boolean success = store.createTable(configuration.getTableName(), configuration.getColumns());
        if (success) {
            try {
                MetaDataManager.getInstance().storeTableMetaData(credentials, configuration);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding table meta data failed for table : " + configuration.getTableName() + "."));
                }
                return false;
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Table creation failed at database for table : " + configuration.getTableName() + "."));
        }
        return true;
    }

    public boolean deleteTable(Map<String, String> credentials, String tableName) throws StoreException {
        TableConfiguration configuration;
        if (!Utils.credentialsValid(credentials) && log.isDebugEnabled()) {
            log.debug((Object)"Credentials invalid or not yet provided..");
        }
        try {
            configuration = MetaDataManager.getInstance().getTableMetaData(credentials.get("username"), tableName);
        }
        catch (ConfigurationException e) {
            throw new StoreException("Unable to fetch table meta data..", e);
        }
        if (configuration == null) {
            throw new StoreException("Table meta data not present for table " + tableName + "..");
        }
        DataSourceType dataSourceType = configuration.getDataSourceType();
        DataStore dataStore = this.getDataStore(dataSourceType, credentials);
        boolean success = dataStore.deleteTable(tableName);
        if (success) {
            try {
                MetaDataManager.getInstance().deleteTableMetaData(credentials, tableName);
            }
            catch (Exception e) {
                log.error((Object)"Error while deleting the table..", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public boolean isTableExists(Map<String, String> credentials, String tableName) throws StoreException {
        TableConfiguration configuration;
        if (!Utils.credentialsValid(credentials)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Credentials invalid or not yet provided..");
            }
            return false;
        }
        this.initializeDataStores(credentials);
        try {
            configuration = MetaDataManager.getInstance().getTableMetaData(credentials.get("username"), tableName);
        }
        catch (ConfigurationException e) {
            throw new StoreException("Unable to fetch table meta data..", e);
        }
        if (configuration != null) {
            return true;
        }
        for (DataSourceType type : DataSourceType.values()) {
            DataStore store = this.getDataStore(type, credentials);
            boolean tableExists = store.isTableExists(tableName);
            if (!tableExists) continue;
            log.warn((Object)("{{Table meta data is not in synchronization with database for table " + tableName + " }}"));
            return true;
        }
        return false;
    }

    public DataStore getDataStoreForTable(Map<String, String> credentials, String table) throws StoreException {
        TableConfiguration configuration;
        if (!Utils.credentialsValid(credentials)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Credentials invalid or not yet provided. Discarding data..");
            }
            return null;
        }
        int tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        this.getDataStore(DataSourceType.CASSANDRA, credentials);
        try {
            configuration = MetaDataManager.getInstance().getTableMetaData(tenantId, table);
        }
        catch (ConfigurationException e) {
            throw new StoreException("Unable to fetch table meta data..", e);
        }
        if (configuration != null) {
            DataStore store = this.getDataStore(configuration.getDataSourceType(), credentials);
            return store;
        }
        if (table.equals("BASE")) {
            return this.getDefaultDataStore(credentials);
        }
        throw new StoreException("Table '" + table + "' is not present in the database..");
    }

    public DataStore getDataStore(DataSourceType type, Map<String, String> credentials) throws StoreException {
        if (!Utils.credentialsValid(credentials)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Credentials invalid or not yet provided. Discarding data..");
            }
            return null;
        }
        DataStore store = null;
        switch (type) {
            case CASSANDRA: {
                StoreFactory factory = CassandraStoreFactory.getInstance();
                store = factory.getDataStore(credentials);
                break;
            }
            case SQL: {
                SQLStoreFactory factory = SQLStoreFactory.getInstance();
                store = factory.getDataStore(credentials);
            }
        }
        return store;
    }

    public DataStore getDefaultDataStore(Map<String, String> credentials) throws StoreException {
        if (!Utils.credentialsValid(credentials)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Credentials invalid or not yet provided. Discarding data..");
            }
            return null;
        }
        StoreFactory factory = CassandraStoreFactory.getInstance();
        return factory.getDataStore(credentials);
    }

    public DataSourceType[] getDataSourceTypes() {
        return DataSourceType.values();
    }

    private void initializeDataStores(Map<String, String> credentials) throws StoreException {
        for (DataSourceType type : DataSourceType.values()) {
            this.getDataStore(type, credentials);
        }
    }
}

