/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.persistence;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.Granularity;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.configurations.IndexUsageProvider;
import org.wso2.carbon.bam.core.configurations.MetaDataPersistor;
import org.wso2.carbon.bam.core.configurations.TableConfiguration;
import org.wso2.carbon.bam.core.dataobjects.Cursor;
import org.wso2.carbon.bam.core.dataobjects.Record;
import org.wso2.carbon.bam.core.internal.ServiceHolder;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraCFConfiguration;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraIndexConfiguration;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraMetaDataPersistor;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;
import org.wso2.carbon.bam.core.utils.Utils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class MetaDataManager {
    private static final int INITIAL_DELAY = 120000;
    private static final int PERIOD = 60000;
    private static MetaDataManager instance = new MetaDataManager();
    private final ScheduledExecutorService updaterPool = Executors.newSingleThreadScheduledExecutor();
    private Map<Integer, List<IndexConfiguration>> indexConfigurations;
    private Map<Integer, List<TableConfiguration>> tableConfigurations;
    private Map<Integer, IndexUsageProvider> indexUsageProviderMap;
    private List<MetaDataPersistor> metaDataPersistors = new ArrayList<MetaDataPersistor>();
    private static final Log log = LogFactory.getLog(MetaDataManager.class);

    private MetaDataManager() {
        this.indexConfigurations = new ConcurrentHashMap<Integer, List<IndexConfiguration>>();
        this.tableConfigurations = new ConcurrentHashMap<Integer, List<TableConfiguration>>();
        this.indexUsageProviderMap = new ConcurrentHashMap<Integer, IndexUsageProvider>();
        this.metaDataPersistors.add(new CassandraMetaDataPersistor());
    }

    public static MetaDataManager getInstance() {
        return instance;
    }

    public List<IndexConfiguration> getAllIndexMetaData(Map<String, String> credentials) throws ConfigurationException {
        int tenantId;
        try {
            tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to obtain tenant information", e);
        }
        List<IndexConfiguration> configurations = this.indexConfigurations.get(tenantId);
        if (configurations == null) {
            this.synchronizeIndexMetaDataForTenant(tenantId);
            configurations = this.indexConfigurations.get(tenantId);
        }
        ArrayList<IndexConfiguration> clone = new ArrayList<IndexConfiguration>();
        for (IndexConfiguration configuration : configurations) {
            clone.add(this.cloneIndexMetaData(configuration));
        }
        return clone;
    }

    public List<IndexConfiguration> getIndexMetaDataOfTable(Map<String, String> credentials, String table) throws ConfigurationException {
        int tenantId;
        try {
            tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to obtain tenant information", e);
        }
        List<IndexConfiguration> configurations = this.indexConfigurations.get(tenantId);
        if (configurations == null) {
            this.synchronizeIndexMetaDataForTenant(tenantId);
            configurations = this.indexConfigurations.get(tenantId);
        }
        ArrayList<IndexConfiguration> indexesOfTable = new ArrayList<IndexConfiguration>();
        if (configurations != null) {
            for (IndexConfiguration configuration : configurations) {
                if (!configuration.getIndexedTable().equals(table)) continue;
                indexesOfTable.add(configuration);
            }
        }
        ArrayList<IndexConfiguration> clone = new ArrayList<IndexConfiguration>();
        for (IndexConfiguration indexConfiguration : indexesOfTable) {
            clone.add(this.cloneIndexMetaData(indexConfiguration));
        }
        return clone;
    }

    public IndexConfiguration getIndexMetaData(Map<String, String> credentials, String indexName) throws ConfigurationException {
        int tenantId;
        try {
            tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to obtain tenant information", e);
        }
        List<IndexConfiguration> configurations = this.indexConfigurations.get(tenantId);
        if (configurations == null) {
            this.synchronizeIndexMetaDataForTenant(tenantId);
            configurations = this.indexConfigurations.get(tenantId);
        }
        if (configurations != null) {
            for (IndexConfiguration configuration : configurations) {
                if (!configuration.getIndexName().equals(indexName)) continue;
                return this.cloneIndexMetaData(configuration);
            }
        }
        return null;
    }

    public int[] getAllTenantsWithDefinedIndexes() throws ConfigurationException {
        if (this.metaDataPersistors.size() > 0) {
            MetaDataPersistor persistor = this.metaDataPersistors.get(0);
            return persistor.getAllTenantsWithDefinedIndexes();
        }
        return null;
    }

    public List<TableConfiguration> getAllTableMetaData(Map<String, String> credentials) throws ConfigurationException {
        int tenantId;
        try {
            tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to obtain tenant information", e);
        }
        List<TableConfiguration> configurations = null;
        ArrayList<TableConfiguration> allCfConfigurations = new ArrayList<TableConfiguration>();
        for (MetaDataPersistor persistor : this.metaDataPersistors) {
            configurations = persistor.getAllTableMetaData(Utils.getConnectionParameters(tenantId));
            allCfConfigurations.addAll(configurations);
        }
        ArrayList<TableConfiguration> clone = new ArrayList<TableConfiguration>();
        for (TableConfiguration configuration : allCfConfigurations) {
            clone.add(this.cloneTableMetaData(configuration));
        }
        return clone;
    }

    public TableConfiguration getTableMetaData(int tenantId, String tableName) throws ConfigurationException {
        List<TableConfiguration> configurations = this.tableConfigurations.get(tenantId);
        if (tableName.trim().equalsIgnoreCase("TABLE_INFO")) {
            CassandraCFConfiguration tableInfoCfConfiguration = new CassandraCFConfiguration("TABLE_INFO", null, DataSourceType.CASSANDRA);
            tableInfoCfConfiguration.setAutoGenerated(Boolean.TRUE);
            configurations.add(tableInfoCfConfiguration);
            return tableInfoCfConfiguration;
        }
        ArrayList<TableConfiguration> allCfConfigurations = new ArrayList<TableConfiguration>();
        for (MetaDataPersistor persistor : this.metaDataPersistors) {
            configurations = persistor.getAllTableMetaData(Utils.getConnectionParameters(tenantId));
            allCfConfigurations.addAll(configurations);
        }
        if (allCfConfigurations != null) {
            for (TableConfiguration configuration : allCfConfigurations) {
                if (log.isDebugEnabled()) {
                    log.info((Object)("Table configuration : " + configuration.getTableName()));
                }
                if (!configuration.getTableName().equals(tableName)) continue;
                return this.cloneTableMetaData(configuration);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning null meta data for table : " + tableName + " for tenant : " + tenantId));
        }
        return null;
    }

    public TableConfiguration getTableMetaData(String userName, String tableName) throws ConfigurationException {
        int tenantId;
        String domain = MultitenantUtils.getTenantDomain((String)userName);
        try {
            tenantId = ServiceHolder.getRealmService().getTenantManager().getTenantId(domain);
        }
        catch (UserStoreException e) {
            throw new ConfigurationException("Unable to get tenant information from user name '" + userName + "'..", e);
        }
        return this.getTableMetaData(tenantId, tableName);
    }

    public void registerIndexUsageProvider(int tenantId, IndexUsageProvider provider) {
        this.indexUsageProviderMap.put(tenantId, provider);
    }

    public Cursor getCursorMetaData(Map<String, String> credentials, String table, String cursorName) throws ConfigurationException {
        if (this.metaDataPersistors.size() > 0) {
            MetaDataPersistor persistor = this.metaDataPersistors.get(0);
            Cursor cursor = persistor.getCursorMetaData(credentials, table, cursorName);
            return cursor;
        }
        return null;
    }

    public List<Cursor> getAllCursorMetaData(Map<String, String> credentials) throws ConfigurationException {
        if (this.metaDataPersistors.size() > 0) {
            MetaDataPersistor persistor = this.metaDataPersistors.get(0);
            return persistor.getAllCursorMetaData(credentials);
        }
        return null;
    }

    public void storeCursorMetaData(Map<String, String> credentials, Cursor cursor) throws ConfigurationException {
        if (this.metaDataPersistors.size() > 0) {
            MetaDataPersistor persistor = this.metaDataPersistors.get(0);
            persistor.persistCursorMetaData(credentials, cursor);
        }
    }

    public void deleteCursorMetaData(Map<String, String> credentials, Cursor cursor) throws ConfigurationException {
        if (this.metaDataPersistors.size() > 0) {
            MetaDataPersistor persistor = this.metaDataPersistors.get(0);
            persistor.deleteCursorMetaData(credentials, cursor);
        }
    }

    public void storeTableMetaData(Map<String, String> credentials, TableConfiguration configuration) throws ConfigurationException {
        int tenantId;
        MetaDataPersistor persistor = this.getMetaDataPersistor(configuration.getDataSourceType());
        persistor.persistTableMetaData(credentials, configuration);
        try {
            tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to obtain tenant information", e);
        }
        List<TableConfiguration> tenantTables = this.tableConfigurations.get(tenantId);
        if (tenantTables == null) {
            tenantTables = new ArrayList<TableConfiguration>();
        }
        tenantTables.add(configuration);
        this.tableConfigurations.put(tenantId, tenantTables);
    }

    public void addTableMetaDataForTenant(int tenantId, TableConfiguration configuration) {
        List<TableConfiguration> tenantTables = this.tableConfigurations.get(tenantId);
        if (tenantTables == null) {
            tenantTables = new ArrayList<TableConfiguration>();
        }
        tenantTables.add(configuration);
        this.tableConfigurations.put(tenantId, tenantTables);
        tenantTables = this.tableConfigurations.get(tenantId);
    }

    public void deleteTableMetaData(Map<String, String> credentials, String tableName) throws ConfigurationException {
        int tenantId;
        try {
            tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to obtain tenant information", e);
        }
        TableConfiguration tableConfiguration = this.getTableMetaData(tenantId, tableName);
        if (tableConfiguration != null) {
            MetaDataPersistor persistor = this.getMetaDataPersistor(tableConfiguration.getDataSourceType());
            persistor.deleteTableMetaData(credentials, tableName);
            this.synchronizeTableMetaDataForTenant(tenantId);
        }
    }

    public void storeIndexMetaData(Map<String, String> credentials, IndexConfiguration configuration) throws ConfigurationException {
        List<IndexConfiguration> tenantIndexes;
        int tenantId;
        try {
            tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to obtain tenant information", e);
        }
        String indexedTable = configuration.getIndexedTable();
        TableConfiguration tableConfiguration = this.getTableMetaData(tenantId, indexedTable);
        if (tableConfiguration != null) {
            MetaDataPersistor persistor = this.getMetaDataPersistor(tableConfiguration.getDataSourceType());
            persistor.persistIndexMetaData(credentials, configuration);
            tenantIndexes = this.indexConfigurations.get(tenantId);
            if (tenantIndexes == null) {
                tenantIndexes = new ArrayList<IndexConfiguration>();
            }
        } else {
            throw new ConfigurationException("Table " + indexedTable + " for which the index " + configuration.getIndexName() + " is defined is not found in the data source..");
        }
        tenantIndexes.add(configuration);
        this.indexConfigurations.put(tenantId, tenantIndexes);
    }

    public void deleteIndexMetaData(Map<String, String> credentials, String indexName) throws ConfigurationException {
        IndexConfiguration indexConfiguration = this.getIndexMetaData(credentials, indexName);
        if (indexConfiguration != null) {
            int tenantId;
            try {
                tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
            }
            catch (StoreException e) {
                throw new ConfigurationException("Unable to obtain tenant information", e);
            }
            MetaDataPersistor persistor = this.getMetaDataPersistor(indexConfiguration.getDataSourceType());
            persistor.deleteIndexMetaData(credentials, indexName);
            this.synchronizeIndexMetaDataForTenant(tenantId);
        }
    }

    public MetaDataPersistor getMetaDataPersistor(DataSourceType type) throws ConfigurationException {
        CassandraMetaDataPersistor persistor;
        switch (type) {
            case CASSANDRA: {
                persistor = new CassandraMetaDataPersistor();
                break;
            }
            case SQL: {
                persistor = null;
                break;
            }
            default: {
                throw new ConfigurationException("Unknown data source type " + type.name() + "..");
            }
        }
        return persistor;
    }

    public TableConfiguration createTableMetaData(String table, List<String> columns, DataSourceType dataSourceType, boolean autoGenerated) throws ConfigurationException {
        if (dataSourceType != null) {
            switch (dataSourceType) {
                case CASSANDRA: {
                    CassandraCFConfiguration configuration = new CassandraCFConfiguration(table, columns, dataSourceType);
                    configuration.setAutoGenerated(autoGenerated);
                    return configuration;
                }
            }
            throw new ConfigurationException("Unknown data source type " + dataSourceType.getName() + "..");
        }
        throw new ConfigurationException("Data source type must not be empty..");
    }

    public TableConfiguration createTableMetaData(String table, Record record, DataSourceType dataSourceType, boolean autoGenerated) throws ConfigurationException {
        Map columnMap;
        ArrayList<String> columns = null;
        if (record != null && (columnMap = record.getColumns()) != null) {
            columns = new ArrayList<String>();
            Set<String> columnNames = columnMap.keySet();
            for (String columnName : columnNames) {
                columns.add(columnName);
            }
        }
        return this.createTableMetaData(table, columns, dataSourceType, autoGenerated);
    }

    public TableConfiguration cloneTableMetaData(TableConfiguration configuration) throws ConfigurationException {
        DataSourceType dataSourceType = configuration.getDataSourceType();
        switch (dataSourceType) {
            case CASSANDRA: {
                CassandraCFConfiguration config = (CassandraCFConfiguration)configuration;
                ArrayList<String> clonedColumns = null;
                if (config.getColumns() != null) {
                    clonedColumns = new ArrayList<String>();
                    for (String column : configuration.getColumns()) {
                        clonedColumns.add(column);
                    }
                }
                ArrayList<String> clonedSecondaryTables = null;
                if (config.getSecondaryTables() != null) {
                    clonedSecondaryTables = new ArrayList<String>();
                    for (String secondaryTable : config.getSecondaryTables()) {
                        clonedSecondaryTables.add(secondaryTable);
                    }
                }
                CassandraCFConfiguration clone = new CassandraCFConfiguration(config.getTableName(), clonedColumns, dataSourceType);
                clone.setPrimaryTable(config.isPrimaryTable());
                clone.setSecondaryTables(clonedSecondaryTables);
                clone.setAutoGenerated(config.getAutoGenerated());
                return clone;
            }
        }
        throw new ConfigurationException("Unknown data source type " + dataSourceType.getName() + "..");
    }

    public IndexConfiguration createIndexMetaData(String indexName, String indexedTable, String[] indexedColumns, DataSourceType dataSourceType, Map<String, String> configurations) throws ConfigurationException {
        switch (dataSourceType) {
            case CASSANDRA: {
                CassandraIndexConfiguration indexConfiguration = null;
                boolean timeStampIndexFound = false;
                if (indexedColumns != null) {
                    indexConfiguration = new CassandraIndexConfiguration(indexName, indexedTable, (String[])indexedColumns.clone(), dataSourceType);
                    for (String indexedColumn : indexedColumns) {
                        if (!indexedColumn.equals("timeStamp")) continue;
                        timeStampIndexFound = true;
                    }
                } else {
                    indexConfiguration = new CassandraIndexConfiguration(indexName, indexedTable, null, dataSourceType);
                }
                indexConfiguration.setIndexingColumnFamily(configurations.get("indexingTable"));
                indexConfiguration.setCron(configurations.get("cron"));
                indexConfiguration.setManuallyIndexed(Boolean.TRUE);
                String granularity = configurations.get("granularity");
                if (granularity != null) {
                    indexConfiguration.setGranularity(Granularity.valueOf(granularity));
                    indexedColumns = indexConfiguration.getIndexedColumns();
                    if (indexedColumns != null) {
                        ArrayList<String> columnList = new ArrayList<String>();
                        for (String indexedColumn : indexedColumns) {
                            columnList.add(indexedColumn);
                        }
                        columnList.add("timeStamp");
                        indexConfiguration.setIndexedColumns(columnList.toArray(new String[0]));
                    } else {
                        String[] columnArray = new String[]{"timeStamp"};
                        indexConfiguration.setIndexedColumns(columnArray);
                    }
                } else if (timeStampIndexFound) {
                    indexConfiguration.setGranularity(Granularity.MINUTE);
                }
                return indexConfiguration;
            }
        }
        throw new ConfigurationException("Unknown data source type " + dataSourceType.getName() + "..");
    }

    public IndexConfiguration cloneIndexMetaData(IndexConfiguration configuration) throws ConfigurationException {
        DataSourceType dataSourceType = configuration.getDataSourceType();
        switch (dataSourceType) {
            case CASSANDRA: {
                CassandraIndexConfiguration config = (CassandraIndexConfiguration)configuration;
                CassandraIndexConfiguration clone = new CassandraIndexConfiguration(config.getIndexName(), config.getIndexedTable(), (String[])config.getIndexedColumns().clone(), dataSourceType);
                clone.setIndexingColumnFamily(config.getIndexingColumnFamily());
                clone.setManuallyIndexed(config.isManuallyIndexed());
                clone.setAutoGenerated(config.isAutoGenerated());
                clone.setGranularity(config.getGranularity());
                return clone;
            }
        }
        throw new ConfigurationException("Unknown data source type " + dataSourceType.getName() + "..");
    }

    private void synchronizeIndexMetaData() throws ConfigurationException {
        for (Map.Entry<Integer, List<IndexConfiguration>> entry : this.indexConfigurations.entrySet()) {
            ArrayList<IndexConfiguration> allIndexConfigurations = new ArrayList<IndexConfiguration>();
            int tenantId = entry.getKey();
            for (MetaDataPersistor persistor : this.metaDataPersistors) {
                List<IndexConfiguration> configurations = persistor.getAllIndexMetaData(Utils.getConnectionParameters(tenantId));
                allIndexConfigurations.addAll(configurations);
            }
            this.indexConfigurations.put(tenantId, allIndexConfigurations);
        }
    }

    private void synchronizeIndexMetaDataForTenant(int tenantId) throws ConfigurationException {
        ArrayList<IndexConfiguration> allIndexConfigurations = new ArrayList<IndexConfiguration>();
        for (MetaDataPersistor persistor : this.metaDataPersistors) {
            List<IndexConfiguration> configurations = persistor.getAllIndexMetaData(Utils.getConnectionParameters(tenantId));
            allIndexConfigurations.addAll(configurations);
        }
        this.indexConfigurations.put(tenantId, allIndexConfigurations);
    }

    private void synchronizeTableMetaData() throws ConfigurationException {
        for (Map.Entry<Integer, List<TableConfiguration>> entry : this.tableConfigurations.entrySet()) {
            ArrayList<TableConfiguration> allCfConfigurations = new ArrayList<TableConfiguration>();
            int tenantId = entry.getKey();
            for (MetaDataPersistor persistor : this.metaDataPersistors) {
                List<TableConfiguration> configurations = persistor.getAllTableMetaData(Utils.getConnectionParameters(tenantId));
                allCfConfigurations.addAll(configurations);
            }
            this.tableConfigurations.put(tenantId, allCfConfigurations);
        }
    }

    private void synchronizeTableMetaDataForTenant(int tenantId) throws ConfigurationException {
        ArrayList<TableConfiguration> allCfConfigurations = new ArrayList<TableConfiguration>();
        for (MetaDataPersistor persistor : this.metaDataPersistors) {
            List<TableConfiguration> configurations = persistor.getAllTableMetaData(Utils.getConnectionParameters(tenantId));
            allCfConfigurations.addAll(configurations);
        }
        this.tableConfigurations.put(tenantId, allCfConfigurations);
    }

    private class MetaDataSynchronizer
    implements Runnable {
        private final Log log = LogFactory.getLog(MetaDataSynchronizer.class);

        private MetaDataSynchronizer() {
        }

        @Override
        public void run() {
            this.log.info((Object)("Running meta data synchronizer for meta data at " + new Date()));
            try {
                try {
                    MetaDataManager.this.synchronizeIndexMetaData();
                }
                catch (ConfigurationException e) {
                    this.log.error((Object)"Error while fetching index meta data during synchronization..", (Throwable)e);
                }
            }
            catch (Throwable e) {
                this.log.error((Object)"ERROR WHILE SYNCHRONIZING INDEX META DATA.", e);
            }
            try {
                try {
                    MetaDataManager.this.synchronizeTableMetaData();
                }
                catch (ConfigurationException e) {
                    this.log.error((Object)"Error while fetching column family meta data during synchronization..", (Throwable)e);
                }
            }
            catch (Throwable e) {
                this.log.error((Object)"ERROR WHILE SYNCHRONIZING TABLE META DATA.", e);
            }
        }
    }
}

