/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.dataobjects;

import java.util.Map;

public class Record<V> {
    private final String key;
    private final Map<String, V> columns;

    public Record(String key, Map<String, V> columns) {
        this.key = key;
        if (key == null) {
            throw new RuntimeException("Record key should not be null..");
        }
        if (columns == null) {
            throw new RuntimeException("Record columns should not be null..");
        }
        this.columns = columns;
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, V> getColumns() {
        return this.columns;
    }

    public void addColumn(String key, V value) {
        this.columns.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record record = (Record)o;
        return !(this.key != null ? !this.key.equals(record.key) : record.key != null);
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }
}

