/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.configurations;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.TableConfiguration;

public abstract class AbstractTableConfiguration
implements TableConfiguration {
    private final String tableName;
    private final DataSourceType dataSourceType;
    private final List<String> columns;
    private boolean primaryTable;
    private List<String> secondaryTables;
    private boolean autoGenerated;

    public AbstractTableConfiguration(String tableName, List<String> columns, DataSourceType dataSourceType) {
        this.tableName = tableName;
        this.columns = columns;
        this.dataSourceType = dataSourceType;
        this.secondaryTables = new ArrayList<String>();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public void setPrimaryTable(boolean primaryTable) {
        this.primaryTable = primaryTable;
    }

    @Override
    public boolean isPrimaryTable() {
        return this.primaryTable;
    }

    @Override
    public void setSecondaryTables(List<String> secondaryTables) {
        this.secondaryTables = secondaryTables;
    }

    @Override
    public List<String> getSecondaryTables() {
        return this.secondaryTables;
    }

    @Override
    public void setAutoGenerated(boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    @Override
    public boolean getAutoGenerated() {
        return this.autoGenerated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractTableConfiguration)) {
            return false;
        }
        AbstractTableConfiguration that = (AbstractTableConfiguration)o;
        return !(this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null);
    }

    public int hashCode() {
        return this.tableName != null ? this.tableName.hashCode() : 0;
    }
}

