/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.configurations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.configurations.MetaDataPersistor;
import org.wso2.carbon.bam.core.dataobjects.Cursor;
import org.wso2.carbon.bam.core.dataobjects.Record;
import org.wso2.carbon.bam.core.internal.ServiceHolder;
import org.wso2.carbon.bam.core.persistence.PersistenceManager;
import org.wso2.carbon.bam.core.persistence.QueryIndex;
import org.wso2.carbon.bam.core.persistence.QueryManager;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;
import org.wso2.carbon.bam.core.utils.Utils;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;

public abstract class AbstractMetaDataPersistor
implements MetaDataPersistor {
    private static final String INDEX_REGISTRY_PATH = "indexes/";
    private static final String TABLE_REGISTRY_PATH = "tables/";
    private static final String CURSOR_REGISTRY_PATH = "cursors/";

    @Override
    public final void persistIndexMetaData(Map<String, String> credentials, IndexConfiguration configuration) throws ConfigurationException {
        int tenantId;
        try {
            tenantId = Utils.getTenantIdFromUserName(credentials.get("username"));
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to obtain tenant information", e);
        }
        try {
            this.updateIndexTracker(tenantId);
        }
        catch (RegistryException e) {
            throw new ConfigurationException("Unable to persist index meta data..", e);
        }
        this.persistIndex(credentials, configuration);
    }

    @Override
    public void deleteIndexMetaData(Map<String, String> credentials, String indexName) throws ConfigurationException {
        PersistenceManager persistenceManager = new PersistenceManager();
        try {
            persistenceManager.deleteRecord(credentials, "INDEX_INFO", indexName);
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to delete index meta data for index " + indexName + "..", e);
        }
    }

    @Override
    public int[] getAllTenantsWithDefinedIndexes() throws ConfigurationException {
        int[] tenantArray;
        try {
            Integer[] tenantsWithIndexes = this.getTenantsWithIndexes();
            tenantArray = new int[tenantsWithIndexes.length];
            for (int i = 0; i < tenantsWithIndexes.length; ++i) {
                tenantArray[i] = tenantsWithIndexes[i];
            }
        }
        catch (RegistryException e) {
            throw new ConfigurationException("Unable to fetch tenant index meta data from super tenant registry..", e);
        }
        return tenantArray;
    }

    @Override
    public void deleteTableMetaData(Map<String, String> credentials, String tableName) throws ConfigurationException {
        PersistenceManager persistenceManager = new PersistenceManager();
        try {
            persistenceManager.deleteRecord(credentials, "TABLE_INFO", tableName);
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to delete meta data for table " + tableName + "..", e);
        }
    }

    @Override
    public final void persistCursorMetaData(Map<String, String> credentials, Cursor cursor) throws ConfigurationException {
        Record<String> record = new Record<String>(cursor.getTable(), new HashMap());
        record.addColumn(cursor.getCursorName(), cursor.getResumePoint());
        PersistenceManager persistenceManager = new PersistenceManager();
        try {
            persistenceManager.storeRecord(credentials, "CURSOR_INFO", record);
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to store the cursor " + cursor.getCursorName() + "..", e);
        }
    }

    @Override
    public List<Cursor> getAllCursorMetaData(Map<String, String> credentials) throws ConfigurationException {
        QueryManager queryManager = new QueryManager();
        ArrayList<Cursor> cursors = new ArrayList<Cursor>();
        try {
            List<Record> records = queryManager.getRecords(credentials, "CURSOR_INFO", (QueryIndex)null, null);
            for (Record record : records) {
                String table = record.getKey();
                Map columns = record.getColumns();
                for (Map.Entry entry : columns.entrySet()) {
                    Cursor cursor = new Cursor(table, entry.getKey());
                    cursor.setResumePoint((String)entry.getValue());
                    cursors.add(cursor);
                }
            }
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to fetch cursor meta data..", e);
        }
        return cursors;
    }

    @Override
    public Cursor getCursorMetaData(Map<String, String> credentials, String table, String cursorName) throws ConfigurationException {
        QueryManager queryManager = new QueryManager();
        try {
            List<Record> records = queryManager.getRecords(credentials, "CURSOR_INFO", table, null);
            if (records != null && records.size() > 0) {
                Record record = records.get(0);
                Map columns = record.getColumns();
                String resumePoint = (String)columns.get(cursorName);
                Cursor cursor = new Cursor(table, cursorName);
                cursor.setResumePoint(resumePoint);
                return cursor;
            }
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to fetch meta data for cursor " + cursorName + "..", e);
        }
        return null;
    }

    @Override
    public void deleteCursorMetaData(Map<String, String> credentials, Cursor cursor) throws ConfigurationException {
        Record<Object> record = new Record<Object>(cursor.getTable(), new HashMap());
        record.addColumn(cursor.getCursorName(), null);
        PersistenceManager persistenceManager = new PersistenceManager();
        try {
            persistenceManager.storeRecord(credentials, "CURSOR_INFO", record);
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to delete cursor meta data for cursor " + cursor.getCursorName() + "..", e);
        }
    }

    public abstract void persistIndex(Map<String, String> var1, IndexConfiguration var2) throws ConfigurationException;

    private void updateIndexTracker(int tenantId) throws RegistryException {
        Resource tenantTrackerResource;
        String trackerPath;
        ConfigurationContext superTenantContext = ServiceHolder.getConfigurationContextService().getServerConfigContext();
        UserRegistry superTenantRegistry = ServiceHolder.getRegistryService().getConfigSystemRegistry(SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)superTenantContext).getTenantId());
        if (superTenantRegistry.resourceExists(trackerPath = "/components/org.wso2.carbon.bam.core/indexTracker")) {
            tenantTrackerResource = superTenantRegistry.get(trackerPath);
            ArrayList<String> propertyValues = tenantTrackerResource.getPropertyValues("tenants");
            if (propertyValues == null) {
                propertyValues = new ArrayList<String>();
            }
            propertyValues.add(String.valueOf(tenantId));
            HashSet<String> uniqueProperties = new HashSet<String>();
            uniqueProperties.addAll(propertyValues);
            propertyValues.clear();
            for (String id : uniqueProperties) {
                propertyValues.add(id);
            }
            tenantTrackerResource.setProperty("tenants", propertyValues);
        } else {
            tenantTrackerResource = superTenantRegistry.newResource();
            ArrayList<String> propertyValues = new ArrayList<String>();
            propertyValues.add(String.valueOf(tenantId));
            HashSet<String> uniqueProperties = new HashSet<String>();
            uniqueProperties.addAll(propertyValues);
            propertyValues.clear();
            for (String id : uniqueProperties) {
                propertyValues.add(id);
            }
            tenantTrackerResource.setProperty("tenants", propertyValues);
        }
        superTenantRegistry.put(trackerPath, tenantTrackerResource);
    }

    private Integer[] getTenantsWithIndexes() throws RegistryException {
        ConfigurationContext superTenantContext = ServiceHolder.getConfigurationContextService().getServerConfigContext();
        UserRegistry superTenantRegistry = ServiceHolder.getRegistryService().getConfigSystemRegistry(SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)superTenantContext).getTenantId());
        String trackerPath = "/components/org.wso2.carbon.bam.core/indexTracker";
        ArrayList<Integer> tenantsWithIndexes = new ArrayList<Integer>();
        if (superTenantRegistry.resourceExists(trackerPath)) {
            Resource tenantTrackerResource = superTenantRegistry.get(trackerPath);
            ArrayList propertyValues = tenantTrackerResource.getPropertyValues("tenants");
            if (propertyValues == null) {
                propertyValues = new ArrayList();
            }
            for (String propertyValue : propertyValues) {
                tenantsWithIndexes.add(Integer.valueOf(propertyValue));
            }
        }
        return tenantsWithIndexes.toArray(new Integer[0]);
    }
}

