/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.configurations;

import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.Granularity;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.configurations.IndexType;

public abstract class AbstractIndexConfiguration
implements IndexConfiguration {
    private final String indexName;
    private final IndexType indexType;
    private final String indexedTable;
    private final DataSourceType dataSourceType;
    private String[] indexedColumns;
    private boolean autoGenerated;
    private boolean manuallyIndexed;
    private Granularity granularity;

    public AbstractIndexConfiguration(String indexName, String indexedTable, String[] indexedColumns, DataSourceType dataSourceType) {
        this.indexName = indexName;
        this.indexType = indexedColumns != null && indexedColumns.length > 1 ? IndexType.COMPOSITE : IndexType.SINGLE;
        this.indexedTable = indexedTable;
        this.dataSourceType = dataSourceType;
        this.indexedColumns = indexedColumns;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public String getIndexedTable() {
        return this.indexedTable;
    }

    @Override
    public String[] getIndexedColumns() {
        return this.indexedColumns;
    }

    public void setIndexedColumns(String[] indexedColumns) {
        this.indexedColumns = indexedColumns;
    }

    @Override
    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    @Override
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    @Override
    public void setAutoGenerated(boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    @Override
    public Granularity getGranularity() {
        return this.granularity;
    }

    @Override
    public void setGranularity(Granularity granularity) {
        this.granularity = granularity;
    }

    @Override
    public boolean isManuallyIndexed() {
        return this.manuallyIndexed;
    }

    @Override
    public void setManuallyIndexed(boolean manuallyIndexed) {
        this.manuallyIndexed = manuallyIndexed;
    }
}

