/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.hadoop.ColumnFamilyInputFormat;
import org.apache.cassandra.hadoop.ColumnFamilyOutputFormat;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerSequence;
import org.wso2.carbon.bam.analyzer.engine.DataContext;

public class HadoopTest
extends Configured
implements Analyzer {
    static final String KEYSPACE = "wordcount";
    static final String COLUMN_FAMILY = "input_words";
    static final String OUTPUT_REDUCER_VAR = "output_reducer";
    static final String OUTPUT_COLUMN_FAMILY = "output_words";
    private static final String OUTPUT_PATH_PREFIX = "/tmp/word_count";
    private static final String CONF_COLUMN_NAME = "columnname";
    private static final Log logger = LogFactory.getLog(HadoopTest.class);

    @Override
    public void analyze(DataContext dataContext) {
        String outputReducerType = "filesystem";
        String columnName = "WorkFlowId";
        this.getConf().set(CONF_COLUMN_NAME, columnName);
        Job job = null;
        try {
            job = new Job(this.getConf(), KEYSPACE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        job.setJarByClass(HadoopTest.class);
        job.setMapperClass(TokenizerMapper.class);
        if (outputReducerType.equalsIgnoreCase("filesystem")) {
            job.setCombinerClass(ReducerToFilesystem.class);
            job.setReducerClass(ReducerToFilesystem.class);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(IntWritable.class);
            FileOutputFormat.setOutputPath((Job)job, (Path)new Path(OUTPUT_PATH_PREFIX));
        } else {
            job.setReducerClass(ReducerToCassandra.class);
            job.setMapOutputKeyClass(Text.class);
            job.setMapOutputValueClass(IntWritable.class);
            job.setOutputKeyClass(ByteBuffer.class);
            job.setOutputValueClass(List.class);
            job.setOutputFormatClass(ColumnFamilyOutputFormat.class);
            ConfigHelper.setOutputColumnFamily((Configuration)job.getConfiguration(), (String)KEYSPACE, (String)OUTPUT_COLUMN_FAMILY);
        }
        job.setInputFormatClass(ColumnFamilyInputFormat.class);
        ConfigHelper.setInputRpcPort((Configuration)job.getConfiguration(), (String)"9160");
        ConfigHelper.setInputInitialAddress((Configuration)job.getConfiguration(), (String)"localhost");
        ConfigHelper.setInputPartitioner((Configuration)job.getConfiguration(), (String)"org.apache.cassandra.dht.RandomPartitioner");
        ConfigHelper.setInputColumnFamily((Configuration)job.getConfiguration(), (String)KEYSPACE, (String)COLUMN_FAMILY);
        SlicePredicate predicate = new SlicePredicate().setColumn_names(Arrays.asList(ByteBufferUtil.bytes((String)columnName)));
        ConfigHelper.setInputSlicePredicate((Configuration)job.getConfiguration(), (SlicePredicate)predicate);
        try {
            job.waitForCompletion(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setAnalyzerSeqeunceName(String analyzerSequence) {
    }

    @Override
    public String getAnalyzerSequenceName() {
        return null;
    }

    @Override
    public void setPositionInSequence(int positionInSequence) {
    }

    @Override
    public int getPositionInSequence() {
        return 0;
    }

    @Override
    public AnalyzerSequence getAnalyzerSequence() {
        return null;
    }

    @Override
    public void setAnalyzerSequence(AnalyzerSequence analyzerSequence) {
    }

    public static class ReducerToCassandra
    extends Reducer<Text, IntWritable, ByteBuffer, List<Mutation>> {
        private ByteBuffer outputKey;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.outputKey = ByteBufferUtil.bytes((String)context.getConfiguration().get(HadoopTest.CONF_COLUMN_NAME));
        }

        public void reduce(Text word, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            context.write((Object)this.outputKey, Collections.singletonList(ReducerToCassandra.getMutation(word, sum)));
        }

        private static Mutation getMutation(Text word, int sum) {
            Column c = new Column();
            c.setName(Arrays.copyOf(word.getBytes(), word.getLength()));
            c.setValue(ByteBufferUtil.bytes((String)String.valueOf(sum)));
            c.setTimestamp(System.currentTimeMillis());
            Mutation m = new Mutation();
            m.setColumn_or_supercolumn(new ColumnOrSuperColumn());
            m.column_or_supercolumn.setColumn(c);
            return m;
        }
    }

    public static class ReducerToFilesystem
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            context.write((Object)key, (Object)new IntWritable(sum));
        }
    }

    public static class TokenizerMapper
    extends Mapper<ByteBuffer, SortedMap<ByteBuffer, IColumn>, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private Text word = new Text();
        private ByteBuffer sourceColumn;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.sourceColumn = ByteBufferUtil.bytes((String)context.getConfiguration().get(HadoopTest.CONF_COLUMN_NAME));
        }

        public void map(ByteBuffer key, SortedMap<ByteBuffer, IColumn> columns, Mapper.Context context) throws IOException, InterruptedException {
            IColumn column = (IColumn)columns.get(this.sourceColumn);
            if (column == null) {
                return;
            }
            String value = ByteBufferUtil.string((ByteBuffer)column.value());
            logger.debug((Object)("read " + key + ":" + value + " from " + context.getInputSplit()));
            StringTokenizer itr = new StringTokenizer(value);
            while (itr.hasMoreTokens()) {
                this.word.set(itr.nextToken());
                context.write((Object)this.word, (Object)one);
            }
        }
    }
}

